<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  version="2.0" xmlns:iso="http://purl.oclc.org/dsdl/schematron">
  
  <xsl:key name="ap" match="iso:pattern[@abstract='true']" use="@id"/>
  
  <xsl:template match="node() | @*">
    <xsl:copy>
      <xsl:apply-templates select="node() | @*"/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="iso:pattern[@abstract='true']"/>

  <xsl:template match="iso:pattern[@is-a]">
    <xsl:copy>
      <xsl:copy-of select="@*[not(name()='is-a')]"/>
      <xsl:variable name="ap" select="key('ap', @is-a)"/>
      <xsl:if test="not($ap)">
        <xsl:message terminate="no">
          Error: Cannot find abstract pattern <xsl:value-of select="@is-a"/> referred from pattern <xsl:value-of select="@id"/>.
        </xsl:message>
      </xsl:if>
      <xsl:if test="$ap[2]">
        <xsl:message terminate="no">
          Error: More than one definitions for abstract pattern <xsl:value-of select="@is-a"/> referred from pattern <xsl:value-of select="@id"/>.
        </xsl:message>
      </xsl:if>
      
      <xsl:for-each select="iso:param">
        <xsl:variable name="paramLength" select="string-length(@name)"/>
        <xsl:variable name="apos">'</xsl:variable>
        <xsl:if test="@name = $ap[1]//iso:let/@name/substring(., 1, $paramLength)">
          <xsl:message terminate="no">
            Error: Conflict between pattern parameters
            <xsl:if test="../@id">
              referred from pattern '<xsl:value-of select="../@id"/>'  
            </xsl:if>           
            and variables defined in the abstract pattern '<xsl:value-of select="../@is-a"/>': 
            parameter '<xsl:value-of select="@name"/>' and variable(s): 
            <xsl:value-of select="$ap[1]//iso:let[starts-with(@name, current()/@name)]/concat($apos, @name, $apos)" separator=", "/>. 
            Please use variable names that don't start with parameters names.
          </xsl:message>
        </xsl:if>
      </xsl:for-each>
        
      <xsl:apply-templates
        select="$ap[1]/node()"
        mode="instantiate">
        <xsl:with-param name="params" select="iso:param[not(@name = $ap[1]//iso:let/@name)]"/>
      </xsl:apply-templates>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="* | processing-instruction() | comment()" mode="instantiate">
    <xsl:param name="params"/>
    <xsl:copy>
      <xsl:apply-templates select="node() | @*" mode="instantiate">
        <xsl:with-param name="params" select="$params"/>
      </xsl:apply-templates>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="@*" mode="instantiate">
    <xsl:param name="params"/>
    <xsl:choose>
      <xsl:when test="contains(., '$')">
        <xsl:attribute name="{name()}">
          <xsl:call-template name="replaceParameters">
            <xsl:with-param name="params" select="$params"/>
            <xsl:with-param name="value" select="."/>
          </xsl:call-template>
        </xsl:attribute>
      </xsl:when>
      <xsl:otherwise>
        <xsl:copy/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="replaceParameters">
    <xsl:param name="params"/>
    <xsl:param name="value"/>
    <xsl:choose>
      <xsl:when test="count($params)=0">
        <xsl:value-of select="$value"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="replaceParameters">
          <xsl:with-param name="params" select="$params[position()>1]"/>
          <xsl:with-param name="value">
            <xsl:call-template name="replaceParameter">
              <xsl:with-param name="param" select="$params[1]"/>
              <xsl:with-param name="value" select="$value"/>
            </xsl:call-template>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="replaceParameter">
    <xsl:param name="value"/>
    <xsl:param name="param"/>
    <xsl:variable name="pname" select="concat('$',  $param/@name)"/>
    <xsl:choose>
      <xsl:when test="not(contains($value, $pname))">
        <xsl:value-of select="$value"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:variable name="before" select="substring-before($value, $pname)"/>
        <xsl:variable name="after" select="substring-after($value, $pname)"/>
        <xsl:value-of select="$before"/>
        <xsl:value-of select="$param/@value"/>
        <xsl:call-template name="replaceParameter">
          <xsl:with-param name="param" select="$param"/>
          <xsl:with-param name="value" select="$after"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <!-- Expand variables in text nodes. -->
  <xsl:template match="text()" mode="instantiate">
    <xsl:param name="params"/>
    <xsl:choose>
      <xsl:when test="contains(., '$')">
        <xsl:call-template name="replaceParameters">
          <xsl:with-param name="params" select="$params"/>
          <xsl:with-param name="value" select="."/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:copy/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>
