package ro.sync.lexer.batch;
import ro.sync.lexer.AbstractLexer;

@SuppressWarnings("unused")
%%

%public 
%class BatchLexer
%extends AbstractLexer
%unicode
%char
%type ro.sync.lexer.Symbol
 
%ignorecase
%scanerror ro.sync.lexer.LexerException

%{
    private static final byte SYM_KEYWORD           = BatchTokens.KEYWORD;
    private static final byte SYM_COMMAND           = BatchTokens.COMMAND;
    private static final byte SYM_LABEL             = BatchTokens.LABEL;
    private static final byte SYM_TEXT              = BatchTokens.TEXT;
    private static final byte SYM_OPERATOR          = BatchTokens.OPERATOR;
    private static final byte SYM_COMMENT           = BatchTokens.COMMENT;
    private static final byte SYM_PARAM_NUMBER      = BatchTokens.PARAM_NUMBER;
    private static final byte SYM_PARAMETER         = BatchTokens.PARAMETER;
    private static final byte SYM_STRING_DQ         = BatchTokens.STRING_DQ;

    /**
     * Create an empty lexer, yyreset will be called later to reset and assign
     * the reader
     */
    public BatchLexer() {
        super();
    }
    
    public String getName() {
      return BATCH_LEXER;
    }
%}

%xstate COMMENT

Keyword = "@" | "goto" | "call" | "exit" | "if" | "else" | "for" | "errorlevel" | "exist"

Command = "append" | "assoc" | "at" | "attrib" | "break" | "cacls" | "cd" | "chcp" | "chdir" 
          | "chkdsk" | "chkntfs" | "cls" | "cmd" | "color" | "comp" | "compact" | "convert" 
          | "copy" | "date" | "del" | "dir" | "diskcomp" | "diskcopy" | "doskey" | "echo" 
          | "endlocal" | "erase" | "fc" | "find" | "findstr" | "format" | "ftype" | "graftabl" 
          | "help" | "keyb" | "label" | "md" | "mkdir" | "mode" | "more" | "move" | "path" 
          | "pause" | "popd" | "print" | "prompt" | "pushd" | "rd" | "recover" | "ren" 
          | "rename" | "replace" | "restore" | "rmdir" | "set" | "setlocal" | "shift" | "sort" 
          | "start" | "subst" | "time" | "title" | "tree" | "type" | "ver" | "verify" | "vol" 
          | "xcopy"

ExpandingMacro = [fdpnxsatz]
Label = ":" [a-zA-Z][a-zA-Z0-9_]*
ParamNumber = "%" [0-9*]
ExpandingParamNumber = "%~" {ExpandingMacro}* ("$" [a-zA-Z][a-zA-Z0-9_]* ":")? [0-9]
Parameter = "%" [a-zA-Z][a-zA-Z0-9_]* "%" 
Char = .
GeneralChar = [^ \t=@%]

DQStringContent =  ([^\"]|\\\")*
DQUnclosedString =  \"{DQStringContent}
DQString =  {DQUnclosedString}\"

%%

<YYINITIAL> 
{
    {Keyword}                   {   return symbol(SYM_KEYWORD);         }
    {Command}                   {   return symbol(SYM_COMMAND);         }
    {Label}                     {   return symbol(SYM_LABEL);           }
    "rem"                       { 
                                    yypushback(3);
                                    yybegin(COMMENT);   
                                }
    "="                         {   return symbol(SYM_OPERATOR);        }
    {ParamNumber}               {   return symbol(SYM_PARAM_NUMBER);    }
    {ExpandingParamNumber}      {   return symbol(SYM_PARAM_NUMBER);    }
    {Parameter}                 {   return symbol(SYM_PARAMETER);       }
    // Strings 
    {DQString}                  {   return symbol(SYM_STRING_DQ);       }
    [ \t]+                      {   return symbol(SYM_TEXT);            }
    {GeneralChar}+              {   return symbol(SYM_TEXT);            }
}

<COMMENT> 
{
    {Char}                      {   cLen++;                             }
    <<EOF>>                     {   
                                    yybegin(YYINITIAL);
                                    return flush(SYM_COMMENT);
                                }
}