/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.util.Collection;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.function.FnData;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDouble;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSFloat;

public class FnAbs
extends Function {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xml.xpath2.processor.internal.function.FnAbs");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public FnAbs() {
        super(new QName("abs"), 1);
    }

    public ResultSequence evaluate(Collection args) throws DynamicError {
        if (!($assertionsDisabled || args.size() >= this.min_arity() && args.size() <= this.max_arity())) {
            throw new AssertionError();
        }
        ResultSequence argument = (ResultSequence)args.iterator().next();
        return FnAbs.fn_abs(argument);
    }

    public static ResultSequence fn_abs(ResultSequence arg) throws DynamicError {
        NumericType dat;
        ResultSequence rs = ResultSequenceFactory.create_new();
        NumericType nt = FnAbs.get_single_numeric_arg(arg);
        if (nt == null) {
            return rs;
        }
        if (nt instanceof XSDouble) {
            dat = (XSDouble)nt;
            if (((XSDouble)dat).zero() || ((XSDouble)dat).negativeZero()) {
                rs.add(new XSDouble("0"));
                return rs;
            }
            if (((XSDouble)dat).infinite()) {
                rs.add(new XSDouble(Double.POSITIVE_INFINITY));
                return rs;
            }
        }
        if (nt instanceof XSFloat) {
            dat = (XSFloat)nt;
            if (((XSFloat)dat).zero() || ((XSFloat)dat).negativeZero()) {
                rs.add(new XSFloat(new Float(0.0f).floatValue()));
                return rs;
            }
            if (((XSFloat)dat).infinite()) {
                rs.add(new XSFloat(Float.POSITIVE_INFINITY));
                return rs;
            }
        }
        rs.add(nt.abs());
        return rs;
    }

    public static NumericType get_single_numeric_arg(ResultSequence arg) throws DynamicError {
        int size = arg.size();
        if (size > 1) {
            DynamicError.throw_type_error();
        }
        if (size == 0) {
            return null;
        }
        AnyType at = arg.first();
        NumericType numericTypeResult = null;
        if (at instanceof NumericType) {
            numericTypeResult = (NumericType)at;
        } else {
            AnyType atomizedArg = FnData.atomize(at);
            if (!(atomizedArg instanceof NumericType)) {
                throw DynamicError.invalidType();
            }
            numericTypeResult = (NumericType)atomizedArg;
        }
        return numericTypeResult;
    }
}

