/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.util;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;

public class CanonicalStringSet
extends AbstractSet {
    private final char separator;
    private final SortedMap map = new TreeMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public CanonicalStringSet(char c) {
        this.separator = c;
    }

    public CanonicalStringSet(char c, CanonicalStringSet canonicalStringSet) {
        this.separator = c;
        if (canonicalStringSet != null) {
            this.addAll(canonicalStringSet);
        }
    }

    public CanonicalStringSet(char c, String string) {
        this.separator = c;
        if (string != null) {
            this.addAll(string);
        }
    }

    protected String canonical(String string) {
        return this.canonicalize(string);
    }

    protected String canonicalize(String string) {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && string.indexOf(this.separator) >= 0) {
            throw new AssertionError((Object)"separator in string is illegal");
        }
        return string;
    }

    public final boolean isEmpty() {
        return super.isEmpty();
    }

    public final int size() {
        return this.map.size();
    }

    public final boolean contains(Object object) {
        return this.containsAll((String)object);
    }

    public final Iterator iterator() {
        return this.map.keySet().iterator();
    }

    public final Iterator originalIterator() {
        return this.map.values().iterator();
    }

    public final Object[] toArray() {
        return this.map.keySet().toArray();
    }

    public final Object[] toArray(Object[] objectArray) {
        return this.map.keySet().toArray(objectArray);
    }

    public final boolean add(Object object) {
        return this.addAll((String)object);
    }

    public final boolean remove(Object object) {
        return this.removeAll((String)object);
    }

    public final boolean containsAll(CanonicalStringSet canonicalStringSet) {
        return this.map.keySet().containsAll(canonicalStringSet.map.keySet());
    }

    public final boolean containsAll(String string) {
        CanonicalStringIterator canonicalStringIterator = new CanonicalStringIterator(string);
        while (canonicalStringIterator.hasNext()) {
            if (this.map.containsKey(canonicalStringIterator.next())) continue;
            return false;
        }
        return true;
    }

    public final boolean addAll(CanonicalStringSet canonicalStringSet) {
        return super.addAll(canonicalStringSet);
    }

    public final boolean addAll(String string) {
        boolean bl = false;
        StringIterator stringIterator = new StringIterator(string);
        while (stringIterator.hasNext()) {
            String string2 = (String)stringIterator.next();
            String string3 = this.canonicalize(string2);
            if (string3 == null) continue;
            String string4 = this.map.put(string3, string2);
            if (bl) continue;
            bl = string4 == null || !string2.equals(string4);
        }
        return bl;
    }

    public final boolean retainAll(CanonicalStringSet canonicalStringSet) {
        return this.map.keySet().retainAll(canonicalStringSet.map.keySet());
    }

    public final boolean retainAll(String string) {
        class CustomSet
        extends CanonicalStringSet {
            private final /* synthetic */ String val$list;

            CustomSet(String string) {
                this.val$list = string;
                super(CanonicalStringSet.this.separator);
                super.addAll(this.val$list);
            }

            protected String canonicalize(String string) {
                return CanonicalStringSet.this.canonicalize(string);
            }
        }
        return this.map.keySet().retainAll(new CustomSet(string));
    }

    public final boolean removeAll(CanonicalStringSet canonicalStringSet) {
        return this.map.keySet().removeAll(canonicalStringSet.map.keySet());
    }

    public final boolean removeAll(String string) {
        boolean bl = false;
        CanonicalStringIterator canonicalStringIterator = new CanonicalStringIterator(string);
        while (canonicalStringIterator.hasNext()) {
            bl |= this.map.remove(canonicalStringIterator.next()) != null;
        }
        return bl;
    }

    public final void clear() {
        this.map.clear();
    }

    public final String toString() {
        Iterator iterator = this.iterator();
        if (iterator.hasNext()) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            do {
                String string = (String)iterator.next();
                if (n++ > 0) {
                    stringBuffer.append(this.separator);
                }
                stringBuffer.append(string);
            } while (iterator.hasNext());
            return stringBuffer.toString();
        }
        return "";
    }

    static {
        $assertionsDisabled = !CanonicalStringSet.class.desiredAssertionStatus();
    }

    private class StringIterator
    implements Iterator {
        private final String[] split;
        private int i = 0;

        private StringIterator(String string) {
            this.split = string.split("\\" + CanonicalStringSet.this.separator);
        }

        public boolean hasNext() {
            return this.i < this.split.length;
        }

        public Object next() {
            try {
                return this.split[this.i++];
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class CanonicalStringIterator
    implements Iterator {
        private final Iterator i;
        private String canonical;

        private CanonicalStringIterator(String string) {
            this.i = new StringIterator(string);
            this.advance();
        }

        public boolean hasNext() {
            return this.canonical != null;
        }

        public Object next() {
            if (this.canonical == null) {
                throw new NoSuchElementException();
            }
            String string = this.canonical;
            this.advance();
            return string;
        }

        private void advance() {
            while (this.i.hasNext()) {
                this.canonical = CanonicalStringSet.this.canonicalize((String)this.i.next());
                if (this.canonical == null) continue;
                return;
            }
            this.canonical = null;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

