/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.crypto.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.InvalidCipherTextException;

public class CipherOutputStream
extends FilterOutputStream {
    protected BufferedBlockCipher cipher;
    private byte[] outBuf = new byte[0];
    private boolean closed;

    public CipherOutputStream(OutputStream outputStream, BufferedBlockCipher bufferedBlockCipher) {
        super(outputStream);
        this.cipher = bufferedBlockCipher;
    }

    public void write(int n) throws IOException {
        this.ensureInit();
        int n2 = this.cipher.getUpdateOutputSize(1);
        if (n2 > this.outBuf.length) {
            this.outBuf = new byte[n2];
        }
        if ((n2 = this.cipher.processByte((byte)n, this.outBuf, 0)) > 0) {
            this.out.write(this.outBuf, 0, n2);
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.ensureInit();
        int n3 = this.cipher.getUpdateOutputSize(n2);
        if (n3 > this.outBuf.length) {
            this.outBuf = new byte[n3];
        }
        n3 = this.cipher.processBytes(byArray, n, n2, this.outBuf, 0);
        this.out.write(this.outBuf, 0, n3);
    }

    public void finish() throws IOException {
        this.ensureInit();
        int n = this.cipher.getOutputSize(0);
        if (n > this.outBuf.length) {
            this.outBuf = new byte[n];
        }
        try {
            n = this.cipher.doFinal(this.outBuf, 0);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            IOException iOException = new IOException(invalidCipherTextException.toString());
            iOException.initCause(invalidCipherTextException);
            throw iOException;
        }
        this.out.write(this.outBuf, 0, n);
        this.out.flush();
    }

    private final void ensureInit() throws IOException {
        if (this.cipher == null) {
            throw new IOException("CipherOutputStream has already been closed or is not initialized!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            try {
                this.finish();
            }
            finally {
                this.cipher = null;
                super.close();
            }
        }
    }
}

