/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.net.protocol.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.FileNameMap;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.io.FileSystemUtil;
import ro.sync.net.protocol.e;
import ro.sync.net.protocol.file.b;
import ro.sync.net.protocol.j;
import ro.sync.util.BasicURLUtil;

@SkipObfuscate(classes=SkipLevel.PUBLIC, fields=SkipLevel.PROTECTED, methods=SkipLevel.PROTECTED)
public class FileURLConnection
extends URLConnection
implements e,
j {
    private static b k;
    protected File file = null;

    public FileURLConnection(URL uRL) {
        super(uRL);
        this.file = BasicURLUtil.getCanonicalFileFromFileUrl(uRL);
    }

    @Override
    public void connect() {
        this.connected = true;
    }

    @Override
    public String getHeaderField(String string) {
        if ("content-length".equals(string)) {
            return String.valueOf(this.file.length());
        }
        if ("last-modified".equals(string)) {
            return new Date(this.file.lastModified()).toString();
        }
        if ("content-type".equals(string) && this.file != null && !this.file.isDirectory()) {
            FileNameMap fileNameMap = URLConnection.getFileNameMap();
            String string2 = fileNameMap.getContentTypeFor(this.file.toString());
            if (string2 == null) {
                string2 = "text/plain";
            }
            return string2;
        }
        return null;
    }

    @Override
    public String getHeaderField(int n2) {
        switch (n2) {
            case 0: {
                return String.valueOf(this.file.length());
            }
            case 1: {
                return String.valueOf(this.file.lastModified());
            }
        }
        return null;
    }

    @Override
    public String getHeaderFieldKey(int n2) {
        switch (n2) {
            case 0: {
                return "content-length";
            }
            case 1: {
                return "last-modified";
            }
        }
        return null;
    }

    @Override
    public long getLastModified() {
        return this.file.lastModified();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        RandomAccessFile randomAccessFile;
        block3: {
            boolean bl = this.file.exists();
            randomAccessFile = new RandomAccessFile(this.file, "rw");
            if (k != null && !bl) {
                k.b(this.file);
            }
            try {
                randomAccessFile.setLength(0L);
            }
            catch (IOException iOException) {
                if (randomAccessFile.length() == 0L) break block3;
                throw iOException;
            }
        }
        return new OutputStream(){

            @Override
            public void write(int n2) throws IOException {
                randomAccessFile.write(n2);
            }

            @Override
            public void close() throws IOException {
                randomAccessFile.close();
            }

            @Override
            public void write(byte[] byArray, int n2, int n3) throws IOException {
                randomAccessFile.write(byArray, n2, n3);
            }
        };
    }

    @Override
    public void removeResource() throws IOException {
        this.connect();
        if (this.file != null) {
            FileSystemUtil.deleteRecursivelly(this.file);
        }
    }

    public static void setFileURLConnectionListener(b b2) {
        k = b2;
    }
}

