/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.editor.welcomescreen.content;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.exml.editor.welcomescreen.content.b;
import ro.sync.exml.editor.welcomescreen.content.c;
import ro.sync.util.URLUtil;

@XmlAccessorType(value=XmlAccessType.FIELD)
@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class UpcomingEvent
implements b {
    private static final File EVENTS_IMG_FOLDER = new File(c.j, "events");
    public static final Comparator<UpcomingEvent> UPCOMING_EVENTS_SORTER_BY_DATE = new Comparator<UpcomingEvent>(){

        public int b(UpcomingEvent upcomingEvent, UpcomingEvent upcomingEvent2) {
            int n2 = -1;
            try {
                n2 = upcomingEvent.getEventStartDate().compareTo(upcomingEvent2.getEventStartDate());
                if (n2 == 0) {
                    n2 = upcomingEvent.getEventEndDate().compareTo(upcomingEvent2.getEventEndDate());
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return n2;
        }
    };
    @XmlAttribute(name="title")
    private String eventName;
    @XmlAttribute(name="startDate")
    private String eventStartDate;
    @XmlAttribute(name="endDate")
    private String eventEndDate;
    @XmlAttribute(name="url")
    private String eventURL;
    @XmlAttribute(name="location")
    private String eventLocation;
    @XmlAttribute(name="img")
    private String eventImageURL;
    private URL eventLocalImageURL;
    private static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("d.MM.yyyy");

    UpcomingEvent() {
    }

    public String getEventName() {
        return this.eventName.replaceAll("\\s+", " ").trim();
    }

    public Date getEventStartDate() throws ParseException {
        return simpleDateFormat.parse(this.eventStartDate);
    }

    public Date getEventEndDate() throws ParseException {
        return simpleDateFormat.parse(this.eventEndDate != null ? this.eventEndDate : this.eventStartDate);
    }

    public String getEventURL() {
        return this.eventURL;
    }

    public String getEventLocation() {
        if (this.eventLocation != null) {
            return this.eventLocation.replaceAll("\\s+", " ").trim();
        }
        return this.eventLocation;
    }

    @Override
    public String getImageURLAsString() {
        return this.eventImageURL;
    }

    public URL getEventLocalImageURL() {
        if (this.eventLocalImageURL == null && this.eventImageURL != null) {
            String string = URLUtil.extractFileName(this.eventImageURL);
            try {
                File file = new File(EVENTS_IMG_FOLDER, string);
                if (file.exists()) {
                    this.eventLocalImageURL = URLUtil.correct(file);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return this.eventLocalImageURL;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getEventName());
        stringBuilder.append(" Location: ").append(this.eventLocation);
        stringBuilder.append("\n StartDate: ").append(this.eventStartDate);
        stringBuilder.append(" EndDate: ").append(this.eventEndDate);
        stringBuilder.append("\n URL: ").append(this.eventURL);
        stringBuilder.append("\n img URL: ").append(this.eventImageURL);
        return stringBuilder.toString();
    }
}

