/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.editor.validate;

import ro.sync.annotations.dt.PersistentObjectField;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.exml.editor.validate.ValidationEngine;
import ro.sync.exml.editor.validate.ValidationUnitSchema;
import ro.sync.exml.editor.validate.ValidationUnitType;
import ro.sync.options.PersistentObject;
import ro.sync.options.j;
import ro.sync.util.Equaler;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class ValidationUnit
implements PersistentObject {
    public static final String DEFAULT_ENGINE = "<Default engine>";
    public static final String XERCES_ENGINE = "Xerces";
    public static final String DITA_ENGINE = "DITA Validation";
    public static final String ANT_ENGINE = "ANT Validator";
    private ValidationUnitType validationType;
    @PersistentObjectField(hasEditorVariables=true)
    private String url;
    private ValidationEngine validationEngine;
    private boolean allowAutomaticValidation;
    @PersistentObjectField(hasEditorVariables=true)
    private String[] extensions;
    private ValidationUnitSchema validationSchema;

    public ValidationUnit(String string, ValidationEngine validationEngine, boolean bl, String[] stringArray, ValidationUnitType validationUnitType, ValidationUnitSchema validationUnitSchema) {
        this.url = string;
        this.validationEngine = validationEngine;
        this.allowAutomaticValidation = bl;
        this.extensions = stringArray;
        this.validationType = validationUnitType;
        this.validationSchema = validationUnitSchema;
    }

    public ValidationUnitType getValidationType() {
        return this.validationType;
    }

    public ValidationUnitSchema getValidationSchema() {
        return this.validationSchema;
    }

    public ValidationUnit() {
    }

    public boolean allowAutomaticValidation() {
        return this.allowAutomaticValidation;
    }

    public void setAllowAutomaticValidation(boolean bl) {
        this.allowAutomaticValidation = bl;
    }

    public ValidationEngine getValidationEngine() {
        return this.validationEngine;
    }

    public void setValidationEngine(ValidationEngine validationEngine) {
        this.validationEngine = validationEngine;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    @Override
    public void checkValid() throws j {
        if (this.url == null) {
            throw new j("Invalid URL in validation unit.");
        }
        if (this.validationEngine == null) {
            throw new j("Invalid engine in validation unit.");
        }
        if (this.validationType == null) {
            throw new j("Invalid validation type.");
        }
    }

    public boolean equals(Object object) {
        boolean bl = object instanceof ValidationUnit;
        if (bl) {
            ValidationUnit validationUnit = (ValidationUnit)object;
            bl = this.url.equals(validationUnit.url) && this.validationEngine.equals(validationUnit.validationEngine) && this.allowAutomaticValidation == validationUnit.allowAutomaticValidation && Equaler.verifyArrayEquals(this.extensions, validationUnit.extensions) && Equaler.verifyEquals(this.validationType, validationUnit.validationType) && Equaler.verifyEquals(this.validationSchema, validationUnit.validationSchema);
        }
        return bl;
    }

    @Override
    public Object clone() {
        ValidationUnit validationUnit = null;
        try {
            validationUnit = (ValidationUnit)super.clone();
            if (this.extensions != null) {
                validationUnit.extensions = (String[])this.extensions.clone();
            }
            if (this.validationEngine != null) {
                validationUnit.validationEngine = (ValidationEngine)this.validationEngine.clone();
            }
            if (this.validationType != null) {
                validationUnit.validationType = (ValidationUnitType)this.validationType.clone();
            }
            if (this.validationSchema != null) {
                validationUnit.validationSchema = (ValidationUnitSchema)this.validationSchema.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return validationUnit;
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    public void setExtensions(String[] stringArray) {
        this.extensions = stringArray;
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    public void setValidationType(ValidationUnitType validationUnitType) {
        this.validationType = validationUnitType;
    }

    public void setValidationSchema(ValidationUnitSchema validationUnitSchema) {
        this.validationSchema = validationUnitSchema;
    }

    public String toString() {
        return "Validation unit. url: " + this.getUrl();
    }
}

