/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations.text;

import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.apache.log4j.Logger;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.content.TextContentIterator;
import ro.sync.ecss.extensions.api.content.TextContext;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class SelectedTextOperation
implements AuthorOperation {
    private static final Logger logger = Logger.getLogger((String)SelectedTextOperation.class.getName());

    @Override
    public ArgumentDescriptor[] getArguments() {
        return null;
    }

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws IllegalArgumentException, AuthorOperationException {
        AuthorEditorAccess authorEditorAccess = authorAccess.getEditorAccess();
        if (authorEditorAccess.hasSelection()) {
            AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
            int n2 = authorEditorAccess.getSelectionStart();
            int n3 = authorEditorAccess.getSelectionEnd();
            try {
                Position position = authorDocumentController.createPositionInContent(n3);
                this.processContentRange(authorDocumentController, n2, n3 - 1);
                authorEditorAccess.select(n2, position.getOffset());
            }
            catch (BadLocationException badLocationException) {
                logger.error((Object)badLocationException, (Throwable)badLocationException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processContentRange(AuthorDocumentController authorDocumentController, int n2, int n3) throws AuthorOperationException, BadLocationException {
        TextContentIterator textContentIterator = authorDocumentController.getTextContentIterator(n2, n3);
        try {
            authorDocumentController.beginCompoundEdit();
            while (textContentIterator.hasNext()) {
                TextContext textContext = textContentIterator.next();
                if (textContext.getEditableState() != 0 && textContext.getEditableState() != 1) continue;
                String string = ((Object)textContext.getText()).toString();
                string = this.processText(string);
                textContext.replaceText(string);
            }
        }
        finally {
            authorDocumentController.endCompoundEdit();
        }
    }

    protected abstract String processText(String var1);
}

