/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.text.BadLocationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.XPathVersion;
import ro.sync.ecss.extensions.api.node.AuthorNode;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class OpenInSystemAppOperation
implements AuthorOperation {
    private static final Logger logger = Logger.getLogger((String)OpenInSystemAppOperation.class.getName());
    private static final String ARGUMENT_RESOURCE_PATH = "resourcePath";
    private static final String ARGUMENT_UNPARSED_ENTITY = "isUnparsedEntity";
    private ArgumentDescriptor[] arguments = new ArgumentDescriptor[2];

    public OpenInSystemAppOperation() {
        ArgumentDescriptor argumentDescriptor;
        this.arguments[0] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_RESOURCE_PATH, 2, "An XPath expression that gives the path of the resource that must be opened.");
        this.arguments[1] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_UNPARSED_ENTITY, 3, "True if the value returned by the resourcePath argument represents the name of an unparsed entity.", new String[]{"true", "false"}, "false");
    }

    @Override
    public String getDescription() {
        return "Open in default system application";
    }

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws IllegalArgumentException, AuthorOperationException {
        Object object = argumentsMap.getArgumentValue(ARGUMENT_RESOURCE_PATH);
        if (object != null && ((String)object).trim().length() > 0) {
            Object[] objectArray = authorAccess.getDocumentController().evaluateXPath((String)object, null, false, true, true, false, XPathVersion.XPATH_3_0);
            if (objectArray != null && objectArray.length > 0) {
                String string = null;
                if (objectArray[0] instanceof String) {
                    string = (String)objectArray[0];
                } else if (objectArray[0] instanceof Node) {
                    string = ((Node)objectArray[0]).getNodeValue();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Relative location " + string));
                }
                if (string != null) {
                    Object object2;
                    Object object3;
                    URL uRL = null;
                    int n2 = authorAccess.getEditorAccess().getCaretOffset();
                    AuthorNode authorNode = null;
                    if (n2 > 0) {
                        try {
                            authorNode = authorAccess.getDocumentController().getNodeAtOffset(n2);
                        }
                        catch (BadLocationException badLocationException) {
                            logger.error((Object)badLocationException, (Throwable)badLocationException);
                        }
                    }
                    if (authorNode == null) {
                        authorNode = authorAccess.getDocumentController().getAuthorDocumentNode();
                    }
                    if ("true".equals(object3 = argumentsMap.getArgumentValue(ARGUMENT_UNPARSED_ENTITY))) {
                        object2 = authorAccess.getDocumentController().getUnparsedEntityUri(authorNode, string);
                        if (object2 != null) {
                            try {
                                uRL = new URL((String)object2);
                            }
                            catch (MalformedURLException malformedURLException) {
                                logger.error((Object)malformedURLException, (Throwable)malformedURLException);
                            }
                        }
                    } else {
                        uRL = authorAccess.getXMLUtilAccess().resolvePathThroughCatalogs(authorNode != null ? authorNode.getXMLBaseURL() : authorAccess.getEditorAccess().getEditorLocation(), string, true, true);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Absolute location to open: " + uRL));
                    }
                    if (uRL != null) {
                        object2 = authorAccess.getUtilAccess().locateFile(uRL);
                        if (object2 != null && !((File)object2).exists()) {
                            throw new AuthorOperationException("Resource does not exists: " + uRL);
                        }
                        authorAccess.getWorkspaceAccess().openInExternalApplication(uRL, true);
                    }
                }
            } else {
                throw new AuthorOperationException("The resource path XPath must evaluate to a string or node: " + object);
            }
        }
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }
}

