/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import javax.swing.text.BadLocationException;
import javax.xml.namespace.QName;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.NamespaceContext;
import ro.sync.ecss.extensions.api.schemaaware.SchemaAwareHandlerResult;
import ro.sync.ecss.extensions.commons.operations.MoveCaretUtil;
import ro.sync.util.Equaler;
import ro.sync.xml.XmlUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class CommonsOperationsUtil {
    public static void unwrapTags(AuthorAccess authorAccess, AuthorNode authorNode) throws BadLocationException {
        if (authorNode != null && authorNode != authorAccess.getDocumentController().getAuthorDocumentNode().getRootElement()) {
            boolean bl;
            int n2 = authorAccess.getEditorAccess().getCaretOffset();
            int n3 = authorNode.getStartOffset();
            int n4 = authorNode.getEndOffset();
            int n5 = n2 <= n3 ? n2 : (n2 > n3 && n2 <= n4 ? n2 - 1 : n2 - 2);
            int n6 = authorNode.getStartOffset() + 1;
            int n7 = authorNode.getEndOffset() - 1;
            AuthorDocumentFragment authorDocumentFragment = null;
            if (n6 <= n7) {
                authorDocumentFragment = authorAccess.getDocumentController().createDocumentFragment(n6, n7);
            }
            if ((bl = authorAccess.getDocumentController().deleteNode(authorNode)) && authorDocumentFragment != null) {
                authorAccess.getDocumentController().insertFragment(n3, authorDocumentFragment);
                authorAccess.getEditorAccess().setCaretPosition(n5);
            }
        }
    }

    public static void surroundWithFragment(AuthorAccess authorAccess, boolean bl, String string) throws AuthorOperationException {
        boolean bl2 = MoveCaretUtil.hasImposedEditorVariableCaretOffset(string);
        int n2 = authorAccess.getEditorAccess().getCaretOffset();
        if (authorAccess.getEditorAccess().hasSelection()) {
            n2 = CommonsOperationsUtil.surroundWithFragment(authorAccess, string, authorAccess.getEditorAccess().getSelectionStart(), authorAccess.getEditorAccess().getSelectionEnd() - 1);
        } else if (!bl) {
            authorAccess.getDocumentController().insertXMLFragment(string, n2);
        } else {
            Integer n3;
            SchemaAwareHandlerResult schemaAwareHandlerResult = authorAccess.getDocumentController().insertXMLFragmentSchemaAware(string, n2);
            if (schemaAwareHandlerResult != null && (n3 = (Integer)schemaAwareHandlerResult.getResult("result.id.handle.insert.fragment.offset")) != null) {
                n2 = n3;
            }
        }
        if (bl2) {
            MoveCaretUtil.moveCaretToImposedEditorVariableOffset(authorAccess, n2);
        }
    }

    public static int surroundWithFragment(AuthorAccess authorAccess, String string, int n2, int n3) throws AuthorOperationException {
        int[] nArray = authorAccess.getEditorAccess().getBalancedSelection(n2, n3 + 1);
        authorAccess.getDocumentController().surroundInFragment(string, nArray[0], nArray[1] - 1);
        return authorAccess.getEditorAccess().getSelectionStart();
    }

    public static String setAttributeValue(AuthorDocumentController authorDocumentController, AuthorElement authorElement, QName qName, String string, boolean bl) {
        return CommonsOperationsUtil.setAttributeValue(authorDocumentController, authorElement, qName, string, string, bl);
    }

    public static String setAttributeValue(AuthorDocumentController authorDocumentController, AuthorElement authorElement, QName qName, String string, String string2, boolean bl) {
        Object object;
        boolean bl2 = false;
        Object object2 = qName.getLocalPart();
        String string3 = null;
        String string4 = qName.getNamespaceURI();
        if (string4 != null && !"".equals(string4)) {
            object = CommonsOperationsUtil.getAttributeQName(authorElement, qName.getLocalPart(), qName.getNamespaceURI());
            if (object != null) {
                object2 = object;
            } else {
                NamespaceContext namespaceContext = authorElement.getNamespaceContext();
                string3 = namespaceContext.getPrefixForNamespace(string4);
                if (string3 != null && !"".equals(string3)) {
                    object2 = string3 + ":" + (String)object2;
                } else {
                    string3 = CommonsOperationsUtil.buildFreshPrefix(namespaceContext);
                    bl2 = true;
                    object2 = string3 + ":" + (String)object2;
                }
            }
        }
        if (string == null || "".equals(string) && bl) {
            if (!bl2) {
                authorDocumentController.removeAttribute((String)object2, authorElement);
            }
        } else {
            if (bl2) {
                object = new AttrValue(string4);
                authorDocumentController.setAttribute("xmlns:" + string3, (AttrValue)object, authorElement);
            }
            object = new AttrValue(string2, string, true);
            authorDocumentController.setAttribute((String)object2, (AttrValue)object, authorElement);
        }
        return object2;
    }

    private static String getAttributeQName(AuthorElement authorElement, String string, String string2) {
        String string3 = null;
        int n2 = authorElement.getAttributesCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string4 = authorElement.getAttributeAtIndex(i2);
            if (!string.equals(XmlUtil.getLocalName(string4)) || !Equaler.verifyEquals(string2, authorElement.getAttributeNamespace(XmlUtil.getProxy(string4)))) continue;
            string3 = string4;
            break;
        }
        return string3;
    }

    public static String buildFreshPrefix(NamespaceContext namespaceContext) {
        String string = null;
        int n2 = 1;
        while (namespaceContext.getNamespaceForPrefix("ns" + n2) != null) {
            ++n2;
        }
        string = "ns" + n2;
        return string;
    }
}

