/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import org.apache.log4j.Logger;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorOperationStoppedByUserException;
import ro.sync.ecss.extensions.api.Extension;
import ro.sync.ecss.extensions.api.ExternalObjectInsertionSources;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.util.xslt.URLGetPathFunctionCallDefinition;
import ro.sync.util.xslt.URLNewFunctionCallDefinition;
import ro.sync.util.xslt.URLUtilCopyURLFunctionCallDefinition;
import ro.sync.util.xslt.URLUtilUncorrectFunctionCallDefinition;
import ro.sync.util.xslt.UUIDHashCodeFunctionCallDefinition;
import ro.sync.util.xslt.UUIDRandomUUIDFunctionCallDefinition;

@API(type=APIType.EXTENDABLE, src=SourceType.PUBLIC)
public abstract class AuthorExternalObjectInsertionHandler
implements ExternalObjectInsertionSources,
Extension {
    private static final char CONTEXT_PATH_SEPARATOR = ',';
    private static Logger logger = Logger.getLogger((String)AuthorExternalObjectInsertionHandler.class.getName());
    public static final String ONLY_TEXT_CONTENT_STYLESHEET = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"2.0\"\n    xmlns:xhtml=\"http://www.w3.org/1999/xhtml\" exclude-result-prefixes=\"#all\"\n    xpath-default-namespace=\"http://www.w3.org/1999/xhtml\">\n    <xsl:output omit-xml-declaration=\"yes\"/>\n    <xsl:template match=\"style\"/>\n    <xsl:template match=\"script\"/>\n    <xsl:template match=\"head\"/>\n    <xsl:template match=\"*\">\n        <xsl:text> </xsl:text>\n        <xsl:apply-templates select=\"node()|text()\"/>\n        <xsl:text> </xsl:text>\n    </xsl:template>\n    <xsl:template match=\"xhtml:span[contains(@style, 'mso-list:Ignore') \n                                  or contains(@style, 'mso-list: Ignore')]\"/>\n</xsl:stylesheet>";
    private static final String DEFAULT_STYLESHEET_CONTENT = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"2.0\"\n    xmlns:xhtml=\"http://www.w3.org/1999/xhtml\" exclude-result-prefixes=\"#all\"\n    xpath-default-namespace=\"http://www.w3.org/1999/xhtml\">\n    <xsl:output omit-xml-declaration=\"yes\"/>\n    <xsl:template match=\"style\"/>\n    <xsl:template match=\"script\"/>\n    <xsl:template match=\"head\"/>\n</xsl:stylesheet>";
    private static final String REMOVE_TFOOT_STYLESHEET_CONTENT = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xsl:stylesheet version=\"1.0\" \n    xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" \n    xmlns:xhtml=\"http://www.w3.org/1999/xhtml\">\n    <xsl:output method=\"xml\" doctype-public=\"-//W3C//DTD XHTML 1.0 Transitional//EN\" \n        doctype-system=\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"/>\n    <xsl:template match=\"node() | @*\">\n        <xsl:copy>\n            <xsl:apply-templates select=\"node() | @*\"/>\n        </xsl:copy>\n    </xsl:template>\n    <xsl:template match=\"xhtml:tfoot\"/>\n</xsl:stylesheet>";
    private static int ditaReferencePropertiesTable = 0;
    private static int docbookHtmlTable = 0;
    private static boolean isTest = false;

    public void insertURLs(AuthorAccess authorAccess, List<URL> list, int n2) throws AuthorOperationException {
    }

    public boolean acceptURLs(AuthorAccess authorAccess, List<URL> list, int n2) {
        return this.acceptSource(authorAccess, n2) || AuthorExternalObjectInsertionHandler.containOnlyImages(authorAccess, list) || AuthorExternalObjectInsertionHandler.containOnlyBinaryResources(authorAccess, list);
    }

    public boolean acceptSource(AuthorAccess authorAccess, int n2) {
        return n2 == 1 || n2 == 0 || n2 == 4 || n2 == 4 || n2 == 3;
    }

    protected static boolean containOnlyImages(AuthorAccess authorAccess, List<URL> list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            URL uRL = list.get(i2);
            if (authorAccess.getUtilAccess().isSupportedImageURL(uRL)) continue;
            return false;
        }
        return true;
    }

    protected static boolean containOnlyBinaryResources(AuthorAccess authorAccess, List<URL> list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            URL uRL = list.get(i2);
            if (authorAccess.getUtilAccess().isUnhandledBinaryResourceURL(uRL)) continue;
            return false;
        }
        return true;
    }

    public void insertXHTMLFragment(AuthorAccess authorAccess, Reader reader) throws AuthorOperationException {
        StreamSource streamSource = this.createImporterStylesheetSource(authorAccess);
        if (streamSource != null) {
            try {
                String string;
                String string2;
                if (logger.isDebugEnabled()) {
                    reader = new LoggerReader(reader);
                }
                if ((string2 = AuthorExternalObjectInsertionHandler.applyAssociatedXSL(authorAccess, string = AuthorExternalObjectInsertionHandler.readInitialXHTMLContent(reader), streamSource)).length() > 0) {
                    if (this.checkImportedXHTMLContentIsPreservedEntirely()) {
                        String string3;
                        String string4 = string2;
                        String string5 = string;
                        if (string.contains("tfoot")) {
                            string5 = AuthorExternalObjectInsertionHandler.simpleTransform(authorAccess, string5, REMOVE_TFOOT_STYLESHEET_CONTENT);
                        }
                        string4 = AuthorExternalObjectInsertionHandler.applyAssociatedXSL(authorAccess, string5, this.createImporterStylesheetSource(authorAccess));
                        String string6 = AuthorExternalObjectInsertionHandler.simpleTransform(authorAccess, "<root>" + string4 + "</root>", this.getOnlyTextContentStylesheet(authorAccess));
                        if (AuthorExternalObjectInsertionHandler.testDataIsPreserved(string6, string3 = AuthorExternalObjectInsertionHandler.simpleTransform(authorAccess, string5, this.getOnlyTextContentStylesheet(authorAccess)))) {
                            authorAccess.getDocumentController().insertXMLFragmentSchemaAware(string2, authorAccess.getEditorAccess().getCaretOffset(), true);
                        } else {
                            logger.warn((Object)("Initial XHTML to paste: |" + string + "|"));
                            String string7 = AuthorExternalObjectInsertionHandler.simpleTransform(authorAccess, string, DEFAULT_STYLESHEET_CONTENT);
                            authorAccess.getDocumentController().insertXMLFragmentSchemaAware(string7, authorAccess.getEditorAccess().getCaretOffset(), true);
                        }
                    } else {
                        logger.debug((Object)"Do not check if content is preserved.");
                        authorAccess.getDocumentController().insertXMLFragmentSchemaAware(string2, authorAccess.getEditorAccess().getCaretOffset(), true);
                    }
                }
            }
            catch (AuthorOperationStoppedByUserException authorOperationStoppedByUserException) {
            }
            catch (Exception exception) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)exception, (Throwable)exception);
                }
                authorAccess.getWorkspaceAccess().showErrorMessage(exception.getMessage());
            }
        }
    }

    protected String getOnlyTextContentStylesheet(AuthorAccess authorAccess) {
        return ONLY_TEXT_CONTENT_STYLESHEET;
    }

    static String simpleTransform(AuthorAccess authorAccess, String string, String string2) throws TransformerException, IOException {
        return AuthorExternalObjectInsertionHandler.simpleTransform(authorAccess, string, new StreamSource(new StringReader(string2)));
    }

    public static String simpleTransform(AuthorAccess authorAccess, String string, StreamSource streamSource) throws TransformerException, IOException {
        Transformer transformer = authorAccess.getXMLUtilAccess().createXSLTTransformer(streamSource, new URL[0], 2, false);
        StringWriter stringWriter = new StringWriter();
        transformer.transform(new StreamSource(new StringReader(string)), new StreamResult(stringWriter));
        stringWriter.close();
        return stringWriter.toString();
    }

    private static String applyAssociatedXSL(AuthorAccess authorAccess, String string, StreamSource streamSource) throws TransformerException, MalformedURLException {
        ExtensionFunctionDefinition[] extensionFunctionDefinitionArray = new ExtensionFunctionDefinition[]{new URLUtilUncorrectFunctionCallDefinition(), new URLUtilCopyURLFunctionCallDefinition(), new UUIDRandomUUIDFunctionCallDefinition(), new UUIDHashCodeFunctionCallDefinition(), new URLNewFunctionCallDefinition(), new URLGetPathFunctionCallDefinition()};
        Transformer transformer = authorAccess.getXMLUtilAccess().createSaxon9HEXSLTTransformerWithExtensions(streamSource, extensionFunctionDefinitionArray);
        String[] stringArray = AuthorExternalObjectInsertionHandler.getContextPathNamesAndUris(authorAccess);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        URL uRL = AuthorExternalObjectInsertionHandler.getParentURL(authorAccess);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("folderOfPasteTargetXml: " + authorAccess.getUtilAccess().correctURL(uRL.toString())));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("context.path.names:" + string2));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("context.path.uris:" + string3));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"context.path.separator:,");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("dita.reference.properties.table:" + ditaReferencePropertiesTable));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("docbook.html.table:" + docbookHtmlTable));
        }
        transformer.setParameter("folderOfPasteTargetXml", authorAccess.getUtilAccess().correctURL(uRL.toString()));
        transformer.setParameter("context.path.names", string2);
        transformer.setParameter("context.path.uris", string3);
        transformer.setParameter("context.path.separator", Character.valueOf(','));
        if (isTest) {
            transformer.setParameter("docbook.html.table", docbookHtmlTable);
            transformer.setParameter("dita.reference.properties.table", ditaReferencePropertiesTable);
        }
        StringWriter stringWriter = new StringWriter();
        transformer.transform(new StreamSource(new StringReader(string)), new StreamResult(stringWriter));
        return stringWriter.toString();
    }

    static void setDitaPropertiesTableForTests(int n2) {
        ditaReferencePropertiesTable = n2;
        isTest = true;
    }

    static void setDocbookHtmlTableForTests(int n2) {
        docbookHtmlTable = n2;
        isTest = true;
    }

    static URL getParentURL(AuthorAccess authorAccess) throws MalformedURLException {
        URL uRL = authorAccess.getEditorAccess().getEditorLocation();
        String string = uRL.toString();
        int n2 = string.lastIndexOf("/");
        String string2 = null;
        string2 = n2 == -1 ? new File(System.getProperty("user.home")).toURL().toString() : string.substring(0, n2);
        URL uRL2 = new URL(string2);
        return uRL2;
    }

    protected static String[] getContextPathNamesAndUris(AuthorAccess authorAccess) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        try {
            AuthorEditorAccess authorEditorAccess = authorAccess.getEditorAccess();
            int n2 = authorEditorAccess.getCaretOffset();
            ArrayList<AuthorNode> arrayList = new ArrayList<AuthorNode>(5);
            for (AuthorNode authorNode = authorAccess.getDocumentController().getNodeAtOffset(n2); authorNode != null; authorNode = authorNode.getParent()) {
                if (authorNode.getParent() == null) continue;
                arrayList.add(0, authorNode);
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                AuthorNode authorNode = (AuthorNode)iterator.next();
                String string = authorNode.getName();
                if (authorNode.getType() == 0) {
                    string = ((AuthorElement)authorNode).getLocalName();
                }
                stringBuilder.append(string);
                stringBuilder2.append(authorNode.getNamespace());
                if (!iterator.hasNext()) continue;
                stringBuilder.append(',');
                stringBuilder2.append(',');
            }
        }
        catch (BadLocationException badLocationException) {
            logger.warn((Object)badLocationException, (Throwable)badLocationException);
        }
        return new String[]{stringBuilder.toString(), stringBuilder2.toString()};
    }

    private static String readInitialXHTMLContent(Reader reader) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = new char[1024];
        int n2 = -1;
        while ((n2 = reader.read(cArray)) != -1) {
            stringBuilder.append(cArray, 0, n2);
        }
        reader.close();
        return stringBuilder.toString();
    }

    protected StreamSource createImporterStylesheetSource(AuthorAccess authorAccess) {
        String string = this.getImporterStylesheetFileName(authorAccess);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("main stylesheet name: " + string));
        }
        return this.getStylesheetResource(authorAccess, string);
    }

    protected StreamSource createSectionsPreprocessingStylesheet(AuthorAccess authorAccess) {
        String string = this.getSectionsPreprocessingStylesheetFileName(authorAccess);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("sections preprocessing stylesheet name: " + string));
        }
        return this.getStylesheetResource(authorAccess, string);
    }

    protected StreamSource createListsPreprocessingStylesheet(AuthorAccess authorAccess) {
        String string = this.getListsPreprocessingStylesheetFileName(authorAccess);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("lists preprocessing stylesheet name: " + string));
        }
        return this.getStylesheetResource(authorAccess, string);
    }

    protected String getSectionsPreprocessingStylesheetFileName(AuthorAccess authorAccess) {
        return "nestedSections.xsl";
    }

    protected String getListsPreprocessingStylesheetFileName(AuthorAccess authorAccess) {
        return "nestedLists.xsl";
    }

    private StreamSource getStylesheetResource(AuthorAccess authorAccess, String string) {
        if (string != null) {
            Object[] objectArray;
            URL uRL = this.getClass().getClassLoader().getResource(string);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("main stylesheet URL resource: " + uRL));
            }
            if (uRL == null) {
                objectArray = authorAccess.getClassPathResourcesAccess().getClassPathResources();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("classPathResources: " + Arrays.toString(objectArray)));
                }
                URLClassLoader uRLClassLoader = new URLClassLoader((URL[])objectArray);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("class loader: " + uRLClassLoader.getClass().getName()));
                }
                if ((uRL = uRLClassLoader.findResource(string)) == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Could not find resource \"" + string + "\" in class loader class path, but found it in a new class loader. " + "Running from classes?"));
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)("resource found by " + uRLClassLoader + " (instance of " + uRLClassLoader.getClass().getName() + "): " + uRLClassLoader.getClass().getName()));
                }
            }
            if (uRL != null) {
                return new StreamSource(uRL.toString());
            }
            objectArray = "Could not find resource \"" + string + "\" in class path.";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)objectArray);
            }
            logger.error((Object)objectArray, (Throwable)new Exception());
        }
        return new StreamSource(new StringReader(DEFAULT_STYLESHEET_CONTENT));
    }

    protected String getImporterStylesheetFileName(AuthorAccess authorAccess) {
        return null;
    }

    protected URL getBaseURLAtCaretPosition(AuthorAccess authorAccess) {
        URL uRL = authorAccess.getEditorAccess().getEditorLocation();
        try {
            AuthorNode authorNode = authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset());
            if (authorNode != null) {
                uRL = authorNode.getXMLBaseURL();
            }
        }
        catch (BadLocationException badLocationException) {
            logger.error((Object)badLocationException, (Throwable)badLocationException);
        }
        return uRL;
    }

    protected boolean checkImportedXHTMLContentIsPreservedEntirely() {
        return false;
    }

    static boolean testDataIsPreserved(String string, String string2) {
        boolean bl = true;
        if (!string.equals(string2)) {
            int n2 = 0;
            int n3 = 0;
            int n4 = string.length();
            int n5 = string2.length();
            while (n2 < n4 || n3 < n5) {
                char c2 = '\u0000';
                boolean bl2 = false;
                while (n2 < n4) {
                    c2 = string.charAt(n2);
                    ++n2;
                    if (Character.isWhitespace(c2) || c2 == '\u00a0') continue;
                    bl2 = true;
                    break;
                }
                char c3 = '\u0000';
                boolean bl3 = false;
                while (n3 < n5) {
                    c3 = string2.charAt(n3);
                    ++n3;
                    if (Character.isWhitespace(c3) || c3 == '\u00a0') continue;
                    bl3 = true;
                    break;
                }
                if (bl2 && bl3) {
                    if (c2 == c3) continue;
                    bl = false;
                    break;
                }
                if (!bl2 && !bl3) break;
                bl = false;
                break;
            }
            if (!bl) {
                logger.warn((Object)"-----Problem preserving the XHTML data on paste, reverting to default.------");
                logger.warn((Object)("contentProcessedByStylesheets:\n" + string));
                logger.warn((Object)("APPLIED XSLS DIFF NOT MATCHING:  " + n2 + "   code: " + string.charAt(n2 - 1) + "  char: " + string.charAt(n2 - 1) + "\n[" + string.substring(n2) + "]"));
                logger.warn((Object)("ONLY WORDS DIFF NOT MATCHING:" + n3 + "   code: " + string2.charAt(n3 - 1) + "  char: " + string2.charAt(n3 - 1) + "\n[" + string2.substring(n3) + "]"));
                logger.warn((Object)("Initial Processed pe XSLT content :\n" + string));
                logger.warn((Object)("All Words content:\n" + string2));
            }
        }
        return bl;
    }

    @Override
    public String getDescription() {
        return "Author External Object Insertion Handler";
    }

    private static class LoggerReader
    extends Reader {
        private Reader reader;
        private StringBuilder loggedContent = new StringBuilder();

        LoggerReader(Reader reader) {
            this.reader = reader;
        }

        @Override
        public int read(char[] cArray, int n2, int n3) throws IOException {
            int n4 = this.reader.read(cArray, n2, n3);
            if (n4 > 0) {
                this.loggedContent.append(cArray, n2, n4);
            }
            return n4;
        }

        @Override
        public void close() throws IOException {
            logger.debug((Object)this.loggedContent.toString());
            this.reader.close();
        }
    }
}

