/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc2.compat.SvnCodec;
import org.tmatesoft.svn.core.wc.ISVNExternalsHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnCanonicalizeUrls;
import org.tmatesoft.svn.core.wc2.SvnCheckout;
import org.tmatesoft.svn.core.wc2.SvnExport;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnRelocate;
import org.tmatesoft.svn.core.wc2.SvnSwitch;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.core.wc2.SvnUpdate;

public class SVNUpdateClient
extends SVNBasicClient {
    private ISVNExternalsHandler myExternalsHandler;
    private boolean updateLocksOnDemand;
    private boolean exportExpandsKeywords;

    public SVNUpdateClient(ISVNAuthenticationManager iSVNAuthenticationManager, ISVNOptions iSVNOptions) {
        super(iSVNAuthenticationManager, iSVNOptions);
    }

    public SVNUpdateClient(ISVNRepositoryPool iSVNRepositoryPool, ISVNOptions iSVNOptions) {
        super(iSVNRepositoryPool, iSVNOptions);
    }

    public SVNUpdateClient(SvnOperationFactory svnOperationFactory) {
        super(svnOperationFactory);
    }

    protected void initDefaults() {
        this.setExternalsHandler(null);
    }

    public void setExternalsHandler(ISVNExternalsHandler iSVNExternalsHandler) {
        this.myExternalsHandler = iSVNExternalsHandler;
    }

    public ISVNExternalsHandler getExternalsHandler() {
        if (this.myExternalsHandler == null) {
            return ISVNExternalsHandler.DEFAULT;
        }
        return this.myExternalsHandler;
    }

    public long doUpdate(File file, SVNRevision sVNRevision, boolean bl) throws SVNException {
        return this.doUpdate(file, sVNRevision, SVNDepth.fromRecurse((boolean)bl), false, false);
    }

    public long doUpdate(File file, SVNRevision sVNRevision, boolean bl, boolean bl2) throws SVNException {
        return this.doUpdate(file, sVNRevision, SVNDepth.fromRecurse((boolean)bl), bl2, false);
    }

    public long[] doUpdate(File[] fileArray, SVNRevision sVNRevision, SVNDepth sVNDepth, boolean bl, boolean bl2) throws SVNException {
        return this.doUpdate(fileArray, sVNRevision, sVNDepth, bl, bl2, false);
    }

    public long[] doUpdate(File[] fileArray, SVNRevision sVNRevision, SVNDepth sVNDepth, boolean bl, boolean bl2, boolean bl3) throws SVNException {
        if (fileArray == null || fileArray.length == 0) {
            return new long[0];
        }
        SvnUpdate svnUpdate = this.getOperationsFactory().createUpdate();
        svnUpdate.setUpdateLocksOnDemand(this.isUpdateLocksOnDemand());
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            svnUpdate.addTarget(SvnTarget.fromFile((File)fileArray[i2]));
        }
        svnUpdate.setRevision(sVNRevision);
        svnUpdate.setDepth(sVNDepth);
        svnUpdate.setDepthIsSticky(bl2);
        svnUpdate.setAllowUnversionedObstructions(bl);
        svnUpdate.setIgnoreExternals(this.isIgnoreExternals());
        svnUpdate.setMakeParents(bl3);
        svnUpdate.setExternalsHandler(SvnCodec.externalsHandler((ISVNExternalsHandler)this.getExternalsHandler()));
        return (long[])svnUpdate.run();
    }

    public long doUpdate(File file, SVNRevision sVNRevision, SVNDepth sVNDepth, boolean bl, boolean bl2) throws SVNException {
        long[] lArray = this.doUpdate(new File[]{file}, sVNRevision, sVNDepth, bl, bl2);
        return lArray[0];
    }

    public void setUpdateLocksOnDemand(boolean bl) {
        this.updateLocksOnDemand = bl;
    }

    public boolean isUpdateLocksOnDemand() {
        return this.updateLocksOnDemand;
    }

    public long doSwitch(File file, SVNURL sVNURL, SVNRevision sVNRevision, boolean bl) throws SVNException {
        return this.doSwitch(file, sVNURL, SVNRevision.UNDEFINED, sVNRevision, SVNDepth.getInfinityOrFilesDepth((boolean)bl), false, false);
    }

    public long doSwitch(File file, SVNURL sVNURL, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl) throws SVNException {
        return this.doSwitch(file, sVNURL, sVNRevision, sVNRevision2, SVNDepth.getInfinityOrFilesDepth((boolean)bl), false, false);
    }

    public long doSwitch(File file, SVNURL sVNURL, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl, boolean bl2) throws SVNException {
        return this.doSwitch(file, sVNURL, sVNRevision, sVNRevision2, SVNDepth.getInfinityOrFilesDepth((boolean)bl), bl2, false);
    }

    public long doSwitch(File file, SVNURL sVNURL, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNDepth sVNDepth, boolean bl, boolean bl2) throws SVNException {
        return this.doSwitch(file, sVNURL, sVNRevision, sVNRevision2, sVNDepth, bl, bl2, true);
    }

    public long doSwitch(File file, SVNURL sVNURL, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNDepth sVNDepth, boolean bl, boolean bl2, boolean bl3) throws SVNException {
        SvnSwitch svnSwitch = this.getOperationsFactory().createSwitch();
        svnSwitch.setUpdateLocksOnDemand(this.isUpdateLocksOnDemand());
        svnSwitch.setSwitchTarget(SvnTarget.fromURL((SVNURL)sVNURL, (SVNRevision)sVNRevision));
        svnSwitch.setSingleTarget(SvnTarget.fromFile((File)file));
        svnSwitch.setRevision(sVNRevision2);
        svnSwitch.setDepth(sVNDepth);
        svnSwitch.setDepthIsSticky(bl2);
        svnSwitch.setAllowUnversionedObstructions(bl);
        svnSwitch.setIgnoreAncestry(bl3);
        svnSwitch.setIgnoreExternals(this.isIgnoreExternals());
        svnSwitch.setExternalsHandler(SvnCodec.externalsHandler((ISVNExternalsHandler)this.getExternalsHandler()));
        return (Long)svnSwitch.run();
    }

    public long doCheckout(SVNURL sVNURL, File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl) throws SVNException {
        return this.doCheckout(sVNURL, file, sVNRevision, sVNRevision2, SVNDepth.fromRecurse((boolean)bl), false);
    }

    public long doCheckout(SVNURL sVNURL, File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl, boolean bl2) throws SVNException {
        return this.doCheckout(sVNURL, file, sVNRevision, sVNRevision2, SVNDepth.fromRecurse((boolean)bl), bl2);
    }

    public long doCheckout(SVNURL sVNURL, File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNDepth sVNDepth, boolean bl) throws SVNException {
        SvnCheckout svnCheckout = this.getOperationsFactory().createCheckout();
        svnCheckout.setUpdateLocksOnDemand(this.isUpdateLocksOnDemand());
        svnCheckout.setSource(SvnTarget.fromURL((SVNURL)sVNURL, (SVNRevision)sVNRevision));
        svnCheckout.setSingleTarget(SvnTarget.fromFile((File)file));
        svnCheckout.setRevision(sVNRevision2);
        svnCheckout.setDepth(sVNDepth);
        svnCheckout.setAllowUnversionedObstructions(bl);
        svnCheckout.setIgnoreExternals(this.isIgnoreExternals());
        svnCheckout.setExternalsHandler(SvnCodec.externalsHandler((ISVNExternalsHandler)this.getExternalsHandler()));
        return (Long)svnCheckout.run();
    }

    public long doCheckout(SVNURL sVNURL, File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNDepth sVNDepth, boolean bl, int n2) throws SVNException {
        SvnCheckout svnCheckout = this.getOperationsFactory().createCheckout();
        svnCheckout.setUpdateLocksOnDemand(this.isUpdateLocksOnDemand());
        svnCheckout.setSource(SvnTarget.fromURL((SVNURL)sVNURL, (SVNRevision)sVNRevision));
        svnCheckout.setSingleTarget(SvnTarget.fromFile((File)file));
        svnCheckout.setRevision(sVNRevision2);
        svnCheckout.setDepth(sVNDepth);
        svnCheckout.setAllowUnversionedObstructions(bl);
        svnCheckout.setIgnoreExternals(this.isIgnoreExternals());
        svnCheckout.setExternalsHandler(SvnCodec.externalsHandler((ISVNExternalsHandler)this.getExternalsHandler()));
        if (n2 == -1) {
            n2 = Integer.getInteger("svn.wc.format", 31);
        }
        svnCheckout.setTargetWorkingCopyFormat(n2);
        return (Long)svnCheckout.run();
    }

    public long doExport(SVNURL sVNURL, File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, String string, boolean bl, boolean bl2) throws SVNException {
        return this.doExport(sVNURL, file, sVNRevision, sVNRevision2, string, bl, SVNDepth.fromRecurse((boolean)bl2));
    }

    public long doExport(SVNURL sVNURL, File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, String string, boolean bl, SVNDepth sVNDepth) throws SVNException {
        SvnExport svnExport = this.getOperationsFactory().createExport();
        svnExport.setUpdateLocksOnDemand(this.isUpdateLocksOnDemand());
        svnExport.setSingleTarget(SvnTarget.fromFile((File)file));
        svnExport.setSource(SvnTarget.fromURL((SVNURL)sVNURL, (SVNRevision)sVNRevision));
        svnExport.setRevision(sVNRevision2);
        svnExport.setEolStyle(string);
        svnExport.setForce(bl);
        svnExport.setDepth(sVNDepth);
        svnExport.setExpandKeywords(this.isExportExpandsKeywords());
        svnExport.setIgnoreExternals(this.isIgnoreExternals());
        svnExport.setExternalsHandler(SvnCodec.externalsHandler((ISVNExternalsHandler)this.getExternalsHandler()));
        return (Long)svnExport.run();
    }

    public long doExport(File file, File file2, SVNRevision sVNRevision, SVNRevision sVNRevision2, String string, boolean bl, boolean bl2) throws SVNException {
        return this.doExport(file, file2, sVNRevision, sVNRevision2, string, bl, SVNDepth.fromRecurse((boolean)bl2));
    }

    public long doExport(File file, File file2, SVNRevision sVNRevision, SVNRevision sVNRevision2, String string, boolean bl, SVNDepth sVNDepth) throws SVNException {
        SvnExport svnExport = this.getOperationsFactory().createExport();
        svnExport.setUpdateLocksOnDemand(this.isUpdateLocksOnDemand());
        svnExport.setSingleTarget(SvnTarget.fromFile((File)file2));
        svnExport.setSource(SvnTarget.fromFile((File)file, (SVNRevision)sVNRevision));
        svnExport.setRevision(sVNRevision2);
        svnExport.setEolStyle(string);
        svnExport.setForce(bl);
        svnExport.setIgnoreExternals(this.isIgnoreExternals());
        svnExport.setDepth(sVNDepth);
        svnExport.setExpandKeywords(this.isExportExpandsKeywords());
        svnExport.setExternalsHandler(SvnCodec.externalsHandler((ISVNExternalsHandler)this.getExternalsHandler()));
        return (Long)svnExport.run();
    }

    public void doRelocate(File file, SVNURL sVNURL, SVNURL sVNURL2, boolean bl) throws SVNException {
        SvnRelocate svnRelocate = this.getOperationsFactory().createRelocate();
        svnRelocate.setSingleTarget(SvnTarget.fromFile((File)file));
        svnRelocate.setFromUrl(sVNURL);
        svnRelocate.setToUrl(sVNURL2);
        svnRelocate.setRecursive(bl);
        svnRelocate.run();
    }

    public void doCanonicalizeURLs(File file, boolean bl, boolean bl2) throws SVNException {
        SvnCanonicalizeUrls svnCanonicalizeUrls = this.getOperationsFactory().createCanonicalizeUrls();
        svnCanonicalizeUrls.setSingleTarget(SvnTarget.fromFile((File)file));
        svnCanonicalizeUrls.setDepth(bl2 ? SVNDepth.INFINITY : SVNDepth.IMMEDIATES);
        svnCanonicalizeUrls.setOmitDefaultPort(bl);
        svnCanonicalizeUrls.setIgnoreExternals(this.isIgnoreExternals());
        svnCanonicalizeUrls.run();
    }

    public void setExportExpandsKeywords(boolean bl) {
        this.exportExpandsKeywords = bl;
    }

    public boolean isExportExpandsKeywords() {
        return this.exportExpandsKeywords;
    }
}

