/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.h;
import com.jidesoft.docking.l;
import java.awt.Rectangle;
import java.io.Serializable;

public class DockContext
implements Serializable {
    public static final int MODE_FLOATABLE = 1;
    public static final int MODE_AUTOHIDABLE = 2;
    public static final int MODE_DOCKABLE = 4;
    public static final int MODE_HIDABLE = 8;
    public static final int MODE_ALL = 15;
    public static final int STATE_HIDDEN = 0;
    public static final int STATE_FLOATING = 1;
    public static final int STATE_AUTOHIDE = 2;
    public static final int STATE_AUTOHIDE_SHOWING = 3;
    public static final int STATE_FRAMEDOCKED = 4;
    public static final String[] STATE_NAMES = new String[]{"HIDE", "FLOAT", "AUTOHIDE", "AUTOHIDE_ACTIVE", "DOCK"};
    private int j = 4;
    private int l = 4;
    private int t = 15;
    public static final int DOCK_SIDE_NORTH = 1;
    public static final int DOCK_SIDE_SOUTH = 2;
    public static final int DOCK_SIDE_EAST = 4;
    public static final int DOCK_SIDE_WEST = 8;
    public static final int DOCK_SIDE_CENTER = 16;
    public static final int DOCK_SIDE_UNKNOWN = 32;
    public static final int DOCK_SIDE_HORIZONTAL = 3;
    public static final int DOCK_SIDE_VERTICAL = 12;
    public static final int DOCK_SIDE_ALL = 15;
    public static final int DOCK_SIDE_ALL_AND_CENTER = 31;
    public static final String[] SIDE_NAMES = new String[]{"NORTH", "SOUTH", "EAST", "WEST", "CENTER", "FLOAT", "UNKNOWN"};
    private int o = 4;
    private int m;
    private boolean q = true;
    private int k = 2;
    private Rectangle h;
    private int b = 0;
    private int w = 0;
    private int r = 200;
    private int v = 200;
    private int x = 200;
    private int s = 200;
    private Rectangle e;
    private int d;
    private l f;
    private l y;
    private l n;
    private l c;
    private l u;
    private l i;
    private l p;
    private boolean g = true;

    public int getInitMode() {
        return this.j;
    }

    public void setInitMode(int n2) {
        if (n2 > 4 || n2 < -4) {
            throw new IllegalArgumentException(n2 + " is an invalid init mode for the setInitMode method. Valid modes are STATE_FRAMEDOCKED, STATE_FLOATING, STATE_AUTOHIDE, STATE_AUTOHIDE_SHOWING, STATE_HIDDEN and their negative values.");
        }
        this.j = n2;
    }

    public int getCurrentMode() {
        if (this.l == -1) {
            return this.j;
        }
        return this.l;
    }

    public boolean isHidden() {
        return this.l == 0;
    }

    public boolean isDocked() {
        return this.l == 4;
    }

    public boolean isFloated() {
        return this.l == 1;
    }

    public boolean isAutohide() {
        return this.l == 2;
    }

    public boolean isAutohideShowing() {
        return this.l == 3;
    }

    public void setCurrentMode(int n2) {
        this.l = n2;
    }

    public int getInitSide() {
        return this.o;
    }

    public void setInitSide(int n2) {
        if (n2 != 4 && n2 != 8 && n2 != 2 && n2 != 1 && n2 != 16) {
            throw new IllegalArgumentException(n2 + " is an invalid init side for the setInitSide method. Valid sides are DOCK_SIDE_EAST, DOCK_SIDE_WEST, DOCK_SIDE_SOUTH, DOCK_SIDE_NORTH and DOCK_SIDE_CENTER.");
        }
        this.o = n2;
    }

    public boolean isInitPosition() {
        return this.q;
    }

    public void setInitPosition(boolean bl) {
        this.q = bl;
    }

    public int getInitIndex() {
        return this.m;
    }

    public void setInitIndex(int n2) {
        this.m = n2;
    }

    public int getCurrentDockSide() {
        return this.k;
    }

    public void setCurrentDockSide(int n2) {
        this.k = n2;
    }

    public Rectangle getUndockedBounds() {
        return this.h;
    }

    public void setUndockedBounds(Rectangle rectangle) {
        this.h = rectangle;
    }

    public int getAutohideWidth() {
        return this.r;
    }

    public void setAutohideWidth(int n2) {
        this.r = n2;
    }

    public int getAutohideHeight() {
        return this.v;
    }

    public void setAutohideHeight(int n2) {
        this.v = n2;
    }

    public int getDockedWidth() {
        return this.b;
    }

    public void setDockedWidth(int n2) {
        this.b = n2;
    }

    public int getDockedHeight() {
        return this.w;
    }

    public void setDockedHeight(int n2) {
        this.w = n2;
    }

    public l getHiddenPreviousState() {
        return this.f;
    }

    public void setHiddenPreviousState(l l2) {
        this.f = l2;
    }

    public l getClosePreviousState() {
        return this.y;
    }

    public void setClosePreviousState(l l2) {
        this.y = l2;
    }

    public l getDockPreviousState() {
        return this.n;
    }

    public void setDockPreviousState(l l2) {
        this.n = l2;
    }

    public l getFloatPreviousState() {
        return this.c;
    }

    public void setFloatPreviousState(l l2) {
        this.c = l2;
    }

    public l getAutohidePreviousState() {
        return this.u;
    }

    public void setAutohidePreviousState(l l2) {
        this.u = l2;
    }

    public static String getDockSideName(int n2) {
        return SIDE_NAMES[(int)(Math.log(n2) / Math.log(2.0))];
    }

    public static String getStateName(int n2) {
        return STATE_NAMES[n2];
    }

    public int getDockID() {
        return this.d;
    }

    public void setDockID(DockingManager dockingManager, int n2) {
        this.d = n2;
        if (dockingManager != null) {
            com.jidesoft.docking.h.f(dockingManager).b(this.d);
        }
    }

    public void resetDockID(DockingManager dockingManager) {
        int n2 = com.jidesoft.docking.h.f(dockingManager).h(this.getDockID());
        this.setDockID(dockingManager, n2);
    }

    public int getCanMode() {
        return this.t;
    }

    public void setCanMode(int n2) {
        this.t = n2;
    }

    public boolean isDockable() {
        return (this.getCanMode() & 4) != 0;
    }

    public void setDockable(boolean bl) {
        if (bl) {
            this.setCanMode(this.getCanMode() | 4);
        } else {
            this.setCanMode(this.getCanMode() & 0xFFFFFFFB);
        }
    }

    public boolean isHidable() {
        return (this.getCanMode() & 8) != 0;
    }

    public void setHidable(boolean bl) {
        if (bl) {
            this.setCanMode(this.getCanMode() | 8);
        } else {
            this.setCanMode(this.getCanMode() & 0xFFFFFFF7);
        }
    }

    public boolean isAutohidable() {
        return (this.getCanMode() & 2) != 0;
    }

    public void setAutohidable(boolean bl) {
        if (bl) {
            this.setCanMode(this.getCanMode() | 2);
        } else {
            this.setCanMode(this.getCanMode() & 0xFFFFFFFD);
        }
    }

    public boolean isFloatable() {
        return (this.getCanMode() & 1) != 0;
    }

    public void setFloatable(boolean bl) {
        if (bl) {
            this.setCanMode(this.getCanMode() | 1);
        } else {
            this.setCanMode(this.getCanMode() & 0xFFFFFFFE);
        }
    }

    public l getAvailablePreviousState() {
        return this.i;
    }

    public void setAvailablePreviousState(l l2) {
        this.i = l2;
    }

    public boolean isAvailable() {
        return this.g;
    }

    public void setAvailable(boolean bl) {
        this.g = bl;
    }

    public l getMaximizedPreviousState() {
        return this.p;
    }

    public void setMaximizedPreviousState(l l2) {
        this.p = l2;
    }

    public Object clone() throws CloneNotSupportedException {
        DockContext dockContext = new DockContext();
        dockContext.setInitSide(this.getInitSide());
        dockContext.setInitMode(this.getInitMode());
        dockContext.setInitIndex(this.getInitIndex());
        dockContext.setUndockedBounds(this.getUndockedBounds());
        dockContext.setAutohideHeight(this.getAutohideHeight());
        dockContext.setAutohideWidth(this.getAutohideWidth());
        dockContext.setCanMode(this.getCanMode());
        dockContext.setCurrentDockSide(this.getCurrentDockSide());
        dockContext.setCurrentMode(this.getCurrentMode());
        dockContext.setDockedHeight(this.getDockedHeight());
        dockContext.setDockedWidth(this.getDockedWidth());
        return dockContext;
    }

    int g() {
        return this.x;
    }

    void e(int n2) {
        this.x = n2;
    }

    int d() {
        return this.s;
    }

    void f(int n2) {
        this.s = n2;
    }

    Rectangle b() {
        return this.e;
    }

    void c(Rectangle rectangle) {
        this.e = rectangle;
    }
}

