/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Random;
import javax.imageio.ImageIO;
import org.libjpegturbo.turbojpeg.TJ;
import org.libjpegturbo.turbojpeg.TJCompressor;
import org.libjpegturbo.turbojpeg.TJDecompressor;
import org.libjpegturbo.turbojpeg.TJScalingFactor;
import org.libjpegturbo.turbojpeg.YUVImage;

final class TJUnitTest {
    static final String CLASS_NAME = new TJUnitTest().getClass().getName();
    static final String[] SUBNAME_LONG = new String[]{"4:4:4", "4:2:2", "4:2:0", "GRAY", "4:4:0", "4:1:1"};
    static final String[] SUBNAME = new String[]{"444", "422", "420", "GRAY", "440", "411"};
    static final String[] PIXFORMATSTR = new String[]{"RGB", "BGR", "RGBX", "BGRX", "XBGR", "XRGB", "Grayscale", "RGBA", "BGRA", "ABGR", "ARGB", "CMYK"};
    static final int[] FORMATS_3BYTE = new int[]{0, 1};
    static final int[] FORMATS_3BYTEBI = new int[]{5};
    static final int[] FORMATS_4BYTE = new int[]{2, 3, 4, 5, 11};
    static final int[] FORMATS_4BYTEBI = new int[]{4, 1, 6, 7, 2, 3};
    static final int[] FORMATS_GRAY = new int[]{6};
    static final int[] FORMATS_GRAYBI = new int[]{10};
    static final int[] FORMATS_RGB = new int[]{0};
    private static boolean doYUV = false;
    private static int pad = 4;
    private static boolean bi = false;
    private static int exitStatus = 0;

    private TJUnitTest() {
    }

    static void usage() {
        System.out.println("\nUSAGE: java " + CLASS_NAME + " [options]\n");
        System.out.println("Options:");
        System.out.println("-yuv = test YUV encoding/decoding support");
        System.out.println("-noyuvpad = do not pad each line of each Y, U, and V plane to the nearest");
        System.out.println("            4-byte boundary");
        System.out.println("-bi = test BufferedImage support\n");
        System.exit(1);
    }

    static int biTypePF(int n) {
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        switch (n) {
            case 5: {
                return 1;
            }
            case 6: 
            case 7: {
                return 9;
            }
            case 10: {
                return 6;
            }
            case 4: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 2: 
            case 3: {
                return 8;
            }
        }
        return 0;
    }

    static String biTypeStr(int n) {
        switch (n) {
            case 5: {
                return "3BYTE_BGR";
            }
            case 6: {
                return "4BYTE_ABGR";
            }
            case 7: {
                return "4BYTE_ABGR_PRE";
            }
            case 10: {
                return "BYTE_GRAY";
            }
            case 4: {
                return "INT_BGR";
            }
            case 1: {
                return "INT_RGB";
            }
            case 2: {
                return "INT_ARGB";
            }
            case 3: {
                return "INT_ARGB_PRE";
            }
        }
        return "Unknown";
    }

    static void initBuf(byte[] byArray, int n, int n2, int n3, int n4, int n5) throws Exception {
        int n6 = TJ.getRedOffset(n4);
        int n7 = TJ.getGreenOffset(n4);
        int n8 = TJ.getBlueOffset(n4);
        int n9 = TJ.getAlphaOffset(n4);
        int n10 = TJ.getPixelSize(n4);
        int n11 = 16;
        if (n4 == 6) {
            Arrays.fill(byArray, (byte)0);
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n; ++j) {
                    int n12 = (n5 & 2) != 0 ? n2 * (n3 - i - 1) + j : n2 * i + j;
                    byArray[n12] = (i / 8 + j / 8) % 2 == 0 ? (i < n11 ? -1 : 0) : (i < n11 ? 76 : -30);
                }
            }
            return;
        }
        if (n4 == 11) {
            Arrays.fill(byArray, (byte)-1);
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n; ++j) {
                    int n13 = (n5 & 2) != 0 ? (n3 - i - 1) * n + j : i * n + j;
                    if ((i / 8 + j / 8) % 2 == 0) {
                        if (i < n11) continue;
                        byArray[n13 * n10 + 3] = 0;
                        continue;
                    }
                    byArray[n13 * n10 + 2] = 0;
                    if (i >= n11) continue;
                    byArray[n13 * n10 + 1] = 0;
                }
            }
            return;
        }
        Arrays.fill(byArray, (byte)0);
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n; ++j) {
                int n14 = (n5 & 2) != 0 ? n2 * (n3 - i - 1) + j * n10 : n2 * i + j * n10;
                if ((i / 8 + j / 8) % 2 == 0) {
                    if (i < n11) {
                        byArray[n14 + n6] = -1;
                        byArray[n14 + n7] = -1;
                        byArray[n14 + n8] = -1;
                    }
                } else {
                    byArray[n14 + n6] = -1;
                    if (i >= n11) {
                        byArray[n14 + n7] = -1;
                    }
                }
                if (n9 < 0) continue;
                byArray[n14 + n9] = -1;
            }
        }
    }

    static void initIntBuf(int[] nArray, int n, int n2, int n3, int n4, int n5) throws Exception {
        int n6 = TJ.getRedOffset(n4) * 8;
        int n7 = TJ.getGreenOffset(n4) * 8;
        int n8 = TJ.getBlueOffset(n4) * 8;
        int n9 = TJ.getAlphaOffset(n4) * 8;
        int n10 = 16;
        Arrays.fill(nArray, 0);
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n; ++j) {
                int n11 = (n5 & 2) != 0 ? n2 * (n3 - i - 1) + j : n2 * i + j;
                if ((i / 8 + j / 8) % 2 == 0) {
                    if (i < n10) {
                        int n12 = n11;
                        nArray[n12] = nArray[n12] | 255 << n6;
                        int n13 = n11;
                        nArray[n13] = nArray[n13] | 255 << n7;
                        int n14 = n11;
                        nArray[n14] = nArray[n14] | 255 << n8;
                    }
                } else {
                    int n15 = n11;
                    nArray[n15] = nArray[n15] | 255 << n6;
                    if (i >= n10) {
                        int n16 = n11;
                        nArray[n16] = nArray[n16] | 255 << n7;
                    }
                }
                if (n9 < 0) continue;
                int n17 = n11;
                nArray[n17] = nArray[n17] | 255 << n9;
            }
        }
    }

    static void initImg(BufferedImage bufferedImage, int n, int n2) throws Exception {
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n3 = bufferedImage.getType();
        if (n3 == 1 || n3 == 4 || n3 == 2 || n3 == 3) {
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)bufferedImage.getSampleModel();
            int n4 = singlePixelPackedSampleModel.getScanlineStride();
            DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
            int[] nArray = dataBufferInt.getData();
            TJUnitTest.initIntBuf(nArray, bufferedImage.getWidth(), n4, bufferedImage.getHeight(), n, n2);
        } else {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)bufferedImage.getSampleModel();
            int n5 = componentSampleModel.getScanlineStride();
            DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
            byte[] byArray = dataBufferByte.getData();
            TJUnitTest.initBuf(byArray, bufferedImage.getWidth(), n5, bufferedImage.getHeight(), n, n2);
        }
    }

    static void checkVal(int n, int n2, int n3, String string, int n4) throws Exception {
        int n5 = n3 = n3 < 0 ? n3 + 256 : n3;
        if (n3 < n4 - 1 || n3 > n4 + 1) {
            throw new Exception("Comp. " + string + " at " + n + "," + n2 + " should be " + n4 + ", not " + n3);
        }
    }

    static void checkVal0(int n, int n2, int n3, String string) throws Exception {
        int n4 = n3 = n3 < 0 ? n3 + 256 : n3;
        if (n3 > 1) {
            throw new Exception("Comp. " + string + " at " + n + "," + n2 + " should be 0, not " + n3);
        }
    }

    static void checkVal255(int n, int n2, int n3, String string) throws Exception {
        int n4 = n3 = n3 < 0 ? n3 + 256 : n3;
        if (n3 < 254) {
            throw new Exception("Comp. " + string + " at " + n + "," + n2 + " should be 255, not " + n3);
        }
    }

    static int checkBuf(byte[] byArray, int n, int n2, int n3, int n4, int n5, TJScalingFactor tJScalingFactor, int n6) throws Exception {
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12 = TJ.getRedOffset(n4);
        int n13 = TJ.getGreenOffset(n4);
        int n14 = TJ.getBlueOffset(n4);
        int n15 = TJ.getAlphaOffset(n4);
        int n16 = TJ.getPixelSize(n4);
        int n17 = 1;
        int n18 = 16 * tJScalingFactor.getNum() / tJScalingFactor.getDenom();
        int n19 = 8 * tJScalingFactor.getNum() / tJScalingFactor.getDenom();
        try {
            if (n4 == 6) {
                n14 = 0;
                n13 = 0;
                n12 = 0;
            }
            if (n4 == 11) {
                for (int i = 0; i < n3; ++i) {
                    for (int j = 0; j < n; ++j) {
                        int n20 = (n6 & 2) != 0 ? (n3 - i - 1) * n + j : i * n + j;
                        byte by = byArray[n20 * n16];
                        byte by2 = byArray[n20 * n16 + 1];
                        byte by3 = byArray[n20 * n16 + 2];
                        byte by4 = byArray[n20 * n16 + 3];
                        TJUnitTest.checkVal255(i, j, by, "C");
                        if ((i / n19 + j / n19) % 2 == 0) {
                            TJUnitTest.checkVal255(i, j, by2, "M");
                            TJUnitTest.checkVal255(i, j, by3, "Y");
                            if (i < n18) {
                                TJUnitTest.checkVal255(i, j, by4, "K");
                                continue;
                            }
                            TJUnitTest.checkVal0(i, j, by4, "K");
                            continue;
                        }
                        TJUnitTest.checkVal0(i, j, by3, "Y");
                        TJUnitTest.checkVal255(i, j, by4, "K");
                        if (i < n18) {
                            TJUnitTest.checkVal0(i, j, by2, "M");
                            continue;
                        }
                        TJUnitTest.checkVal255(i, j, by2, "M");
                    }
                }
                return 1;
            }
            for (n11 = 0; n11 < n18; ++n11) {
                for (n10 = 0; n10 < n; ++n10) {
                    int n21 = (n6 & 2) != 0 ? n2 * (n3 - n11 - 1) + n10 * n16 : n2 * n11 + n10 * n16;
                    byte by = byArray[n21 + n12];
                    n9 = byArray[n21 + n13];
                    n8 = byArray[n21 + n14];
                    int n22 = n7 = n15 >= 0 ? byArray[n21 + n15] : -1;
                    if ((n11 / n19 + n10 / n19) % 2 == 0) {
                        if (n11 < n18) {
                            TJUnitTest.checkVal255(n11, n10, by, "R");
                            TJUnitTest.checkVal255(n11, n10, n9, "G");
                            TJUnitTest.checkVal255(n11, n10, n8, "B");
                        } else {
                            TJUnitTest.checkVal0(n11, n10, by, "R");
                            TJUnitTest.checkVal0(n11, n10, n9, "G");
                            TJUnitTest.checkVal0(n11, n10, n8, "B");
                        }
                    } else if (n5 == 3) {
                        if (n11 < n18) {
                            TJUnitTest.checkVal(n11, n10, by, "R", 76);
                            TJUnitTest.checkVal(n11, n10, n9, "G", 76);
                            TJUnitTest.checkVal(n11, n10, n8, "B", 76);
                        } else {
                            TJUnitTest.checkVal(n11, n10, by, "R", 226);
                            TJUnitTest.checkVal(n11, n10, n9, "G", 226);
                            TJUnitTest.checkVal(n11, n10, n8, "B", 226);
                        }
                    } else {
                        TJUnitTest.checkVal255(n11, n10, by, "R");
                        if (n11 < n18) {
                            TJUnitTest.checkVal0(n11, n10, n9, "G");
                        } else {
                            TJUnitTest.checkVal255(n11, n10, n9, "G");
                        }
                        TJUnitTest.checkVal0(n11, n10, n8, "B");
                    }
                    TJUnitTest.checkVal255(n11, n10, n7, "A");
                }
            }
        }
        catch (Exception exception) {
            System.out.println("\n" + exception.getMessage());
            n17 = 0;
        }
        if (n17 == 0) {
            for (n11 = 0; n11 < n3; ++n11) {
                for (n10 = 0; n10 < n; ++n10) {
                    int n23;
                    if (n4 == 11) {
                        n23 = byArray[n2 * n11 + n10 * n16];
                        n9 = byArray[n2 * n11 + n10 * n16 + 1];
                        n8 = byArray[n2 * n11 + n10 * n16 + 2];
                        n7 = byArray[n2 * n11 + n10 * n16 + 3];
                        if (n23 < 0) {
                            n23 += 256;
                        }
                        if (n9 < 0) {
                            n9 += 256;
                        }
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if (n7 < 0) {
                            n7 += 256;
                        }
                        System.out.format("%3d/%3d/%3d/%3d ", n23, n9, n8, n7);
                        continue;
                    }
                    n23 = byArray[n2 * n11 + n10 * n16 + n12];
                    n9 = byArray[n2 * n11 + n10 * n16 + n13];
                    n8 = byArray[n2 * n11 + n10 * n16 + n14];
                    if (n23 < 0) {
                        n23 += 256;
                    }
                    if (n9 < 0) {
                        n9 += 256;
                    }
                    if (n8 < 0) {
                        n8 += 256;
                    }
                    System.out.format("%3d/%3d/%3d ", n23, n9, n8);
                }
                System.out.print("\n");
            }
        }
        return n17;
    }

    static int checkIntBuf(int[] nArray, int n, int n2, int n3, int n4, int n5, TJScalingFactor tJScalingFactor, int n6) throws Exception {
        int n7;
        int n8;
        int n9;
        int n10;
        int n11 = TJ.getRedOffset(n4) * 8;
        int n12 = TJ.getGreenOffset(n4) * 8;
        int n13 = TJ.getBlueOffset(n4) * 8;
        int n14 = TJ.getAlphaOffset(n4) * 8;
        int n15 = 1;
        int n16 = 16 * tJScalingFactor.getNum() / tJScalingFactor.getDenom();
        int n17 = 8 * tJScalingFactor.getNum() / tJScalingFactor.getDenom();
        try {
            for (n10 = 0; n10 < n16; ++n10) {
                for (n9 = 0; n9 < n; ++n9) {
                    int n18;
                    int n19 = (n6 & 2) != 0 ? n2 * (n3 - n10 - 1) + n9 : n2 * n10 + n9;
                    int n20 = nArray[n19] >> n11 & 0xFF;
                    n8 = nArray[n19] >> n12 & 0xFF;
                    n7 = nArray[n19] >> n13 & 0xFF;
                    int n21 = n18 = n14 >= 0 ? nArray[n19] >> n14 & 0xFF : 255;
                    if ((n10 / n17 + n9 / n17) % 2 == 0) {
                        if (n10 < n16) {
                            TJUnitTest.checkVal255(n10, n9, n20, "R");
                            TJUnitTest.checkVal255(n10, n9, n8, "G");
                            TJUnitTest.checkVal255(n10, n9, n7, "B");
                        } else {
                            TJUnitTest.checkVal0(n10, n9, n20, "R");
                            TJUnitTest.checkVal0(n10, n9, n8, "G");
                            TJUnitTest.checkVal0(n10, n9, n7, "B");
                        }
                    } else if (n5 == 3) {
                        if (n10 < n16) {
                            TJUnitTest.checkVal(n10, n9, n20, "R", 76);
                            TJUnitTest.checkVal(n10, n9, n8, "G", 76);
                            TJUnitTest.checkVal(n10, n9, n7, "B", 76);
                        } else {
                            TJUnitTest.checkVal(n10, n9, n20, "R", 226);
                            TJUnitTest.checkVal(n10, n9, n8, "G", 226);
                            TJUnitTest.checkVal(n10, n9, n7, "B", 226);
                        }
                    } else {
                        TJUnitTest.checkVal255(n10, n9, n20, "R");
                        if (n10 < n16) {
                            TJUnitTest.checkVal0(n10, n9, n8, "G");
                        } else {
                            TJUnitTest.checkVal255(n10, n9, n8, "G");
                        }
                        TJUnitTest.checkVal0(n10, n9, n7, "B");
                    }
                    TJUnitTest.checkVal255(n10, n9, n18, "A");
                }
            }
        }
        catch (Exception exception) {
            System.out.println("\n" + exception.getMessage());
            n15 = 0;
        }
        if (n15 == 0) {
            for (n10 = 0; n10 < n3; ++n10) {
                for (n9 = 0; n9 < n; ++n9) {
                    int n22 = nArray[n2 * n10 + n9] >> n11 & 0xFF;
                    n8 = nArray[n2 * n10 + n9] >> n12 & 0xFF;
                    n7 = nArray[n2 * n10 + n9] >> n13 & 0xFF;
                    if (n22 < 0) {
                        n22 += 256;
                    }
                    if (n8 < 0) {
                        n8 += 256;
                    }
                    if (n7 < 0) {
                        n7 += 256;
                    }
                    System.out.format("%3d/%3d/%3d ", n22, n8, n7);
                }
                System.out.print("\n");
            }
        }
        return n15;
    }

    static int checkImg(BufferedImage bufferedImage, int n, int n2, TJScalingFactor tJScalingFactor, int n3) throws Exception {
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n4 = bufferedImage.getType();
        if (n4 == 1 || n4 == 4 || n4 == 2 || n4 == 3) {
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)bufferedImage.getSampleModel();
            int n5 = singlePixelPackedSampleModel.getScanlineStride();
            DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
            int[] nArray = dataBufferInt.getData();
            return TJUnitTest.checkIntBuf(nArray, bufferedImage.getWidth(), n5, bufferedImage.getHeight(), n, n2, tJScalingFactor, n3);
        }
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)bufferedImage.getSampleModel();
        int n6 = componentSampleModel.getScanlineStride();
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        byte[] byArray = dataBufferByte.getData();
        return TJUnitTest.checkBuf(byArray, bufferedImage.getWidth(), n6, bufferedImage.getHeight(), n, n2, tJScalingFactor, n3);
    }

    static int pad(int n, int n2) {
        return n + n2 - 1 & ~(n2 - 1);
    }

    static int checkBufYUV(byte[] byArray, int n, int n2, int n3, int n4, TJScalingFactor tJScalingFactor) throws Exception {
        int n5;
        int n6;
        int n7 = TJ.getMCUWidth(n4) / 8;
        int n8 = TJ.getMCUHeight(n4) / 8;
        int n9 = TJUnitTest.pad(n2, n7);
        int n10 = TJUnitTest.pad(n3, n8);
        int n11 = n9 / n7;
        int n12 = n10 / n8;
        int n13 = TJUnitTest.pad(n9, pad);
        int n14 = TJUnitTest.pad(n11, pad);
        int n15 = 1;
        int n16 = n13 * n10 + (n4 == 3 ? 0 : n14 * n12 * 2);
        int n17 = 16 * tJScalingFactor.getNum() / tJScalingFactor.getDenom();
        int n18 = 8 * tJScalingFactor.getNum() / tJScalingFactor.getDenom();
        try {
            byte by;
            if (n != n16) {
                throw new Exception("Incorrect size " + n + ".  Should be " + n16);
            }
            for (n6 = 0; n6 < n10; ++n6) {
                for (n5 = 0; n5 < n9; ++n5) {
                    by = byArray[n13 * n6 + n5];
                    if ((n6 / n18 + n5 / n18) % 2 == 0) {
                        if (n6 < n17) {
                            TJUnitTest.checkVal255(n6, n5, by, "Y");
                            continue;
                        }
                        TJUnitTest.checkVal0(n6, n5, by, "Y");
                        continue;
                    }
                    if (n6 < n17) {
                        TJUnitTest.checkVal(n6, n5, by, "Y", 76);
                        continue;
                    }
                    TJUnitTest.checkVal(n6, n5, by, "Y", 226);
                }
            }
            if (n4 != 3) {
                n17 = 16 / n8 * tJScalingFactor.getNum() / tJScalingFactor.getDenom();
                for (n6 = 0; n6 < n12; ++n6) {
                    for (n5 = 0; n5 < n11; ++n5) {
                        by = byArray[n13 * n10 + (n14 * n6 + n5)];
                        byte by2 = byArray[n13 * n10 + n14 * n12 + (n14 * n6 + n5)];
                        if ((n6 * n8 / n18 + n5 * n7 / n18) % 2 == 0) {
                            TJUnitTest.checkVal(n6, n5, by, "U", 128);
                            TJUnitTest.checkVal(n6, n5, by2, "V", 128);
                            continue;
                        }
                        if (n6 < n17) {
                            TJUnitTest.checkVal(n6, n5, by, "U", 85);
                            TJUnitTest.checkVal255(n6, n5, by2, "V");
                            continue;
                        }
                        TJUnitTest.checkVal0(n6, n5, by, "U");
                        TJUnitTest.checkVal(n6, n5, by2, "V", 149);
                    }
                }
            }
        }
        catch (Exception exception) {
            System.out.println("\n" + exception.getMessage());
            n15 = 0;
        }
        if (n15 == 0) {
            for (n6 = 0; n6 < n10; ++n6) {
                for (n5 = 0; n5 < n9; ++n5) {
                    int n19 = byArray[n13 * n6 + n5];
                    if (n19 < 0) {
                        n19 += 256;
                    }
                    System.out.format("%3d ", n19);
                }
                System.out.print("\n");
            }
            System.out.print("\n");
            for (n6 = 0; n6 < n12; ++n6) {
                for (n5 = 0; n5 < n11; ++n5) {
                    int n20 = byArray[n13 * n10 + (n14 * n6 + n5)];
                    if (n20 < 0) {
                        n20 += 256;
                    }
                    System.out.format("%3d ", n20);
                }
                System.out.print("\n");
            }
            System.out.print("\n");
            for (n6 = 0; n6 < n12; ++n6) {
                for (n5 = 0; n5 < n11; ++n5) {
                    int n21 = byArray[n13 * n10 + n14 * n12 + (n14 * n6 + n5)];
                    if (n21 < 0) {
                        n21 += 256;
                    }
                    System.out.format("%3d ", n21);
                }
                System.out.print("\n");
            }
        }
        return n15;
    }

    static void writeJPEG(byte[] byArray, int n, String string) throws Exception {
        File file = new File(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(byArray, 0, n);
        fileOutputStream.close();
    }

    static int compTest(TJCompressor tJCompressor, byte[] byArray, int n, int n2, int n3, String string, int n4, int n5, int n6) throws Exception {
        Object object;
        String string2;
        String string3;
        String string4;
        byte[] byArray2 = null;
        BufferedImage bufferedImage = null;
        String string5 = (n6 & 2) != 0 ? "BU" : "TD";
        String string6 = (n6 & 2) != 0 ? "Bottom-Up" : "Top-Down ";
        int n7 = 0;
        int n8 = n3;
        if (bi) {
            n3 = TJUnitTest.biTypePF(n8);
            string4 = TJUnitTest.biTypeStr(n8);
            string3 = string4 + " (" + PIXFORMATSTR[n3] + ")";
        } else {
            string3 = string4 = PIXFORMATSTR[n3];
        }
        int n9 = TJ.getPixelSize(n3);
        if (bi) {
            bufferedImage = new BufferedImage(n, n2, n8);
            TJUnitTest.initImg(bufferedImage, n3, n6);
            string2 = string + "_enc_" + string4 + "_" + string5 + "_" + SUBNAME[n4] + "_Q" + n5 + ".png";
            object = new File(string2);
            ImageIO.write((RenderedImage)bufferedImage, "png", (File)object);
            tJCompressor.setSourceImage(bufferedImage, 0, 0, 0, 0);
        } else {
            byArray2 = new byte[n * n2 * n9 + 1];
            TJUnitTest.initBuf(byArray2, n, n * n9, n2, n3, n6);
            tJCompressor.setSourceImage(byArray2, 0, 0, n, 0, n2, n3);
        }
        Arrays.fill(byArray, (byte)0);
        tJCompressor.setSubsamp(n4);
        tJCompressor.setJPEGQuality(n5);
        if (doYUV) {
            System.out.format("%s %s -> YUV %s ... ", string3, string6, SUBNAME_LONG[n4]);
            object = tJCompressor.encodeYUV(pad, n6);
            if (TJUnitTest.checkBufYUV(((YUVImage)object).getBuf(), ((YUVImage)object).getSize(), n, n2, n4, new TJScalingFactor(1, 1)) == 1) {
                System.out.print("Passed.\n");
            } else {
                System.out.print("FAILED!\n");
                exitStatus = -1;
            }
            System.out.format("YUV %s %s -> JPEG Q%d ... ", SUBNAME_LONG[n4], string6, n5);
            tJCompressor.setSourceImage((YUVImage)object);
        } else {
            System.out.format("%s %s -> %s Q%d ... ", string3, string6, SUBNAME_LONG[n4], n5);
        }
        tJCompressor.compress(byArray, n6);
        n7 = tJCompressor.getCompressedSize();
        string2 = string + "_enc_" + string4 + "_" + string5 + "_" + SUBNAME[n4] + "_Q" + n5 + ".jpg";
        TJUnitTest.writeJPEG(byArray, n7, string2);
        System.out.println("Done.\n  Result in " + string2);
        return n7;
    }

    static void decompTest(TJDecompressor tJDecompressor, byte[] byArray, int n, int n2, int n3, int n4, String string, int n5, int n6, TJScalingFactor tJScalingFactor) throws Exception {
        Object object;
        String string2;
        String string3;
        String string4 = (n6 & 2) != 0 ? "Bottom-Up" : "Top-Down ";
        int n7 = tJScalingFactor.getScaled(n2);
        int n8 = tJScalingFactor.getScaled(n3);
        int n9 = n4;
        BufferedImage bufferedImage = null;
        byte[] byArray2 = null;
        if (bi) {
            n4 = TJUnitTest.biTypePF(n9);
            string3 = TJUnitTest.biTypeStr(n9);
            string2 = string3 + " (" + PIXFORMATSTR[n4] + ")";
        } else {
            string2 = string3 = PIXFORMATSTR[n4];
        }
        tJDecompressor.setSourceImage(byArray, n);
        if (tJDecompressor.getWidth() != n2 || tJDecompressor.getHeight() != n3 || tJDecompressor.getSubsamp() != n5) {
            throw new Exception("Incorrect JPEG header");
        }
        int n10 = n7;
        int n11 = n8;
        n10 = tJDecompressor.getScaledWidth(n10, n11);
        n11 = tJDecompressor.getScaledHeight(n10, n11);
        if (n10 != n7 || n11 != n8) {
            throw new Exception("Scaled size mismatch");
        }
        if (doYUV) {
            System.out.format("JPEG -> YUV %s ", SUBNAME_LONG[n5]);
            if (!tJScalingFactor.isOne()) {
                System.out.format("%d/%d ... ", tJScalingFactor.getNum(), tJScalingFactor.getDenom());
            } else {
                System.out.print("... ");
            }
            object = tJDecompressor.decompressToYUV(n7, pad, n8, n6);
            if (TJUnitTest.checkBufYUV(((YUVImage)object).getBuf(), ((YUVImage)object).getSize(), n7, n8, n5, tJScalingFactor) == 1) {
                System.out.print("Passed.\n");
            } else {
                System.out.print("FAILED!\n");
                exitStatus = -1;
            }
            System.out.format("YUV %s -> %s %s ... ", SUBNAME_LONG[n5], string2, string4);
            tJDecompressor.setSourceImage((YUVImage)object);
        } else {
            System.out.format("JPEG -> %s %s ", string2, string4);
            if (!tJScalingFactor.isOne()) {
                System.out.format("%d/%d ... ", tJScalingFactor.getNum(), tJScalingFactor.getDenom());
            } else {
                System.out.print("... ");
            }
        }
        if (bi) {
            bufferedImage = tJDecompressor.decompress(n7, n8, n9, n6);
        } else {
            byArray2 = tJDecompressor.decompress(n7, 0, n8, n4, n6);
        }
        if (bi) {
            String string5 = string + "_dec_" + string3 + "_" + ((n6 & 2) != 0 ? "BU" : "TD") + "_" + SUBNAME[n5] + "_" + (double)tJScalingFactor.getNum() / (double)tJScalingFactor.getDenom() + "x.png";
            object = new File(string5);
            ImageIO.write((RenderedImage)bufferedImage, "png", (File)object);
        }
        if (bi && TJUnitTest.checkImg(bufferedImage, n4, n5, tJScalingFactor, n6) == 1 || !bi && TJUnitTest.checkBuf(byArray2, n7, n7 * TJ.getPixelSize(n4), n8, n4, n5, tJScalingFactor, n6) == 1) {
            System.out.print("Passed.\n");
        } else {
            System.out.print("FAILED!\n");
            exitStatus = -1;
        }
    }

    static void decompTest(TJDecompressor tJDecompressor, byte[] byArray, int n, int n2, int n3, int n4, String string, int n5, int n6) throws Exception {
        TJScalingFactor[] tJScalingFactorArray = TJ.getScalingFactors();
        for (int i = 0; i < tJScalingFactorArray.length; ++i) {
            int n7 = tJScalingFactorArray[i].getNum();
            int n8 = tJScalingFactorArray[i].getDenom();
            if (n5 != 0 && n5 != 3 && (n5 != 5 || n7 != 1 || n8 != 2 && n8 != 1) && (n5 == 5 || n7 != 1 || n8 != 4 && n8 != 2 && n8 != 1)) continue;
            TJUnitTest.decompTest(tJDecompressor, byArray, n, n2, n3, n4, string, n5, n6, tJScalingFactorArray[i]);
        }
    }

    static void doTest(int n, int n2, int[] nArray, int n3, String string) throws Exception {
        TJCompressor tJCompressor = null;
        TJDecompressor tJDecompressor = null;
        byte[] byArray = new byte[TJ.bufSize(n, n2, n3)];
        try {
            tJCompressor = new TJCompressor();
            tJDecompressor = new TJDecompressor();
            for (int n4 : nArray) {
                if (n4 < 0) continue;
                for (int i = 0; i < 2; ++i) {
                    int n5 = 0;
                    if (n3 == 1 || n3 == 2 || n3 == 4 || n3 == 5) {
                        n5 |= 0x100;
                    }
                    if (i == 1) {
                        n5 |= 2;
                    }
                    int n6 = TJUnitTest.compTest(tJCompressor, byArray, n, n2, n4, string, n3, 100, n5);
                    TJUnitTest.decompTest(tJDecompressor, byArray, n6, n, n2, n4, string, n3, n5);
                    if (n4 >= 2 && n4 <= 5 && !bi) {
                        System.out.print("\n");
                        TJUnitTest.decompTest(tJDecompressor, byArray, n6, n, n2, n4 + 5, string, n3, n5);
                    }
                    System.out.print("\n");
                }
            }
            System.out.print("--------------------\n\n");
        }
        catch (Exception exception) {
            if (tJCompressor != null) {
                tJCompressor.close();
            }
            if (tJDecompressor != null) {
                tJDecompressor.close();
            }
            throw exception;
        }
        if (tJCompressor != null) {
            tJCompressor.close();
        }
        if (tJDecompressor != null) {
            tJDecompressor.close();
        }
    }

    static void bufSizeTest() throws Exception {
        byte[] byArray = null;
        YUVImage yUVImage = null;
        TJCompressor tJCompressor = null;
        Random random = new Random();
        try {
            tJCompressor = new TJCompressor();
            System.out.println("Buffer size regression test");
            for (int i = 0; i < 6; ++i) {
                for (int j = 1; j < 48; ++j) {
                    int n = j == 1 ? 2048 : 48;
                    for (int k = 1; k < n; ++k) {
                        int n2;
                        if (k % 100 == 0) {
                            System.out.format("%04d x %04d\b\b\b\b\b\b\b\b\b\b\b", j, k);
                        }
                        byte[] byArray2 = new byte[j * k * 4];
                        if (doYUV) {
                            yUVImage = new YUVImage(j, pad, k, i);
                        } else {
                            byArray = new byte[TJ.bufSize(j, k, i)];
                        }
                        for (n2 = 0; n2 < j * k * 4; ++n2) {
                            byArray2[n2] = (byte)(random.nextInt(2) * 255);
                        }
                        tJCompressor.setSourceImage(byArray2, 0, 0, j, 0, k, 3);
                        tJCompressor.setSubsamp(i);
                        tJCompressor.setJPEGQuality(100);
                        if (doYUV) {
                            tJCompressor.encodeYUV(yUVImage, 0);
                        } else {
                            tJCompressor.compress(byArray, 0);
                        }
                        byArray2 = new byte[k * j * 4];
                        if (doYUV) {
                            yUVImage = new YUVImage(k, pad, j, i);
                        } else {
                            byArray = new byte[TJ.bufSize(k, j, i)];
                        }
                        for (n2 = 0; n2 < k * j * 4; ++n2) {
                            byArray2[n2] = (byte)(random.nextInt(2) * 255);
                        }
                        tJCompressor.setSourceImage(byArray2, 0, 0, k, 0, j, 3);
                        if (doYUV) {
                            tJCompressor.encodeYUV(yUVImage, 0);
                            continue;
                        }
                        tJCompressor.compress(byArray, 0);
                    }
                    yUVImage = null;
                    byArray = null;
                    System.gc();
                }
            }
            System.out.println("Done.      ");
        }
        catch (Exception exception) {
            if (tJCompressor != null) {
                tJCompressor.close();
            }
            throw exception;
        }
        if (tJCompressor != null) {
            tJCompressor.close();
        }
    }

    public static void main(String[] stringArray) {
        try {
            String string = "javatest";
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equalsIgnoreCase("-yuv")) {
                    doYUV = true;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-noyuvpad")) {
                    pad = 1;
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-bi")) {
                    bi = true;
                    string = "javabitest";
                    continue;
                }
                TJUnitTest.usage();
            }
            if (doYUV) {
                TJUnitTest.FORMATS_4BYTE[4] = -1;
            }
            TJUnitTest.doTest(35, 39, bi ? FORMATS_3BYTEBI : FORMATS_3BYTE, 0, string);
            TJUnitTest.doTest(39, 41, bi ? FORMATS_4BYTEBI : FORMATS_4BYTE, 0, string);
            TJUnitTest.doTest(41, 35, bi ? FORMATS_3BYTEBI : FORMATS_3BYTE, 1, string);
            TJUnitTest.doTest(35, 39, bi ? FORMATS_4BYTEBI : FORMATS_4BYTE, 1, string);
            TJUnitTest.doTest(39, 41, bi ? FORMATS_3BYTEBI : FORMATS_3BYTE, 2, string);
            TJUnitTest.doTest(41, 35, bi ? FORMATS_4BYTEBI : FORMATS_4BYTE, 2, string);
            TJUnitTest.doTest(35, 39, bi ? FORMATS_3BYTEBI : FORMATS_3BYTE, 4, string);
            TJUnitTest.doTest(39, 41, bi ? FORMATS_4BYTEBI : FORMATS_4BYTE, 4, string);
            TJUnitTest.doTest(41, 35, bi ? FORMATS_3BYTEBI : FORMATS_3BYTE, 5, string);
            TJUnitTest.doTest(35, 39, bi ? FORMATS_4BYTEBI : FORMATS_4BYTE, 5, string);
            TJUnitTest.doTest(39, 41, bi ? FORMATS_GRAYBI : FORMATS_GRAY, 3, string);
            TJUnitTest.doTest(41, 35, bi ? FORMATS_3BYTEBI : FORMATS_3BYTE, 3, string);
            TJUnitTest.FORMATS_4BYTE[4] = -1;
            TJUnitTest.doTest(35, 39, bi ? FORMATS_4BYTEBI : FORMATS_4BYTE, 3, string);
            if (!bi) {
                TJUnitTest.bufSizeTest();
            }
            if (doYUV && !bi) {
                System.out.print("\n--------------------\n\n");
                TJUnitTest.doTest(48, 48, FORMATS_RGB, 0, "javatest_yuv0");
                TJUnitTest.doTest(48, 48, FORMATS_RGB, 1, "javatest_yuv0");
                TJUnitTest.doTest(48, 48, FORMATS_RGB, 2, "javatest_yuv0");
                TJUnitTest.doTest(48, 48, FORMATS_RGB, 4, "javatest_yuv0");
                TJUnitTest.doTest(48, 48, FORMATS_RGB, 5, "javatest_yuv0");
                TJUnitTest.doTest(48, 48, FORMATS_RGB, 3, "javatest_yuv0");
                TJUnitTest.doTest(48, 48, FORMATS_GRAY, 3, "javatest_yuv0");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            exitStatus = -1;
        }
        System.exit(exitStatus);
    }
}

