/*
 * Decompiled with CFR 0.152.
 */
package com.nexwave.nquindexer;

import com.nexwave.nsidita.DocFileInfo;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class WriteJSFiles {
    private static String txt_VM_encoding_not_supported = "This VM does not support the specified encoding.";
    private static String txt_indices_location = "The created index files are located in ";

    public static void WriteHTMLList(String string, ArrayList<String> arrayList, boolean bl) {
        int n = 0;
        if (arrayList == null) {
            return;
        }
        if (string == null) {
            return;
        }
        Iterator<String> iterator = arrayList.iterator();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)bufferedOutputStream, "UTF-8");
            outputStreamWriter.write("var doStem = " + bl + ";\n");
            outputStreamWriter.write("//List of indexed files.\n");
            outputStreamWriter.write("fl = new Array();\n");
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                outputStreamWriter.write("fl[\"" + n + "\"]= \"" + string2.replace(File.separatorChar, '/') + "\";\n");
                ++n;
            }
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println(txt_VM_encoding_not_supported);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
    }

    public static void WriteHTMLInfoList(String string, ArrayList<DocFileInfo> arrayList) {
        int n = 0;
        Iterator<DocFileInfo> iterator = null;
        if (arrayList == null) {
            return;
        }
        if (string == null) {
            return;
        }
        iterator = arrayList.iterator();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string, true);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)bufferedOutputStream, "UTF-8");
            outputStreamWriter.write("fil = new Array();\n");
            while (iterator.hasNext()) {
                DocFileInfo docFileInfo = iterator.next();
                String string2 = docFileInfo.getFullpath().toString().replace(File.separatorChar, '/');
                String string3 = docFileInfo.getTitle();
                String string4 = docFileInfo.getShortdesc();
                if (string3 != null) {
                    string3 = string3.replaceAll("\\s+", " ");
                    string3 = string3.replaceAll("['\ufffd\"]", " ");
                    string3 = string3.replaceAll("\\\\", "\\\\\\\\");
                }
                if (string4 != null) {
                    string4 = string4.replaceAll("\\s+", " ");
                    string4 = string4.replaceAll("['\ufffd\"]", " ");
                    string4 = string4.replaceAll("\\\\", "\\\\\\\\");
                }
                if (string4 != null) {
                    String string5 = WriteJSFiles.stripNonAlphabeticalChars(string4);
                    if (string5.length() > 140) {
                        string5 = string5.substring(0, 137);
                    }
                    string5 = string5 + "...";
                    outputStreamWriter.write("fil[\"" + n + "\"]= \"" + string2 + "@@@" + string3 + "@@@" + string5 + "\";\n");
                    ++n;
                    continue;
                }
                outputStreamWriter.write("fil[\"" + n + "\"]= \"" + string2 + "@@@" + string3 + "@@@null\";\n");
                ++n;
            }
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println(txt_VM_encoding_not_supported);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
    }

    public static void WriteIndex(String string, Map<String, ?> map, String string2) {
        if (map == null || string == null) {
            return;
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.addAll(map.keySet());
        Iterator iterator = treeSet.iterator();
        String string3 = (String)iterator.next();
        File file = new File(string);
        int n = treeSet.size();
        for (int i = 1; i <= 3; ++i) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file.getParent() + File.separator + "index-" + i + file.getName());
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)bufferedOutputStream, "UTF-8");
                try {
                    int n2 = 0;
                    if (i == 1) {
                        outputStreamWriter.write("var indexerLanguage=\"" + string2 + "\";\n");
                    }
                    outputStreamWriter.write("//Auto generated index for searching by xsl-webhelpindexer for DocBook Webhelp.# Kasun Gajasinghe, University of Moratuwa\n");
                    while (iterator.hasNext()) {
                        outputStreamWriter.write("w[\"" + string3 + "\"]=\"" + map.get(string3) + "\";\n");
                        string3 = (String)iterator.next();
                        if (n / ++n2 >= 3) continue;
                    }
                    outputStreamWriter.write("\n");
                    outputStreamWriter.flush();
                    outputStreamWriter.close();
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    System.out.println(txt_VM_encoding_not_supported);
                }
                continue;
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
            }
        }
        System.out.println(txt_indices_location + file.getParent());
    }

    private static String stripNonAlphabeticalChars(String string) {
        String string2 = string;
        for (int i = string.length() - 1; i > 0; --i) {
            char c = string.charAt(i);
            char c2 = c;
            if (c2 > 'A' && c2 < '[' || c2 > 'a' && c2 < '{' || c2 > '0' && c2 < ':') {
                return string2;
            }
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    private static String stripWords(String string) {
        int n = string.lastIndexOf(" ");
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }
}

