/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import com.frostwire.util.Logger;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import org.limewire.util.OSUtils;

public class SystemUtils {
    private static final Logger LOG = Logger.getLogger(SystemUtils.class);
    private static boolean isLoaded;

    private SystemUtils() {
    }

    static void setWriteable(String fileName) {
        if (isLoaded && (OSUtils.isWindows() || OSUtils.isMacOSX())) {
            SystemUtils.setFileWriteable(fileName);
        }
    }

    public static String getRunningPath() {
        try {
            if (OSUtils.isWindows() && isLoaded) {
                String path = SystemUtils.getRunningPathNative();
                return path.equals("") ? null : path;
            }
            return null;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static String getSpecialPath(SpecialLocations location) {
        if (OSUtils.isWindows() && isLoaded) {
            try {
                String path = SystemUtils.getSpecialPathNative(location.getName());
                if (!path.equals("")) {
                    return path;
                }
            }
            catch (UnsatisfiedLinkError error) {
                LOG.error("Unable to use getSpecialPath!", error);
            }
        }
        return null;
    }

    public static boolean setWindowIcon(Component frame, File icon) {
        if (OSUtils.isWindows() && isLoaded) {
            String result = SystemUtils.setWindowIconNative(frame, System.getProperty("sun.boot.library.path"), icon.getPath());
            return result.equals("");
        }
        return false;
    }

    public static long getWindowHandle(Component frame) {
        if ((OSUtils.isWindows() || OSUtils.isLinux()) && isLoaded) {
            return SystemUtils.getWindowHandleNative(frame, System.getProperty("sun.boot.library.path"));
        }
        return 0L;
    }

    public static boolean toggleFullScreen(long hwnd) {
        return isLoaded && (OSUtils.isWindows() || OSUtils.isLinux()) ? SystemUtils.toggleFullScreenNative(hwnd) : false;
    }

    public static boolean flushIconCache() {
        return isLoaded && OSUtils.isWindows() ? SystemUtils.flushIconCacheNative() : false;
    }

    public static String registryReadText(String root, String path, String name) throws IOException {
        if (OSUtils.isWindows() && isLoaded) {
            return SystemUtils.registryReadTextNative(root, path, name);
        }
        throw new IOException(" not supported ");
    }

    public static boolean registryWriteNumber(String root, String path, String name, int value) {
        return OSUtils.isWindows() && isLoaded ? SystemUtils.registryWriteNumberNative(root, path, name, value) : false;
    }

    public static boolean registryWriteText(String root, String path, String name, String value) {
        return OSUtils.isWindows() && isLoaded ? SystemUtils.registryWriteTextNative(root, path, name, value) : false;
    }

    public static boolean registryDelete(String root, String path) {
        return OSUtils.isWindows() && isLoaded ? SystemUtils.registryDeleteNative(root, path) : false;
    }

    public static boolean isFirewallPresent() {
        return OSUtils.isWindows() && isLoaded ? SystemUtils.firewallPresentNative() : false;
    }

    public static boolean isFirewallEnabled() {
        return OSUtils.isWindows() && isLoaded ? SystemUtils.firewallEnabledNative() : false;
    }

    public static boolean isProgramListedOnFirewall(String path) {
        return OSUtils.isWindows() && isLoaded ? SystemUtils.firewallIsProgramListedNative(path) : false;
    }

    public static boolean addProgramToFirewall(String path, String name) {
        return OSUtils.isWindows() && isLoaded ? SystemUtils.firewallAddNative(path, name) : false;
    }

    public static boolean removeProgramFromFirewall(String path) {
        return OSUtils.isWindows() && isLoaded ? SystemUtils.firewallRemoveNative(path) : false;
    }

    public static int openURL(String url) throws IOException {
        if (OSUtils.isWindows() && isLoaded) {
            SystemUtils.openURLNative(url);
            return 0;
        }
        throw new IOException("native code not linked");
    }

    public static int openFile(String path) throws IOException {
        if (OSUtils.isWindows() && isLoaded) {
            SystemUtils.openFileNative(path);
            return 0;
        }
        throw new IOException("native code not linked");
    }

    public static int openFile(String path, String params) throws IOException {
        if (OSUtils.isWindows() && isLoaded) {
            SystemUtils.openFileParamsNative(path, params);
            return 0;
        }
        throw new IOException("native code not linked");
    }

    public static String getShortFileName(String fileName) {
        return OSUtils.isWindows() && isLoaded ? SystemUtils.getShortFileNameNative(fileName) : fileName;
    }

    public static boolean recycle(File file) {
        if (OSUtils.isWindows() && isLoaded) {
            String path = null;
            try {
                path = file.getCanonicalPath();
            }
            catch (IOException err) {
                LOG.error("IOException", err);
                path = file.getAbsolutePath();
            }
            return SystemUtils.recycleNative(path);
        }
        return false;
    }

    public static String getDefaultExtentionHandler(String extention) {
        if (!OSUtils.isWindows() || !isLoaded) {
            return null;
        }
        if (!extention.startsWith(".")) {
            extention = "." + extention;
        }
        try {
            String progId = SystemUtils.registryReadText("HKEY_CLASSES_ROOT", extention, "");
            return "".equals(progId) ? "" : SystemUtils.registryReadText("HKEY_CLASSES_ROOT", progId + "\\shell\\open\\command", "");
        }
        catch (IOException iox) {
            return null;
        }
    }

    public static String getDefaultMimeHandler(String mimeType) {
        if (!OSUtils.isWindows() || !isLoaded) {
            return null;
        }
        String extention = "";
        try {
            extention = SystemUtils.registryReadText("HKEY_CLASSES_ROOT", "MIME\\Database\\Content Type\\" + mimeType, "Extension");
        }
        catch (IOException iox) {
            return null;
        }
        return "".equals(extention) ? "" : SystemUtils.getDefaultExtentionHandler(extention);
    }

    private static native String getRunningPathNative();

    private static native String getSpecialPathNative(String var0);

    private static native String getShortFileNameNative(String var0);

    private static native void openURLNative(String var0);

    private static native void openFileNative(String var0);

    private static native void openFileParamsNative(String var0, String var1);

    private static native boolean recycleNative(String var0);

    private static native int setFileWriteable(String var0);

    private static native String setWindowIconNative(Component var0, String var1, String var2);

    private static native long getWindowHandleNative(Component var0, String var1);

    private static native boolean flushIconCacheNative();

    private static native boolean toggleFullScreenNative(long var0);

    private static native int registryReadNumberNative(String var0, String var1, String var2) throws IOException;

    private static native String registryReadTextNative(String var0, String var1, String var2) throws IOException;

    private static native boolean registryWriteNumberNative(String var0, String var1, String var2, int var3);

    private static native boolean registryWriteTextNative(String var0, String var1, String var2, String var3);

    private static native boolean registryDeleteNative(String var0, String var1);

    private static native boolean firewallPresentNative();

    private static native boolean firewallEnabledNative();

    private static native boolean firewallExceptionsNotAllowedNative();

    private static native boolean firewallIsProgramListedNative(String var0);

    private static native boolean firewallIsProgramEnabledNative(String var0);

    private static native boolean firewallAddNative(String var0, String var1);

    private static native boolean firewallRemoveNative(String var0);

    static {
        boolean canLoad = false;
        try {
            if (OSUtils.isWindows() && OSUtils.isGoodWindows()) {
                if (OSUtils.isMachineX64()) {
                    System.loadLibrary("SystemUtilities");
                } else {
                    System.loadLibrary("SystemUtilitiesX86");
                }
                canLoad = true;
            }
            if (OSUtils.isMacOSX()) {
                System.loadLibrary("SystemUtilities");
                canLoad = true;
            }
            if (OSUtils.isLinux()) {
                if (OSUtils.isMachineX64()) {
                    System.loadLibrary("SystemUtilities");
                } else {
                    System.loadLibrary("SystemUtilitiesX86");
                }
                canLoad = true;
            }
        }
        catch (Throwable noGo) {
            System.out.println("ERROR: " + noGo.getMessage());
            canLoad = false;
        }
        isLoaded = canLoad;
    }

    public static enum SpecialLocations {
        DOCUMENTS("Documents"),
        DOWNLOADS("Downloads"),
        APPLICATION_DATA("ApplicationData"),
        DESKTOP("Desktop"),
        START_MENU("StartMenu"),
        START_MENU_PROGRAMS("StartMenuPrograms"),
        START_MENU_STARTUP("StartMenuStartup");

        private final String name;

        private SpecialLocations(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

