/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.Properties;
import org.limewire.util.FileUtils;
import org.limewire.util.I18NConvert;
import org.limewire.util.OSUtils;

public class CommonUtils {
    private static final String FROSTWIRE_420_PREFS_DIR_NAME = ".frostwire4.20";
    private static final String FROSTWIRE_500_PREFS_DIR_NAME = ".frostwire5";
    private static final String META_SETTINGS_KEY_USER_SETTINGS_WINDOWS = "user.settings.dir.windows";
    private static final String META_SETTINGS_KEY_USER_SETTINGS_MAC = "user.settings.dir.mac";
    private static final String META_SETTINGS_KEY_USER_SETTINGS_POSIX = "user.settings.dir.posix";
    private static final String META_SETTINGS_KEY_ROOT_FOLDER_WINDOWS = "user.settings.root_folder.windows";
    private static final String META_SETTINGS_KEY_ROOT_FOLDER_MAC = "user.settings.root_folder.mac";
    private static final String META_SETTINGS_KEY_ROOT_FOLDER_POSIX = "user.settings.root_folder.posix";
    private static final char[] ILLEGAL_CHARS_ANY_OS = new char[]{'/', '\n', '\r', '\t', '\u0000', '\f'};
    private static final char[] ILLEGAL_CHARS_UNIX = new char[]{'`'};
    private static final char[] ILLEGAL_CHARS_WINDOWS = new char[]{'?', '*', '\\', '<', '>', '|', '\"', ':'};
    private static final char[] ILLEGAL_CHARS_MACOS = new char[]{':'};
    private static volatile File settingsDirectory = null;

    public static File getUserHomeDir() {
        return new File(System.getProperty("user.home"));
    }

    static InputStream getResourceStream(String location) throws IOException {
        ClassLoader cl = CommonUtils.class.getClassLoader();
        URL resource = cl == null ? ClassLoader.getSystemResource(location) : cl.getResource(location);
        if (resource == null) {
            throw new IOException("null resource: " + location);
        }
        return resource.openStream();
    }

    public static String decode(String s) {
        StringBuilder sb = new StringBuilder();
        block8: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    continue block8;
                }
                case '%': {
                    try {
                        sb.append((char)Integer.parseInt(s.substring(i + 1, i + 3), 16));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException(s);
                    }
                    i += 2;
                    continue block8;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        String result = sb.toString();
        try {
            byte[] inputBytes = result.getBytes("8859_1");
            result = new String(inputBytes);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return result;
    }

    public static String seconds2time(long seconds) {
        long minutes = seconds / 60L;
        seconds -= minutes * 60L;
        long hours = minutes / 60L;
        minutes -= hours * 60L;
        long days = hours / 24L;
        hours -= days * 24L;
        StringBuilder time = new StringBuilder();
        if (days != 0L) {
            time.append(Long.toString(days));
            time.append(":");
            if (hours < 10L) {
                time.append("0");
            }
        }
        if (days != 0L || hours != 0L) {
            time.append(Long.toString(hours));
            time.append(":");
            if (minutes < 10L) {
                time.append("0");
            }
        }
        time.append(Long.toString(minutes));
        time.append(":");
        if (seconds < 10L) {
            time.append("0");
        }
        time.append(Long.toString(seconds));
        return time.toString();
    }

    public static String convertFileName(String name) {
        return CommonUtils.convertFileName(name, 180);
    }

    private static String convertFileName(String name, int maxBytes) {
        try {
            return CommonUtils.convertFileName(name, maxBytes, Charset.defaultCharset());
        }
        catch (CharacterCodingException cce) {
            try {
                return CommonUtils.convertFileName(name, maxBytes, Charset.forName("UTF-8"));
            }
            catch (CharacterCodingException e) {
                throw new RuntimeException("UTF-8 should have encoded: " + name, e);
            }
        }
    }

    private static String convertFileName(String name, int maxBytes, Charset charSet) throws CharacterCodingException {
        block11: {
            block12: {
                block10: {
                    if (maxBytes <= 0) {
                        throw new IllegalArgumentException("maxBytes must be > 0");
                    }
                    name = I18NConvert.instance().compose(name);
                    if (name.length() > maxBytes || name.getBytes().length > maxBytes) {
                        int extStart = name.lastIndexOf(46);
                        if (extStart == -1) {
                            name = CommonUtils.getPrefixWithMaxBytes(name, maxBytes, charSet);
                        } else {
                            int extLength = name.length() - extStart;
                            int extEnd = extLength > 11 ? extStart + 11 : name.length();
                            byte[] extension = CommonUtils.getMaxBytes(name.substring(extStart, extEnd), 16, charSet);
                            try {
                                name = extension.length >= maxBytes - 10 ? CommonUtils.getPrefixWithMaxBytes(name, maxBytes, charSet) : CommonUtils.getPrefixWithMaxBytes(name, maxBytes - extension.length, charSet) + new String(extension, charSet.name());
                            }
                            catch (UnsupportedEncodingException uee) {
                                throw new RuntimeException("Could not handle string", uee);
                            }
                        }
                    }
                    for (char ILLEGAL_CHARS_ANY_O : ILLEGAL_CHARS_ANY_OS) {
                        name = name.replace(ILLEGAL_CHARS_ANY_O, '_');
                    }
                    if (!OSUtils.isWindows() && !OSUtils.isOS2()) break block10;
                    for (char ILLEGAL_CHARS_WINDOW : ILLEGAL_CHARS_WINDOWS) {
                        name = name.replace(ILLEGAL_CHARS_WINDOW, '_');
                    }
                    break block11;
                }
                if (!OSUtils.isLinux() && !OSUtils.isSolaris()) break block12;
                for (char aILLEGAL_CHARS_UNIX : ILLEGAL_CHARS_UNIX) {
                    name = name.replace(aILLEGAL_CHARS_UNIX, '_');
                }
                break block11;
            }
            if (!OSUtils.isMacOSX()) break block11;
            for (char ILLEGAL_CHARS_MACO : ILLEGAL_CHARS_MACOS) {
                name = name.replace(ILLEGAL_CHARS_MACO, '_');
            }
        }
        return name;
    }

    private static String getPrefixWithMaxBytes(String string, int maxBytes, Charset charSet) throws CharacterCodingException {
        try {
            return new String(CommonUtils.getMaxBytes(string, maxBytes, charSet), charSet.name());
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("Could not recreate string", uee);
        }
    }

    private static byte[] getMaxBytes(String string, int maxBytes, Charset charSet) throws CharacterCodingException {
        byte[] bytes = new byte[maxBytes];
        ByteBuffer out = ByteBuffer.wrap(bytes);
        CharBuffer in = CharBuffer.wrap(string.toCharArray());
        CharsetEncoder encoder = charSet.newEncoder();
        CoderResult cr = encoder.encode(in, out, true);
        encoder.flush(out);
        if (cr.isError()) {
            cr.throwException();
        }
        byte[] result = new byte[out.position()];
        System.arraycopy(bytes, 0, result, 0, result.length);
        return result;
    }

    public static File getCurrentDirectory() {
        return new File(System.getProperty("user.dir"));
    }

    public static String getExecutableDirectory() {
        String defaultPath;
        String decodedPath = defaultPath = "/Applications/FrostWire.app/";
        try {
            String path;
            Class<?> clazz = Class.forName("com.limegroup.gnutella.gui.Main");
            if (clazz != null && (decodedPath = URLDecoder.decode(path = clazz.getProtectionDomain().getCodeSource().getLocation().getPath(), "UTF-8")) != null && decodedPath.toLowerCase().lastIndexOf("frostwire.jar") != -1) {
                decodedPath = decodedPath.substring(0, decodedPath.toLowerCase().lastIndexOf("frostwire.jar"));
            }
        }
        catch (Throwable t) {
            decodedPath = defaultPath;
        }
        return decodedPath;
    }

    private static File validateSettingsDirectory(File dir) throws IOException {
        if (!(dir = dir.getAbsoluteFile()).isDirectory()) {
            dir.delete();
            if (!dir.mkdirs()) {
                throw new IOException("could not create preferences directory: " + dir);
            }
        }
        if (!dir.canWrite()) {
            throw new IOException("settings dir not writable: " + dir);
        }
        if (!dir.canRead()) {
            throw new IOException("settings dir not readable: " + dir);
        }
        File file = File.createTempFile("test", "test", dir);
        if (!file.exists()) {
            throw new IOException("can't write test file in directory: " + dir);
        }
        file.delete();
        return dir;
    }

    public static void setUserSettingsDir(File settingsDir) throws IOException {
        if (settingsDirectory != null) {
            throw new IllegalStateException("settings directory already set!");
        }
        settingsDirectory = CommonUtils.validateSettingsDirectory(settingsDir);
    }

    public static synchronized File getUserSettingsDir() {
        if (settingsDirectory != null) {
            return settingsDirectory;
        }
        return CommonUtils.getUserSettingsDir2();
    }

    private static File getUserSettingsDir2() {
        Properties metaConfiguration = CommonUtils.loadMetaConfiguration();
        if (!metaConfiguration.isEmpty()) {
            return CommonUtils.getPortableSettingsDir(metaConfiguration);
        }
        File userDir = CommonUtils.getUserHomeDir();
        if (OSUtils.isWindows() && userDir.exists()) {
            FileUtils.setWriteable(userDir);
        }
        File settingsDir = new File(userDir, FROSTWIRE_500_PREFS_DIR_NAME);
        if (OSUtils.isMacOSX()) {
            settingsDir = new File(CommonUtils.getUserHomeDir(), "Library/Preferences/FrostWire5");
        }
        return settingsDir;
    }

    public static File getFrostWire4UserSettingsDir() {
        File userDir = CommonUtils.getUserHomeDir();
        File settingsDir = new File(userDir, FROSTWIRE_420_PREFS_DIR_NAME);
        if (OSUtils.isMacOSX()) {
            settingsDir = new File(CommonUtils.getUserHomeDir(), "Library/Preferences/FrostWire");
        }
        return settingsDir;
    }

    public static boolean isDebugMode() {
        return ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("-agentlib:jdwp") > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadMetaConfiguration() {
        Properties meta = new Properties();
        File metaFile = new File(".meta");
        if (metaFile.exists() && metaFile.isFile() && metaFile.canRead()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(metaFile);
                meta.load(fis);
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    CommonUtils.closeQuietly(fis);
                    throw throwable;
                }
                CommonUtils.closeQuietly(fis);
            }
            CommonUtils.closeQuietly(fis);
        }
        return meta;
    }

    public static File getPortableSettingsDir(Properties metaConfiguration) {
        return CommonUtils.getPortableMetaFile(metaConfiguration, META_SETTINGS_KEY_USER_SETTINGS_WINDOWS, META_SETTINGS_KEY_USER_SETTINGS_MAC, META_SETTINGS_KEY_USER_SETTINGS_POSIX);
    }

    public static File getPortableRootFolder() {
        Properties metaConfiguration = CommonUtils.loadMetaConfiguration();
        return CommonUtils.getPortableRootFolder(metaConfiguration);
    }

    private static File getPortableRootFolder(Properties metaConfiguration) {
        return CommonUtils.getPortableMetaFile(metaConfiguration, META_SETTINGS_KEY_ROOT_FOLDER_WINDOWS, META_SETTINGS_KEY_ROOT_FOLDER_MAC, META_SETTINGS_KEY_ROOT_FOLDER_POSIX);
    }

    private static File getPortableMetaFile(Properties metaConfiguration, String windowsKey, String macKey, String posixKey) {
        File portableMetaDir = null;
        String metaKey = null;
        if (OSUtils.isWindows() && metaConfiguration.containsKey(windowsKey)) {
            metaKey = windowsKey;
        } else if (OSUtils.isMacOSX() && metaConfiguration.containsKey(macKey)) {
            metaKey = macKey;
        } else if (OSUtils.isLinux() && metaConfiguration.containsKey(posixKey)) {
            metaKey = posixKey;
        }
        if (metaKey != null) {
            portableMetaDir = new File(metaConfiguration.getProperty(metaKey));
            if (!portableMetaDir.exists()) {
                portableMetaDir.mkdirs();
            }
            if (OSUtils.isWindows()) {
                FileUtils.setWriteable(portableMetaDir);
            }
        }
        return portableMetaDir;
    }

    public static boolean isPortable() {
        return false;
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

