/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.logging.Hex;
import org.jaudiotagger.tag.EmptyFrameException;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.InvalidFrameException;
import org.jaudiotagger.tag.InvalidFrameIdentifierException;
import org.jaudiotagger.tag.id3.AbstractID3v2Frame;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.AbstractTagItem;
import org.jaudiotagger.tag.id3.ID3Compression;
import org.jaudiotagger.tag.id3.ID3Tags;
import org.jaudiotagger.tag.id3.ID3TextEncodingConversion;
import org.jaudiotagger.tag.id3.ID3v22Frame;
import org.jaudiotagger.tag.id3.ID3v23Frames;
import org.jaudiotagger.tag.id3.ID3v24Frame;
import org.jaudiotagger.tag.id3.framebody.AbstractID3v2FrameBody;
import org.jaudiotagger.tag.id3.framebody.FrameBodyDeprecated;
import org.jaudiotagger.tag.id3.framebody.FrameBodyUnsupported;
import org.jaudiotagger.tag.id3.framebody.ID3v23FrameBody;
import org.jaudiotagger.tag.id3.valuepair.TextEncoding;
import org.jaudiotagger.utils.EqualsUtil;

public class ID3v23Frame
extends AbstractID3v2Frame {
    private static Pattern validFrameIdentifier = Pattern.compile("[A-Z][0-9A-Z]{3}");
    protected static final int FRAME_ID_SIZE = 4;
    protected static final int FRAME_FLAGS_SIZE = 2;
    protected static final int FRAME_SIZE_SIZE = 4;
    protected static final int FRAME_COMPRESSION_UNCOMPRESSED_SIZE = 4;
    protected static final int FRAME_ENCRYPTION_INDICATOR_SIZE = 1;
    protected static final int FRAME_GROUPING_INDICATOR_SIZE = 1;
    protected static final int FRAME_HEADER_SIZE = 10;
    private int encryptionMethod;
    private int groupIdentifier;

    @Override
    protected int getFrameIdSize() {
        return 4;
    }

    @Override
    protected int getFrameSizeSize() {
        return 4;
    }

    @Override
    protected int getFrameHeaderSize() {
        return 10;
    }

    public ID3v23Frame() {
    }

    public ID3v23Frame(String identifier) {
        super(identifier);
        this.statusFlags = new StatusFlags();
        this.encodingFlags = new EncodingFlags();
    }

    public ID3v23Frame(ID3v23Frame frame) {
        super(frame);
        this.statusFlags = new StatusFlags(frame.getStatusFlags().getOriginalFlags());
        this.encodingFlags = new EncodingFlags(frame.getEncodingFlags().getFlags());
    }

    /*
     * Enabled aggressive block sorting
     */
    public ID3v23Frame(AbstractID3v2Frame frame) throws InvalidFrameException {
        block15: {
            logger.finer("Creating frame from a frame of a different version");
            if (frame instanceof ID3v23Frame) {
                throw new UnsupportedOperationException("Copy Constructor not called. Please type cast the argument");
            }
            if (frame instanceof ID3v24Frame) {
                this.statusFlags = new StatusFlags((ID3v24Frame.StatusFlags)frame.getStatusFlags());
                this.encodingFlags = new EncodingFlags(frame.getEncodingFlags().getFlags());
            }
            if (frame instanceof ID3v24Frame) {
                if (frame.getBody() instanceof FrameBodyUnsupported) {
                    this.frameBody = new FrameBodyUnsupported((FrameBodyUnsupported)frame.getBody());
                    this.frameBody.setHeader(this);
                    this.identifier = frame.getIdentifier();
                    logger.config("UNKNOWN:Orig id is:" + frame.getIdentifier() + ":New id is:" + this.identifier);
                    return;
                }
                if (frame.getBody() instanceof FrameBodyDeprecated) {
                    if (!ID3Tags.isID3v23FrameIdentifier(frame.getIdentifier())) {
                        this.frameBody = new FrameBodyDeprecated((FrameBodyDeprecated)frame.getBody());
                        this.frameBody.setHeader(this);
                        this.frameBody.setTextEncoding(ID3TextEncodingConversion.getTextEncoding(this, this.frameBody.getTextEncoding()));
                        this.identifier = frame.getIdentifier();
                        logger.config("DEPRECATED:Orig id is:" + frame.getIdentifier() + ":New id is:" + this.identifier);
                        return;
                    }
                    this.frameBody = ((FrameBodyDeprecated)frame.getBody()).getOriginalFrameBody();
                    this.frameBody.setHeader(this);
                    this.frameBody.setTextEncoding(ID3TextEncodingConversion.getTextEncoding(this, this.frameBody.getTextEncoding()));
                    this.identifier = frame.getIdentifier();
                    logger.config("DEPRECATED:Orig id is:" + frame.getIdentifier() + ":New id is:" + this.identifier);
                    break block15;
                } else {
                    if (!ID3Tags.isID3v24FrameIdentifier(frame.getIdentifier())) {
                        logger.severe("Orig id is:" + frame.getIdentifier() + "Unable to create Frame Body");
                        throw new InvalidFrameException("Orig id is:" + frame.getIdentifier() + "Unable to create Frame Body");
                    }
                    logger.finer("isID3v24FrameIdentifier");
                    this.identifier = ID3Tags.convertFrameID24To23(frame.getIdentifier());
                    if (this.identifier != null) {
                        logger.finer("V4:Orig id is:" + frame.getIdentifier() + ":New id is:" + this.identifier);
                        this.frameBody = (AbstractTagFrameBody)ID3Tags.copyObject(frame.getBody());
                        this.frameBody.setHeader(this);
                        this.frameBody.setTextEncoding(ID3TextEncodingConversion.getTextEncoding(this, this.frameBody.getTextEncoding()));
                        return;
                    }
                    this.identifier = ID3Tags.forceFrameID24To23(frame.getIdentifier());
                    if (this.identifier != null) {
                        logger.finer("V4:Orig id is:" + frame.getIdentifier() + ":New id is:" + this.identifier);
                        this.frameBody = this.readBody(this.identifier, (AbstractID3v2FrameBody)frame.getBody());
                        this.frameBody.setHeader(this);
                        this.frameBody.setTextEncoding(ID3TextEncodingConversion.getTextEncoding(this, this.frameBody.getTextEncoding()));
                        return;
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ((AbstractID3v2FrameBody)frame.getBody()).write(baos);
                    this.identifier = frame.getIdentifier();
                    this.frameBody = new FrameBodyUnsupported(this.identifier, baos.toByteArray());
                    this.frameBody.setHeader(this);
                    logger.finer("V4:Orig id is:" + frame.getIdentifier() + ":New Id Unsupported is:" + this.identifier);
                    return;
                }
            }
            if (frame instanceof ID3v22Frame) {
                if (!ID3Tags.isID3v22FrameIdentifier(frame.getIdentifier())) {
                    this.frameBody = new FrameBodyUnsupported((FrameBodyUnsupported)frame.getBody());
                    this.frameBody.setHeader(this);
                    this.identifier = frame.getIdentifier();
                    logger.config("UNKNOWN:Orig id is:" + frame.getIdentifier() + ":New id is:" + this.identifier);
                    return;
                }
                this.identifier = ID3Tags.convertFrameID22To23(frame.getIdentifier());
                if (this.identifier != null) {
                    logger.config("V3:Orig id is:" + frame.getIdentifier() + ":New id is:" + this.identifier);
                    this.frameBody = (AbstractTagFrameBody)ID3Tags.copyObject(frame.getBody());
                    this.frameBody.setHeader(this);
                    return;
                }
                if (ID3Tags.isID3v22FrameIdentifier(frame.getIdentifier())) {
                    this.identifier = ID3Tags.forceFrameID22To23(frame.getIdentifier());
                    if (this.identifier != null) {
                        logger.config("V22Orig id is:" + frame.getIdentifier() + "New id is:" + this.identifier);
                        this.frameBody = this.readBody(this.identifier, (AbstractID3v2FrameBody)frame.getBody());
                        this.frameBody.setHeader(this);
                        return;
                    }
                    this.frameBody = new FrameBodyDeprecated((AbstractID3v2FrameBody)frame.getBody());
                    this.frameBody.setHeader(this);
                    this.identifier = frame.getIdentifier();
                    logger.config("Deprecated:V22:orig id id is:" + frame.getIdentifier() + ":New id is:" + this.identifier);
                    return;
                }
            }
        }
        logger.warning("Frame is unknown version:" + frame.getClass());
    }

    public ID3v23Frame(ByteBuffer byteBuffer, String loggingFilename) throws InvalidFrameException, InvalidDataTypeException {
        this.setLoggingFilename(loggingFilename);
        this.read(byteBuffer);
    }

    public ID3v23Frame(ByteBuffer byteBuffer) throws InvalidFrameException, InvalidDataTypeException {
        this(byteBuffer, "");
    }

    @Override
    public int getSize() {
        return this.frameBody.getSize() + 10;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ID3v23Frame)) {
            return false;
        }
        ID3v23Frame that = (ID3v23Frame)obj;
        return EqualsUtil.areEqual(this.statusFlags, that.statusFlags) && EqualsUtil.areEqual(this.encodingFlags, that.encodingFlags) && super.equals(that);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(ByteBuffer byteBuffer) throws InvalidFrameException, InvalidDataTypeException {
        String identifier = this.readIdentifier(byteBuffer);
        if (!this.isValidID3v2FrameIdentifier(identifier)) {
            logger.config(this.getLoggingFilename() + ":Invalid identifier:" + identifier);
            byteBuffer.position(byteBuffer.position() - (this.getFrameIdSize() - 1));
            throw new InvalidFrameIdentifierException(this.getLoggingFilename() + ":" + identifier + ":is not a valid ID3v2.30 frame");
        }
        this.frameSize = byteBuffer.getInt();
        if (this.frameSize < 0) {
            logger.warning(this.getLoggingFilename() + ":Invalid Frame Size:" + this.frameSize + ":" + identifier);
            throw new InvalidFrameException(identifier + " is invalid frame:" + this.frameSize);
        }
        if (this.frameSize == 0) {
            logger.warning(this.getLoggingFilename() + ":Empty Frame Size:" + identifier);
            byteBuffer.get();
            byteBuffer.get();
            throw new EmptyFrameException(identifier + " is empty frame");
        }
        if (this.frameSize > byteBuffer.remaining()) {
            logger.warning(this.getLoggingFilename() + ":Invalid Frame size of " + this.frameSize + " larger than size of" + byteBuffer.remaining() + " before mp3 audio:" + identifier);
            throw new InvalidFrameException(identifier + " is invalid frame:" + this.frameSize + " larger than size of" + byteBuffer.remaining() + " before mp3 audio:" + identifier);
        }
        this.statusFlags = new StatusFlags(byteBuffer.get());
        this.encodingFlags = new EncodingFlags(byteBuffer.get());
        String id = ID3Tags.convertFrameID23To24(identifier);
        if (id == null) {
            id = ID3Tags.isID3v23FrameIdentifier(identifier) ? identifier : "Unsupported";
        }
        logger.fine(this.getLoggingFilename() + ":Identifier was:" + identifier + " reading using:" + id + "with frame size:" + this.frameSize);
        int extraHeaderBytesCount = 0;
        int decompressedFrameSize = -1;
        if (((EncodingFlags)this.encodingFlags).isCompression()) {
            decompressedFrameSize = byteBuffer.getInt();
            extraHeaderBytesCount = 4;
            logger.fine(this.getLoggingFilename() + ":Decompressed frame size is:" + decompressedFrameSize);
        }
        if (((EncodingFlags)this.encodingFlags).isEncryption()) {
            ++extraHeaderBytesCount;
            this.encryptionMethod = byteBuffer.get();
        }
        if (((EncodingFlags)this.encodingFlags).isGrouping()) {
            ++extraHeaderBytesCount;
            this.groupIdentifier = byteBuffer.get();
        }
        if (((EncodingFlags)this.encodingFlags).isNonStandardFlags()) {
            logger.severe(this.getLoggingFilename() + ":InvalidEncodingFlags:" + Hex.asHex(((EncodingFlags)this.encodingFlags).getFlags()));
        }
        if (((EncodingFlags)this.encodingFlags).isCompression() && decompressedFrameSize > 100 * this.frameSize) {
            throw new InvalidFrameException(identifier + " is invalid frame, frame size " + this.frameSize + " cannot be:" + decompressedFrameSize + " when uncompressed");
        }
        int realFrameSize = this.frameSize - extraHeaderBytesCount;
        if (realFrameSize <= 0) {
            throw new InvalidFrameException(identifier + " is invalid frame, realframeSize is:" + realFrameSize);
        }
        try {
            if (((EncodingFlags)this.encodingFlags).isCompression()) {
                ByteBuffer frameBodyBuffer = ID3Compression.uncompress(identifier, this.getLoggingFilename(), byteBuffer, decompressedFrameSize, realFrameSize);
                this.frameBody = ((EncodingFlags)this.encodingFlags).isEncryption() ? this.readEncryptedBody(id, frameBodyBuffer, decompressedFrameSize) : this.readBody(id, frameBodyBuffer, decompressedFrameSize);
            } else if (((EncodingFlags)this.encodingFlags).isEncryption()) {
                this.frameBody = this.readEncryptedBody(identifier, byteBuffer, this.frameSize);
            } else {
                ByteBuffer frameBodyBuffer = byteBuffer.slice();
                frameBodyBuffer.limit(realFrameSize);
                this.frameBody = this.readBody(id, frameBodyBuffer, realFrameSize);
            }
            if (!(this.frameBody instanceof ID3v23FrameBody)) {
                logger.config(this.getLoggingFilename() + ":Converted frameBody with:" + identifier + " to deprecated frameBody");
                this.frameBody = new FrameBodyDeprecated((AbstractID3v2FrameBody)this.frameBody);
            }
        }
        finally {
            byteBuffer.position(byteBuffer.position() + realFrameSize);
        }
    }

    @Override
    public void write(ByteArrayOutputStream tagBuffer) {
        logger.config("Writing frame to buffer:" + this.getIdentifier());
        ByteBuffer headerBuffer = ByteBuffer.allocate(10);
        ByteArrayOutputStream bodyOutputStream = new ByteArrayOutputStream();
        ((AbstractID3v2FrameBody)this.frameBody).write(bodyOutputStream);
        if (this.getIdentifier().length() == 3) {
            this.identifier = this.identifier + ' ';
        }
        headerBuffer.put(this.getIdentifier().getBytes(StandardCharsets.ISO_8859_1), 0, 4);
        int size = this.frameBody.getSize();
        logger.fine("Frame Size Is:" + size);
        headerBuffer.putInt(this.frameBody.getSize());
        headerBuffer.put(this.statusFlags.getWriteFlags());
        ((EncodingFlags)this.encodingFlags).unsetNonStandardFlags();
        ((EncodingFlags)this.encodingFlags).unsetCompression();
        headerBuffer.put(this.encodingFlags.getFlags());
        try {
            tagBuffer.write(headerBuffer.array());
            if (((EncodingFlags)this.encodingFlags).isEncryption()) {
                tagBuffer.write(this.encryptionMethod);
            }
            if (((EncodingFlags)this.encodingFlags).isGrouping()) {
                tagBuffer.write(this.groupIdentifier);
            }
            tagBuffer.write(bodyOutputStream.toByteArray());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public AbstractID3v2Frame.StatusFlags getStatusFlags() {
        return this.statusFlags;
    }

    @Override
    public AbstractID3v2Frame.EncodingFlags getEncodingFlags() {
        return this.encodingFlags;
    }

    public int getEncryptionMethod() {
        return this.encryptionMethod;
    }

    public int getGroupIdentifier() {
        return this.groupIdentifier;
    }

    public boolean isValidID3v2FrameIdentifier(String identifier) {
        Matcher m = validFrameIdentifier.matcher(identifier);
        return m.matches();
    }

    @Override
    public void createStructure() {
        MP3File.getStructureFormatter().openHeadingElement("frame", this.getIdentifier());
        MP3File.getStructureFormatter().addElement("frameSize", this.frameSize);
        this.statusFlags.createStructure();
        this.encodingFlags.createStructure();
        this.frameBody.createStructure();
        MP3File.getStructureFormatter().closeHeadingElement("frame");
    }

    @Override
    public boolean isCommon() {
        return ID3v23Frames.getInstanceOf().isCommon(this.getId());
    }

    @Override
    public boolean isBinary() {
        return ID3v23Frames.getInstanceOf().isBinary(this.getId());
    }

    @Override
    public void setEncoding(Charset encoding) {
        Integer encodingId = TextEncoding.getInstanceOf().getIdForCharset(encoding);
        if (encodingId != null && encodingId < 2) {
            this.getBody().setTextEncoding(encodingId.byteValue());
        }
    }

    class EncodingFlags
    extends AbstractID3v2Frame.EncodingFlags {
        public static final String TYPE_COMPRESSION = "compression";
        public static final String TYPE_ENCRYPTION = "encryption";
        public static final String TYPE_GROUPIDENTITY = "groupidentity";
        public static final int MASK_COMPRESSION = 128;
        public static final int MASK_ENCRYPTION = 64;
        public static final int MASK_GROUPING_IDENTITY = 32;

        public EncodingFlags() {
        }

        public EncodingFlags(byte flags) {
            super(flags);
            this.logEnabledFlags();
        }

        public void setCompression() {
            this.flags = (byte)(this.flags | 0x80);
        }

        public void setEncryption() {
            this.flags = (byte)(this.flags | 0x40);
        }

        public void setGrouping() {
            this.flags = (byte)(this.flags | 0x20);
        }

        public void unsetCompression() {
            this.flags = (byte)(this.flags & 0x7F);
        }

        public void unsetEncryption() {
            this.flags = (byte)(this.flags & 0xFFFFFFBF);
        }

        public void unsetGrouping() {
            this.flags = (byte)(this.flags & 0xFFFFFFDF);
        }

        public boolean isNonStandardFlags() {
            return (this.flags & 0x10) > 0 || (this.flags & 8) > 0 || (this.flags & 4) > 0 || (this.flags & 2) > 0 || (this.flags & 1) > 0;
        }

        public void unsetNonStandardFlags() {
            if (this.isNonStandardFlags()) {
                AbstractTagItem.logger.warning(ID3v23Frame.this.getLoggingFilename() + ":" + ID3v23Frame.this.getIdentifier() + ":Unsetting Unknown Encoding Flags:" + Hex.asHex(this.flags));
                this.flags = (byte)(this.flags & 0xFFFFFFEF);
                this.flags = (byte)(this.flags & 0xFFFFFFF7);
                this.flags = (byte)(this.flags & 0xFFFFFFFB);
                this.flags = (byte)(this.flags & 0xFFFFFFFD);
                this.flags = (byte)(this.flags & 0xFFFFFFFE);
            }
        }

        public void logEnabledFlags() {
            if (this.isNonStandardFlags()) {
                AbstractTagItem.logger.warning(ID3v23Frame.this.getLoggingFilename() + ":" + ID3v23Frame.this.identifier + ":Unknown Encoding Flags:" + Hex.asHex(this.flags));
            }
            if (this.isCompression()) {
                AbstractTagItem.logger.warning(ID3v23Frame.this.getLoggingFilename() + ":" + ID3v23Frame.this.identifier + " is compressed");
            }
            if (this.isEncryption()) {
                AbstractTagItem.logger.warning(ID3v23Frame.this.getLoggingFilename() + ":" + ID3v23Frame.this.identifier + " is encrypted");
            }
            if (this.isGrouping()) {
                AbstractTagItem.logger.warning(ID3v23Frame.this.getLoggingFilename() + ":" + ID3v23Frame.this.identifier + " is grouped");
            }
        }

        public boolean isCompression() {
            return (this.flags & 0x80) > 0;
        }

        public boolean isEncryption() {
            return (this.flags & 0x40) > 0;
        }

        public boolean isGrouping() {
            return (this.flags & 0x20) > 0;
        }

        @Override
        public void createStructure() {
            MP3File.getStructureFormatter().openHeadingElement("encodingFlags", "");
            MP3File.getStructureFormatter().addElement(TYPE_COMPRESSION, this.flags & 0x80);
            MP3File.getStructureFormatter().addElement(TYPE_ENCRYPTION, this.flags & 0x40);
            MP3File.getStructureFormatter().addElement(TYPE_GROUPIDENTITY, this.flags & 0x20);
            MP3File.getStructureFormatter().closeHeadingElement("encodingFlags");
        }
    }

    class StatusFlags
    extends AbstractID3v2Frame.StatusFlags {
        public static final String TYPE_TAGALTERPRESERVATION = "typeTagAlterPreservation";
        public static final String TYPE_FILEALTERPRESERVATION = "typeFileAlterPreservation";
        public static final String TYPE_READONLY = "typeReadOnly";
        public static final int MASK_TAG_ALTER_PRESERVATION = 128;
        public static final int MASK_FILE_ALTER_PRESERVATION = 64;
        public static final int MASK_READ_ONLY = 32;

        public StatusFlags() {
            this.originalFlags = 0;
            this.writeFlags = 0;
        }

        StatusFlags(byte flags) {
            this.originalFlags = flags;
            this.writeFlags = flags;
            this.modifyFlags();
        }

        StatusFlags(ID3v24Frame.StatusFlags statusFlags) {
            this.writeFlags = this.originalFlags = this.convertV4ToV3Flags(statusFlags.getOriginalFlags());
            this.modifyFlags();
        }

        private byte convertV4ToV3Flags(byte v4Flag) {
            byte v3Flag = 0;
            if ((v4Flag & 0x20) != 0) {
                v3Flag = (byte)(v3Flag | 0x40);
            }
            if ((v4Flag & 0x40) != 0) {
                v3Flag = (byte)(v3Flag | 0xFFFFFF80);
            }
            return v3Flag;
        }

        protected void modifyFlags() {
            String str = ID3v23Frame.this.getIdentifier();
            if (ID3v23Frames.getInstanceOf().isDiscardIfFileAltered(str)) {
                this.writeFlags = (byte)(this.writeFlags | 0x40);
                this.writeFlags = (byte)(this.writeFlags & 0x7F);
            } else {
                this.writeFlags = (byte)(this.writeFlags & 0xFFFFFFBF);
                this.writeFlags = (byte)(this.writeFlags & 0x7F);
            }
        }

        @Override
        public void createStructure() {
            MP3File.getStructureFormatter().openHeadingElement("statusFlags", "");
            MP3File.getStructureFormatter().addElement(TYPE_TAGALTERPRESERVATION, this.originalFlags & 0x80);
            MP3File.getStructureFormatter().addElement(TYPE_FILEALTERPRESERVATION, this.originalFlags & 0x40);
            MP3File.getStructureFormatter().addElement(TYPE_READONLY, this.originalFlags & 0x20);
            MP3File.getStructureFormatter().closeHeadingElement("statusFlags");
        }
    }
}

