/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.wav;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.generic.GenericAudioHeader;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.iff.Chunk;
import org.jaudiotagger.audio.iff.ChunkHeader;
import org.jaudiotagger.audio.iff.IffHeaderChunk;
import org.jaudiotagger.audio.wav.WavChunkType;
import org.jaudiotagger.audio.wav.WavRIFFHeader;
import org.jaudiotagger.audio.wav.chunk.WavFactChunk;
import org.jaudiotagger.audio.wav.chunk.WavFormatChunk;

public class WavInfoReader {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.wav");

    public GenericAudioHeader read(RandomAccessFile raf) throws CannotReadException, IOException {
        GenericAudioHeader info = new GenericAudioHeader();
        if (WavRIFFHeader.isValidHeader(raf)) {
            while (raf.getFilePointer() < raf.length() && this.readChunk(raf, info)) {
            }
        } else {
            throw new CannotReadException("Wav RIFF Header not valid");
        }
        this.calculateTrackLength(info);
        return info;
    }

    private void calculateTrackLength(GenericAudioHeader info) throws CannotReadException {
        if (info.getNoOfSamples() != null) {
            if (info.getSampleRateAsNumber() > 0) {
                info.setPreciseLength((float)info.getNoOfSamples().longValue() / (float)info.getSampleRateAsNumber());
            }
        } else if (info.getAudioDataLength() > 0L) {
            info.setPreciseLength((float)info.getAudioDataLength().longValue() / (float)info.getByteRate().intValue());
        } else {
            throw new CannotReadException("Wav Data Header Missing");
        }
    }

    protected boolean readChunk(RandomAccessFile raf, GenericAudioHeader info) throws IOException {
        ChunkHeader chunkHeader;
        block9: {
            block8: {
                chunkHeader = new ChunkHeader(ByteOrder.LITTLE_ENDIAN);
                if (!chunkHeader.readHeader(raf)) {
                    return false;
                }
                String id = chunkHeader.getID();
                logger.info("Reading Chunk:" + id + ":starting at:" + chunkHeader.getStartLocationInFile() + ":sizeIncHeader:" + (chunkHeader.getSize() + 8L));
                WavChunkType chunkType = WavChunkType.get(id);
                if (chunkType == null) break block8;
                switch (chunkType) {
                    case FACT: {
                        ByteBuffer fmtChunkData = Utils.readFileDataIntoBufferLE(raf, (int)chunkHeader.getSize());
                        WavFactChunk chunk = new WavFactChunk(fmtChunkData, chunkHeader, info);
                        if (!((Chunk)chunk).readChunk()) {
                            return false;
                        }
                        break block9;
                    }
                    case DATA: {
                        info.setAudioDataLength(chunkHeader.getSize());
                        info.setAudioDataStartPosition(raf.getFilePointer());
                        info.setAudioDataEndPosition(raf.getFilePointer() + chunkHeader.getSize());
                        raf.skipBytes((int)chunkHeader.getSize());
                        break;
                    }
                    case FORMAT: {
                        ByteBuffer fmtChunkData = Utils.readFileDataIntoBufferLE(raf, (int)chunkHeader.getSize());
                        WavFormatChunk chunk = new WavFormatChunk(fmtChunkData, chunkHeader, info);
                        if (!((Chunk)chunk).readChunk()) {
                            return false;
                        }
                        break block9;
                    }
                    default: {
                        logger.config("Skipping chunk bytes:" + chunkHeader.getSize());
                        raf.skipBytes((int)chunkHeader.getSize());
                        break;
                    }
                }
                break block9;
            }
            logger.config("Skipping chunk bytes:" + chunkHeader.getSize());
            raf.skipBytes((int)chunkHeader.getSize());
        }
        IffHeaderChunk.ensureOnEqualBoundary(raf, chunkHeader);
        return true;
    }
}

