/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public final class RandomAccessFileInputstream
extends InputStream {
    private final RandomAccessFile source;

    public RandomAccessFileInputstream(RandomAccessFile file) {
        if (file == null) {
            throw new IllegalArgumentException("null");
        }
        this.source = file;
    }

    @Override
    public int read() throws IOException {
        return this.source.read();
    }

    @Override
    public int read(byte[] buffer, int off, int len) throws IOException {
        return this.source.read(buffer, off, len);
    }

    @Override
    public long skip(long amount) throws IOException {
        long left;
        if (amount < 0L) {
            throw new IllegalArgumentException("invalid negative value");
        }
        for (left = amount; left > Integer.MAX_VALUE; left -= Integer.MAX_VALUE) {
            this.source.skipBytes(Integer.MAX_VALUE);
        }
        return this.source.skipBytes((int)left);
    }
}

