/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.util.ArrayList;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.RangeIndex;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;

public class RangeTable
extends Table {
    public static final String NAME = "SYSTEM_RANGE";
    public static final String ALIAS = "GENERATE_SERIES";
    private Expression min;
    private Expression max;
    private Expression step;
    private boolean optimized;

    public RangeTable(Schema schema, Expression expression, Expression expression2, boolean bl) {
        super(schema, 0, NAME, true, true);
        Column[] columnArray;
        if (bl) {
            columnArray = new Column[]{};
        } else {
            Column[] columnArray2 = new Column[1];
            columnArray = columnArray2;
            columnArray2[0] = new Column("X", 5);
        }
        Column[] columnArray3 = columnArray;
        this.min = expression;
        this.max = expression2;
        this.setColumns(columnArray3);
    }

    public RangeTable(Schema schema, Expression expression, Expression expression2, Expression expression3, boolean bl) {
        this(schema, expression, expression2, bl);
        this.step = expression3;
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public String getSQL() {
        String string = "SYSTEM_RANGE(" + this.min.getSQL() + ", " + this.max.getSQL();
        if (this.step != null) {
            string = string + ", " + this.step.getSQL();
        }
        return string + ")";
    }

    @Override
    public boolean lock(Session session2, boolean bl, boolean bl2) {
        return false;
    }

    @Override
    public void close(Session session2) {
    }

    @Override
    public void unlock(Session session2) {
    }

    @Override
    public boolean isLockedExclusively() {
        return false;
    }

    @Override
    public Index addIndex(Session session2, String string, int n, IndexColumn[] indexColumnArray, IndexType indexType, boolean bl, String string2) {
        throw DbException.getUnsupportedException(NAME);
    }

    @Override
    public void removeRow(Session session2, Row row) {
        throw DbException.getUnsupportedException(NAME);
    }

    @Override
    public void addRow(Session session2, Row row) {
        throw DbException.getUnsupportedException(NAME);
    }

    @Override
    public void checkSupportAlter() {
        throw DbException.getUnsupportedException(NAME);
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException(NAME);
    }

    @Override
    public boolean canGetRowCount() {
        return true;
    }

    @Override
    public boolean canDrop() {
        return false;
    }

    @Override
    public long getRowCount(Session session2) {
        return Math.max(0L, this.getMax(session2) - this.getMin(session2) + 1L);
    }

    @Override
    public String getTableType() {
        throw DbException.throwInternalError();
    }

    @Override
    public Index getScanIndex(Session session2) {
        if (this.getStep(session2) == 0L) {
            throw DbException.get(90142);
        }
        return new RangeIndex(this, IndexColumn.wrap(this.columns));
    }

    public long getMin(Session session2) {
        this.optimize(session2);
        return this.min.getValue(session2).getLong();
    }

    public long getMax(Session session2) {
        this.optimize(session2);
        return this.max.getValue(session2).getLong();
    }

    public long getStep(Session session2) {
        this.optimize(session2);
        if (this.step == null) {
            return 1L;
        }
        return this.step.getValue(session2).getLong();
    }

    private void optimize(Session session2) {
        if (!this.optimized) {
            this.min = this.min.optimize(session2);
            this.max = this.max.optimize(session2);
            if (this.step != null) {
                this.step = this.step.optimize(session2);
            }
            this.optimized = true;
        }
    }

    @Override
    public ArrayList<Index> getIndexes() {
        return null;
    }

    @Override
    public void truncate(Session session2) {
        throw DbException.getUnsupportedException(NAME);
    }

    @Override
    public long getMaxDataModificationId() {
        return 0L;
    }

    @Override
    public Index getUniqueIndex() {
        return null;
    }

    @Override
    public long getRowCountApproximation() {
        return 100L;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public boolean canReference() {
        return false;
    }
}

