/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.h2.command.Parser;
import org.h2.command.Prepared;
import org.h2.command.dml.Query;
import org.h2.command.dml.SelectUnion;
import org.h2.engine.Session;
import org.h2.expression.Parameter;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexLookupBatch;
import org.h2.index.IndexType;
import org.h2.index.SpatialIndex;
import org.h2.index.ViewCursor;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.JoinBatch;
import org.h2.table.TableFilter;
import org.h2.table.TableView;
import org.h2.util.IntArray;
import org.h2.util.New;
import org.h2.value.Value;

public class ViewIndex
extends BaseIndex
implements SpatialIndex {
    private static final long MAX_AGE_NANOS = TimeUnit.MILLISECONDS.toNanos(10000L);
    private final TableView view;
    private final String querySQL;
    private final ArrayList<Parameter> originalParameters;
    private boolean recursive;
    private final int[] indexMasks;
    private Query query;
    private final Session createSession;
    private final long evaluatedAt;

    public ViewIndex(TableView tableView, String string, ArrayList<Parameter> arrayList, boolean bl) {
        this.initBaseIndex(tableView, 0, null, null, IndexType.createNonUnique(false));
        this.view = tableView;
        this.querySQL = string;
        this.originalParameters = arrayList;
        this.recursive = bl;
        this.columns = new Column[0];
        this.createSession = null;
        this.indexMasks = null;
        this.evaluatedAt = Long.MIN_VALUE;
    }

    public ViewIndex(TableView tableView, ViewIndex viewIndex, Session session2, int[] nArray, TableFilter[] tableFilterArray, int n, SortOrder sortOrder) {
        this.initBaseIndex(tableView, 0, null, null, IndexType.createNonUnique(false));
        this.view = tableView;
        this.querySQL = viewIndex.querySQL;
        this.originalParameters = viewIndex.originalParameters;
        this.recursive = viewIndex.recursive;
        this.indexMasks = nArray;
        this.createSession = session2;
        this.columns = new Column[0];
        if (!this.recursive) {
            this.query = this.getQuery(session2, nArray, tableFilterArray, n, sortOrder);
        }
        this.evaluatedAt = this.recursive || tableView.getTopQuery() != null ? Long.MAX_VALUE : System.nanoTime();
    }

    @Override
    public IndexLookupBatch createLookupBatch(TableFilter[] tableFilterArray, int n) {
        if (this.recursive) {
            return null;
        }
        return JoinBatch.createViewIndexLookupBatch(this);
    }

    public Session getSession() {
        return this.createSession;
    }

    public boolean isExpired() {
        assert (this.evaluatedAt != Long.MIN_VALUE) : "must not be called for main index of TableView";
        return !this.recursive && this.view.getTopQuery() == null && System.nanoTime() - this.evaluatedAt > MAX_AGE_NANOS;
    }

    @Override
    public String getPlanSQL() {
        return this.query == null ? null : this.query.getPlanSQL();
    }

    @Override
    public void close(Session session2) {
    }

    @Override
    public void add(Session session2, Row row) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void remove(Session session2, Row row) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public double getCost(Session session2, int[] nArray, TableFilter[] tableFilterArray, int n, SortOrder sortOrder, HashSet<Column> hashSet) {
        return this.recursive ? 1000.0 : this.query.getCost();
    }

    @Override
    public Cursor find(Session session2, SearchRow searchRow, SearchRow searchRow2) {
        return this.find(session2, searchRow, searchRow2, null);
    }

    @Override
    public Cursor findByGeometry(TableFilter tableFilter, SearchRow searchRow, SearchRow searchRow2, SearchRow searchRow3) {
        return this.find(tableFilter.getSession(), searchRow, searchRow2, searchRow3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Query prepareSubQuery(String string, Session session2, int[] nArray, TableFilter[] tableFilterArray, int n, SortOrder sortOrder) {
        Prepared prepared;
        assert (tableFilterArray != null);
        session2.pushSubQueryInfo(nArray, tableFilterArray, n, sortOrder);
        try {
            prepared = session2.prepare(string, true);
        }
        finally {
            session2.popSubQueryInfo();
        }
        return (Query)prepared;
    }

    private Cursor findRecursive(SearchRow searchRow, SearchRow searchRow2) {
        Object object;
        assert (this.recursive);
        LocalResult localResult = this.view.getRecursiveResult();
        if (localResult != null) {
            localResult.reset();
            return new ViewCursor(this, localResult, searchRow, searchRow2);
        }
        if (this.query == null) {
            object = new Parser(this.createSession);
            ((Parser)object).setRightsChecked(true);
            ((Parser)object).setSuppliedParameterList(this.originalParameters);
            this.query = (Query)((Parser)object).prepare(this.querySQL);
        }
        if (!this.query.isUnion()) {
            throw DbException.get(42001, "recursive queries without UNION ALL");
        }
        object = (SelectUnion)this.query;
        if (((SelectUnion)object).getUnionType() != 1) {
            throw DbException.get(42001, "recursive queries without UNION ALL");
        }
        Query query = ((SelectUnion)object).getLeft();
        query.disableCache();
        LocalResult localResult2 = query.query(0);
        LocalResult localResult3 = ((SelectUnion)object).getEmptyResult();
        localResult3.setMaxMemoryRows(Integer.MAX_VALUE);
        while (localResult2.next()) {
            localResult3.addRow(localResult2.currentRow());
        }
        Query query2 = ((SelectUnion)object).getRight();
        localResult2.reset();
        this.view.setRecursiveResult(localResult2);
        query2.disableCache();
        while ((localResult2 = query2.query(0)).getRowCount() != 0) {
            while (localResult2.next()) {
                localResult3.addRow(localResult2.currentRow());
            }
            localResult2.reset();
            this.view.setRecursiveResult(localResult2);
        }
        this.view.setRecursiveResult(null);
        localResult3.done();
        return new ViewCursor(this, localResult3, searchRow, searchRow2);
    }

    public void setupQueryParameters(Session session2, SearchRow searchRow, SearchRow searchRow2, SearchRow searchRow3) {
        int n;
        int n2;
        int n3;
        ArrayList<Parameter> arrayList = this.query.getParameters();
        if (this.originalParameters != null) {
            n3 = this.originalParameters.size();
            for (n2 = 0; n2 < n3; ++n2) {
                Parameter parameter = this.originalParameters.get(n2);
                n = parameter.getIndex();
                Value value = parameter.getValue(session2);
                ViewIndex.setParameter(arrayList, n, value);
            }
        }
        n2 = searchRow != null ? searchRow.getColumnCount() : (searchRow2 != null ? searchRow2.getColumnCount() : (searchRow3 != null ? searchRow3.getColumnCount() : 0));
        n3 = this.view.getParameterOffset(this.originalParameters);
        for (int i = 0; i < n2; ++i) {
            n = this.indexMasks[i];
            if ((n & 1) != 0) {
                ViewIndex.setParameter(arrayList, n3++, searchRow.getValue(i));
            }
            if ((n & 2) != 0) {
                ViewIndex.setParameter(arrayList, n3++, searchRow.getValue(i));
            }
            if ((n & 4) != 0) {
                ViewIndex.setParameter(arrayList, n3++, searchRow2.getValue(i));
            }
            if ((n & 0x10) == 0) continue;
            ViewIndex.setParameter(arrayList, n3++, searchRow3.getValue(i));
        }
    }

    private Cursor find(Session session2, SearchRow searchRow, SearchRow searchRow2, SearchRow searchRow3) {
        if (this.recursive) {
            return this.findRecursive(searchRow, searchRow2);
        }
        this.setupQueryParameters(session2, searchRow, searchRow2, searchRow3);
        LocalResult localResult = this.query.query(0);
        return new ViewCursor(this, localResult, searchRow, searchRow2);
    }

    private static void setParameter(ArrayList<Parameter> arrayList, int n, Value value) {
        if (n >= arrayList.size()) {
            return;
        }
        Parameter parameter = arrayList.get(n);
        parameter.setValue(value);
    }

    public Query getQuery() {
        return this.query;
    }

    private Query getQuery(Session session2, int[] nArray, TableFilter[] tableFilterArray, int n, SortOrder sortOrder) {
        int n2;
        int n3;
        int n4;
        int n5;
        Query query = ViewIndex.prepareSubQuery(this.querySQL, session2, nArray, tableFilterArray, n, sortOrder);
        if (nArray == null) {
            return query;
        }
        if (!query.allowGlobalConditions()) {
            return query;
        }
        int n6 = this.view.getParameterOffset(this.originalParameters);
        IntArray intArray = new IntArray();
        int n7 = 0;
        for (n5 = 0; n5 < nArray.length; ++n5) {
            int n8 = nArray[n5];
            if (n8 == 0) continue;
            ++n7;
            n4 = Integer.bitCount(n8);
            for (n3 = 0; n3 < n4; ++n3) {
                intArray.add(n5);
            }
        }
        n5 = intArray.size();
        ArrayList<Column> arrayList = New.arrayList();
        n4 = 0;
        while (n4 < n5) {
            Parameter parameter;
            n3 = intArray.get(n4);
            arrayList.add(this.table.getColumn(n3));
            n2 = nArray[n3];
            if ((n2 & 1) != 0) {
                parameter = new Parameter(n6 + n4);
                query.addGlobalCondition(parameter, n3, 16);
                ++n4;
            }
            if ((n2 & 2) != 0) {
                parameter = new Parameter(n6 + n4);
                query.addGlobalCondition(parameter, n3, 1);
                ++n4;
            }
            if ((n2 & 4) != 0) {
                parameter = new Parameter(n6 + n4);
                query.addGlobalCondition(parameter, n3, 3);
                ++n4;
            }
            if ((n2 & 0x10) == 0) continue;
            parameter = new Parameter(n6 + n4);
            query.addGlobalCondition(parameter, n3, 11);
            ++n4;
        }
        this.columns = new Column[arrayList.size()];
        arrayList.toArray(this.columns);
        this.indexColumns = new IndexColumn[n7];
        this.columnIds = new int[n7];
        n3 = 0;
        for (n4 = 0; n4 < 2; ++n4) {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                int n9 = nArray[n2];
                if (n9 == 0 || (n4 == 0 ? (n9 & 1) == 0 : (n9 & 1) != 0)) continue;
                IndexColumn indexColumn = new IndexColumn();
                indexColumn.column = this.table.getColumn(n2);
                this.indexColumns[n3] = indexColumn;
                this.columnIds[n3] = indexColumn.column.getColumnId();
                ++n3;
            }
        }
        String string = query.getPlanSQL();
        query = ViewIndex.prepareSubQuery(string, session2, nArray, tableFilterArray, n, sortOrder);
        return query;
    }

    @Override
    public void remove(Session session2) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void truncate(Session session2) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return false;
    }

    @Override
    public Cursor findFirstOrLast(Session session2, boolean bl) {
        throw DbException.getUnsupportedException("VIEW");
    }

    public void setRecursive(boolean bl) {
        this.recursive = bl;
    }

    @Override
    public long getRowCount(Session session2) {
        return 0L;
    }

    @Override
    public long getRowCountApproximation() {
        return 0L;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    public boolean isRecursive() {
        return this.recursive;
    }
}

