/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.util.HashSet;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.RangeCursor;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.RangeTable;
import org.h2.table.TableFilter;

public class RangeIndex
extends BaseIndex {
    private final RangeTable rangeTable;

    public RangeIndex(RangeTable rangeTable, IndexColumn[] indexColumnArray) {
        this.initBaseIndex(rangeTable, 0, "RANGE_INDEX", indexColumnArray, IndexType.createNonUnique(true));
        this.rangeTable = rangeTable;
    }

    @Override
    public void close(Session session2) {
    }

    @Override
    public void add(Session session2, Row row) {
        throw DbException.getUnsupportedException("SYSTEM_RANGE");
    }

    @Override
    public void remove(Session session2, Row row) {
        throw DbException.getUnsupportedException("SYSTEM_RANGE");
    }

    @Override
    public Cursor find(Session session2, SearchRow searchRow, SearchRow searchRow2) {
        long l;
        long l2;
        long l3 = l2 = this.rangeTable.getMin(session2);
        long l4 = l = this.rangeTable.getMax(session2);
        long l5 = this.rangeTable.getStep(session2);
        try {
            l3 = Math.max(l2, searchRow == null ? l2 : searchRow.getValue(0).getLong());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            l4 = Math.min(l, searchRow2 == null ? l : searchRow2.getValue(0).getLong());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new RangeCursor(session2, l3, l4, l5);
    }

    @Override
    public double getCost(Session session2, int[] nArray, TableFilter[] tableFilterArray, int n, SortOrder sortOrder, HashSet<Column> hashSet) {
        return 1.0;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public void remove(Session session2) {
        throw DbException.getUnsupportedException("SYSTEM_RANGE");
    }

    @Override
    public void truncate(Session session2) {
        throw DbException.getUnsupportedException("SYSTEM_RANGE");
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("SYSTEM_RANGE");
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findFirstOrLast(Session session2, boolean bl) {
        long l = bl ? this.rangeTable.getMin(session2) : this.rangeTable.getMax(session2);
        return new RangeCursor(session2, l, l);
    }

    @Override
    public long getRowCount(Session session2) {
        return this.rangeTable.getRowCountApproximation();
    }

    @Override
    public long getRowCountApproximation() {
        return this.rangeTable.getRowCountApproximation();
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }
}

