/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import org.h2.engine.Session;
import org.h2.engine.SysProperties;
import org.h2.index.Cursor;
import org.h2.index.MultiVersionIndex;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.util.MathUtils;

public class MultiVersionCursor
implements Cursor {
    private final MultiVersionIndex index;
    private final Session session;
    private final Cursor baseCursor;
    private final Cursor deltaCursor;
    private final Object sync;
    private SearchRow baseRow;
    private Row deltaRow;
    private boolean onBase;
    private boolean end;
    private boolean needNewDelta;
    private boolean needNewBase;
    private boolean reverse;

    MultiVersionCursor(Session session2, MultiVersionIndex multiVersionIndex, Cursor cursor, Cursor cursor2, Object object) {
        this.session = session2;
        this.index = multiVersionIndex;
        this.baseCursor = cursor;
        this.deltaCursor = cursor2;
        this.sync = object;
        this.needNewDelta = true;
        this.needNewBase = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadCurrent() {
        Object object = this.sync;
        synchronized (object) {
            this.baseRow = this.baseCursor.getSearchRow();
            this.deltaRow = this.deltaCursor.get();
            this.needNewDelta = false;
            this.needNewBase = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadNext(boolean bl) {
        Object object = this.sync;
        synchronized (object) {
            if (bl) {
                this.baseRow = this.step(this.baseCursor) ? this.baseCursor.getSearchRow() : null;
            } else {
                this.deltaRow = this.step(this.deltaCursor) ? this.deltaCursor.get() : null;
            }
        }
    }

    private boolean step(Cursor cursor) {
        return this.reverse ? cursor.previous() : cursor.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Row get() {
        Object object = this.sync;
        synchronized (object) {
            if (this.end) {
                return null;
            }
            return this.onBase ? this.baseCursor.get() : this.deltaCursor.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchRow getSearchRow() {
        Object object = this.sync;
        synchronized (object) {
            if (this.end) {
                return null;
            }
            return this.onBase ? this.baseCursor.getSearchRow() : this.deltaCursor.getSearchRow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next() {
        Object object = this.sync;
        synchronized (object) {
            int n;
            if (SysProperties.CHECK && this.end) {
                DbException.throwInternalError();
            }
            while (true) {
                if (this.needNewDelta) {
                    this.loadNext(false);
                    this.needNewDelta = false;
                }
                if (this.needNewBase) {
                    this.loadNext(true);
                    this.needNewBase = false;
                }
                if (this.deltaRow == null) {
                    if (this.baseRow == null) {
                        this.end = true;
                        return false;
                    }
                    this.onBase = true;
                    this.needNewBase = true;
                    return true;
                }
                int n2 = this.deltaRow.getSessionId();
                boolean bl = n2 == this.session.getId();
                boolean bl2 = this.deltaRow.isDeleted();
                if (bl && bl2) {
                    this.needNewDelta = true;
                    continue;
                }
                if (this.baseRow == null) {
                    if (bl2) {
                        if (bl) {
                            this.end = true;
                            return false;
                        }
                        this.onBase = false;
                        this.needNewDelta = true;
                        return true;
                    }
                    DbException.throwInternalError();
                }
                if ((n = this.index.compareRows(this.deltaRow, this.baseRow)) == 0) {
                    long l = this.deltaRow.getKey();
                    long l2 = this.baseRow.getKey();
                    n = MathUtils.compareLong(l, l2);
                }
                if (n != 0) break;
                if (bl2) {
                    if (!bl) break;
                    DbException.throwInternalError();
                    break;
                }
                if (bl) {
                    this.onBase = false;
                    this.needNewBase = true;
                    this.needNewDelta = true;
                    return true;
                }
                this.needNewBase = true;
                this.needNewDelta = true;
            }
            if (n > 0) {
                this.onBase = true;
                this.needNewBase = true;
                return true;
            }
            this.onBase = false;
            this.needNewDelta = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean previous() {
        this.reverse = true;
        try {
            boolean bl = this.next();
            return bl;
        }
        finally {
            this.reverse = false;
        }
    }
}

