/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileLoggingAdapter;
import org.gudy.azureus2.core3.util.ILogEventListener;
import org.gudy.azureus2.core3.util.LogEvent;
import org.gudy.azureus2.core3.util.LogIDs;
import org.gudy.azureus2.core3.util.LogRelation;
import org.gudy.azureus2.core3.util.Logger;

public class FileLogging
implements ILogEventListener {
    public static final String LOG_FILE_NAME = "az.log";
    public static final String BAK_FILE_NAME = "az.log.bak";
    public static LogIDs[] configurableLOGIDs = new LogIDs[]{LogIDs.STDOUT, LogIDs.ALERT, LogIDs.CORE, LogIDs.DISK, LogIDs.GUI, LogIDs.NET, LogIDs.NWMAN, LogIDs.PEER, LogIDs.PLUGIN, LogIDs.TRACKER, LogIDs.CACHE, LogIDs.PIECES};
    private static final String CFG_ENABLELOGTOFILE = "Logging Enable";
    private boolean bLogToFile = false;
    private boolean bLogToFileErrorPrinted = false;
    private String sLogDir = "";
    private int iLogFileMaxMB = 1;
    private ArrayList[] ignoredComponents = new ArrayList[3];
    private ArrayList listeners = new ArrayList();
    private SimpleDateFormat format;
    private PrintWriter logFilePrinter;
    private static final int DEFPADDING = 100;
    private int lastWidth = 100;

    public void initialize() {
        boolean overrideLog = System.getProperty("azureus.overridelog") != null;
        for (int i = 0; i < this.ignoredComponents.length; ++i) {
            this.ignoredComponents[i] = new ArrayList();
        }
        if (!overrideLog) {
            // empty if block
        }
        this.checkLoggingConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void reloadLogToFileParam() {
        boolean bNewLogToFile;
        boolean bl = System.getProperty("azureus.overridelog") != null ? true : (bNewLogToFile = false);
        if (bNewLogToFile == this.bLogToFile) return;
        this.bLogToFile = bNewLogToFile;
        if (this.bLogToFile) {
            Logger.addListener(this);
            return;
        }
        Logger.removeListener(this);
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            this.checkAndSwapLog();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void checkLoggingConfig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logToFile(String str) {
        if (!this.bLogToFile) {
            return;
        }
        String dateStr = this.format.format(new Date());
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            if (this.logFilePrinter != null) {
                this.logFilePrinter.print(dateStr);
                this.logFilePrinter.print(str);
                this.logFilePrinter.flush();
            }
            this.checkAndSwapLog();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void checkAndSwapLog() {
        block9: {
            if (!this.bLogToFile) {
                if (this.logFilePrinter != null) {
                    this.logFilePrinter.close();
                    this.logFilePrinter = null;
                }
                return;
            }
            long lMaxBytes = (long)this.iLogFileMaxMB * 1024L * 1024L / 2L;
            File logFile = new File(this.sLogDir + File.separator + LOG_FILE_NAME);
            if (logFile.length() > lMaxBytes && this.logFilePrinter != null) {
                File back_name = new File(this.sLogDir + File.separator + BAK_FILE_NAME);
                this.logFilePrinter.close();
                this.logFilePrinter = null;
                if (!back_name.exists() || back_name.delete()) {
                    if (!logFile.renameTo(back_name)) {
                        logFile.delete();
                    }
                } else {
                    logFile.delete();
                }
            }
            if (this.logFilePrinter == null) {
                try {
                    this.logFilePrinter = new PrintWriter(new FileWriter(logFile, true));
                }
                catch (IOException e) {
                    if (this.bLogToFileErrorPrinted) break block9;
                    this.bLogToFileErrorPrinted = true;
                    Debug.out("Unable to write to log file: " + logFile);
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    private int logTypeToIndex(int entryType) {
        switch (entryType) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        return 0;
    }

    private int indexToLogType(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
        }
        return 0;
    }

    @Override
    public void log(LogEvent event) {
        if (this.ignoredComponents[this.logTypeToIndex(event.entryType)].contains(event.logID)) {
            return;
        }
        StringBuffer text = new StringBuffer(event.text.length());
        text.append(event.entryType).append(" ");
        this.padAndAppend(text, event.logID.toString(), 8, 1);
        if (event.relatedTo != null) {
            this.lastWidth = this.padAndAppend(text, event.text, this.lastWidth, 1);
            if (this.lastWidth > 200) {
                this.lastWidth = 200;
            }
            for (int i = 0; i < event.relatedTo.length; ++i) {
                Object obj = event.relatedTo[i];
                if (obj == null) continue;
                if (i > 0) {
                    text.append("; ");
                }
                if (obj instanceof LogRelation) {
                    text.append(((LogRelation)obj).getRelationText());
                    continue;
                }
                text.append("RelatedTo[").append(obj.toString()).append("]");
            }
        } else {
            text.append(event.text);
            this.lastWidth = 100;
        }
        if (!event.text.endsWith("\n")) {
            text.append("\r\n");
        }
        boolean okToLog = true;
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext() && okToLog) {
            FileLoggingAdapter listener = (FileLoggingAdapter)iter.next();
            okToLog = listener.logToFile(event, text);
        }
        this.logToFile(text.toString());
    }

    private int padAndAppend(StringBuffer appendTo, String s, int width, int growBy) {
        int len;
        if (s == null) {
            s = "null";
        }
        appendTo.append(s);
        int sLen = s.length();
        for (len = width - sLen; len <= 0; len += growBy) {
        }
        char[] padding = new char[len];
        if (len > 5) {
            int i;
            for (i = 0; i < len; i += 2) {
                padding[i] = 32;
            }
            for (i = 1; i < len; i += 2) {
                padding[i] = 46;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                padding[i] = 32;
            }
        }
        appendTo.append(padding);
        return len + sLen;
    }

    public void addListener(FileLoggingAdapter listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(FileLoggingAdapter listener) {
        this.listeners.remove(listener);
    }

    public List getListeners() {
        return this.listeners;
    }
}

