/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.frostwire.gui.theme.SkinCheckBoxMenuItem;
import com.frostwire.gui.theme.SkinMenu;
import com.frostwire.gui.theme.SkinMenuItem;
import com.frostwire.gui.theme.SkinPopupMenu;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.tables.ColumnPreferenceHandler;
import com.limegroup.gnutella.gui.tables.DataLineModel;
import com.limegroup.gnutella.gui.tables.LastColumnException;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.tables.TableSettings;
import com.limegroup.gnutella.settings.QuestionsHandler;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.limewire.setting.BooleanSetting;

public class ColumnSelectionMenu {
    protected static final String COLUMN_ID = "columnId";
    protected static final String SETTING = "setting";
    protected static final ActionListener SETTING_LISTENER = new SettingListener();
    private static final String REVERT_DEFAULT = I18n.tr("Revert To Default");
    public static final String MORE_OPTIONS = I18n.tr("More Options");
    public static final String ROWSTRIPE = I18n.tr("Stripe Rows");
    public static final String SORTING = I18n.tr("Sort Automatically");
    public static final String TOOLTIPS = I18n.tr("Extended Tooltips");
    protected final JPopupMenu _menu = new SkinPopupMenu();
    private final LimeJTable _table;

    public ColumnSelectionMenu(LimeJTable table) {
        this._table = table;
        DataLineModel model = (DataLineModel)this._table.getModel();
        ReverterListener reverter = new ReverterListener();
        SkinMenuItem revert = new SkinMenuItem(REVERT_DEFAULT);
        ColumnPreferenceHandler cph = this._table.getColumnPreferenceHandler();
        TableSettings settings = this._table.getTableSettings();
        if ((cph == null || cph.isDefault()) && (settings == null || settings.isDefault())) {
            revert.setEnabled(false);
        } else {
            revert.addActionListener(reverter);
        }
        this._menu.add(revert);
        if (settings != null) {
            JMenu options = ColumnSelectionMenu.createMoreOptions(settings);
            this._menu.add(options);
        }
        this._menu.addSeparator();
        this.addTableColumnChoices(new SelectionActionListener(), model, table);
    }

    protected void addTableColumnChoices(ActionListener listener, DataLineModel<?, ?> model, LimeJTable table) {
        for (int i = 0; i < model.getColumnCount(); ++i) {
            JMenuItem item = this.createColumnMenuItem(listener, model, table, i);
            this._menu.add(item);
        }
    }

    protected JMenuItem createColumnMenuItem(ActionListener listener, DataLineModel<?, ?> model, LimeJTable table, int i) {
        Object id = model.getColumnId(i);
        String name = model.getColumnName(i);
        SkinCheckBoxMenuItem item = new SkinCheckBoxMenuItem(name, table.isColumnVisible(id));
        item.putClientProperty(COLUMN_ID, id);
        item.addActionListener(listener);
        return item;
    }

    public static JMenu createMoreOptions(TableSettings settings) {
        SkinMenu options = new SkinMenu(MORE_OPTIONS);
        ColumnSelectionMenu.addSetting(options, SORTING, settings.REAL_TIME_SORT);
        ColumnSelectionMenu.addSetting(options, TOOLTIPS, settings.DISPLAY_TOOLTIPS);
        return options;
    }

    public static JMenuItem addSetting(JMenu parent, String name, BooleanSetting setting) {
        SkinCheckBoxMenuItem item = new SkinCheckBoxMenuItem(name, setting.getValue());
        item.putClientProperty(SETTING, setting);
        item.addActionListener(SETTING_LISTENER);
        parent.add(item);
        return item;
    }

    public JPopupMenu getComponent() {
        return this._menu;
    }

    protected static class SettingListener
    implements ActionListener {
        protected SettingListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
            BooleanSetting setting = (BooleanSetting)item.getClientProperty(ColumnSelectionMenu.SETTING);
            setting.setValue(item.getState());
        }
    }

    protected class ReverterListener
    implements ActionListener {
        protected ReverterListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColumnSelectionMenu.this._table.getColumnPreferenceHandler().revertToDefault();
            ColumnSelectionMenu.this._table.getTableSettings().revertToDefault();
        }
    }

    protected class SelectionActionListener
    implements ActionListener {
        protected SelectionActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
            try {
                ColumnSelectionMenu.this._table.setColumnVisible(item.getClientProperty(ColumnSelectionMenu.COLUMN_ID), item.getState());
                ColumnSelectionMenu.this._table.getTableHeader().setDraggedColumn(null);
            }
            catch (LastColumnException ee) {
                GUIMediator.showError(I18n.tr("You cannot turn off all columns."), QuestionsHandler.REMOVE_LAST_COLUMN);
            }
        }
    }
}

