/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.gui.theme.ThemeMediator;
import com.frostwire.uxstats.UXStats;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.search.SourceHolder;
import com.limegroup.gnutella.gui.tables.DefaultTableBevelledCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class SourceRenderer
extends DefaultTableBevelledCellRenderer
implements TableCellRenderer {
    private static final Map<String, ImageIcon> sourceIcons = new HashMap<String, ImageIcon>();
    private SourceHolder sourceHolder;

    public SourceRenderer() {
        this.setCursor(new Cursor(12));
        this.initMouseListener();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int columns) {
        this.setOpaque(true);
        this.setEnabled(true);
        if (isSelected) {
            this.setBackground(ThemeMediator.TABLE_SELECTED_BACKGROUND_ROW_COLOR);
        } else {
            this.setBackground(row % 2 == 1 ? ThemeMediator.TABLE_ALTERNATE_ROW_COLOR : Color.WHITE);
        }
        this.updateUI((SourceHolder)value, table, row);
        return super.getTableCellRendererComponent(table, this.getText(), isSelected, hasFocus, row, columns);
    }

    private void initMouseListener() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SourceRenderer.this.sourceHolder != null) {
                    SourceRenderer.this.sourceHolder.getUISearchResult().showSearchResultWebPage(true);
                    e.consume();
                    UXStats.instance().log(1012);
                }
            }
        };
        this.addMouseListener(mouseAdapter);
    }

    private void updateUI(SourceHolder value, JTable table, int row) {
        this.sourceHolder = value;
        this.updateIcon();
        this.updateLinkLabel(table);
    }

    private void updateIcon() {
        if (this.sourceHolder != null) {
            ImageIcon icon;
            String sourceName = this.sourceHolder.getSourceName().toLowerCase();
            if (sourceName.contains("-")) {
                sourceName = sourceName.substring(0, sourceName.indexOf("-")).trim();
            }
            if ((icon = sourceIcons.get(sourceName)) != null) {
                this.setIcon(icon);
            } else {
                this.setIcon(sourceIcons.get("default"));
            }
        }
    }

    private void updateLinkLabel(JTable table) {
        if (this.sourceHolder != null) {
            this.setText(this.sourceHolder.getSourceNameHTML());
            this.syncFont(table, this);
        }
    }

    private void syncFont(JTable table, JComponent c) {
        Font tableFont = table.getFont();
        if (tableFont != null && !tableFont.equals(c.getFont())) {
            c.setFont(tableFont);
        }
    }

    static {
        try {
            sourceIcons.put("soundcloud", GUIMediator.getThemeImage("soundcloud_off"));
            sourceIcons.put("archive.org", GUIMediator.getThemeImage("archive_source"));
            sourceIcons.put("tpb", GUIMediator.getThemeImage("tpb_source"));
            sourceIcons.put("torlock", GUIMediator.getThemeImage("torlock_off"));
            sourceIcons.put("torrentdownloads", GUIMediator.getThemeImage("torrentdownloads_source"));
            sourceIcons.put("limetorrents", GUIMediator.getThemeImage("torrentdownloads_source"));
            sourceIcons.put("eztv", GUIMediator.getThemeImage("eztv_off"));
            sourceIcons.put("zooqle", GUIMediator.getThemeImage("zooqle_source"));
            sourceIcons.put("default", GUIMediator.getThemeImage("seeding_small_source"));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

