/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.gui.tabs.TransfersTab;
import com.frostwire.search.soundcloud.SoundcloudSearchResult;
import com.frostwire.uxstats.UXStats;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.search.AbstractUISearchResult;
import com.limegroup.gnutella.gui.search.SearchEngine;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.search.SearchResultDataLine;
import com.limegroup.gnutella.gui.search.SearchResultMediator;
import com.limegroup.gnutella.gui.util.PopupUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPopupMenu;

public final class SoundcloudUISearchResult
extends AbstractUISearchResult {
    private final SoundcloudSearchResult sr;

    public SoundcloudUISearchResult(SoundcloudSearchResult sr, SearchEngine se, String query) {
        super(sr, se, query);
        this.sr = sr;
    }

    @Override
    public void download(boolean partial) {
        GUIMediator.instance().showTransfers(TransfersTab.FilterMode.ALL);
        GUIMediator.instance().openSoundcloudTrackUrl(this.sr.getDetailsUrl(), this.sr);
        this.showSearchResultWebPage(false);
        UXStats.instance().log(2003);
    }

    @Override
    public JPopupMenu createMenu(JPopupMenu popupMenu, SearchResultDataLine[] lines, SearchResultMediator rp) {
        PopupUtils.addMenuItem(SearchMediator.DOWNLOAD_STRING, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SoundcloudUISearchResult.this.download(false);
            }
        }, popupMenu, lines.length > 0, 1);
        PopupUtils.addMenuItem(SearchMediator.SOUNDCLOUD_DETAILS_STRING, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SoundcloudUISearchResult.this.showSearchResultWebPage(true);
            }
        }, popupMenu, lines.length == 1, 2);
        return popupMenu;
    }

    @Override
    public String getHash() {
        return null;
    }

    @Override
    public int getSeeds() {
        return 200;
    }

    public String getThumbnailUrl() {
        return this.sr.getThumbnailUrl();
    }

    public String getUsername() {
        return this.sr.getUsername();
    }

    public String getDownloadUrl() {
        return this.sr.getDownloadUrl();
    }
}

