/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.gui.bittorrent.TorrentUtil;
import com.frostwire.gui.filters.TableLineFilter;
import com.frostwire.gui.theme.SkinMenu;
import com.frostwire.gui.theme.SkinMenuItem;
import com.frostwire.gui.theme.SkinPopupMenu;
import com.frostwire.gui.theme.ThemeMediator;
import com.frostwire.search.SearchResult;
import com.frostwire.search.torrent.TorrentSearchResult;
import com.frostwire.util.UrlUtils;
import com.frostwire.uxstats.UXStats;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import com.limegroup.gnutella.gui.actions.SearchAction;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.gui.dnd.MulticastTransferHandler;
import com.limegroup.gnutella.gui.search.CompositeFilter;
import com.limegroup.gnutella.gui.search.GenericCellEditor;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.gui.search.ResultPanelTransferHandler;
import com.limegroup.gnutella.gui.search.SchemaBox;
import com.limegroup.gnutella.gui.search.SearchButtons;
import com.limegroup.gnutella.gui.search.SearchColumnPreferenceHandler;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.search.SearchOptionsPanel;
import com.limegroup.gnutella.gui.search.SearchResultActionsHolder;
import com.limegroup.gnutella.gui.search.SearchResultDataLine;
import com.limegroup.gnutella.gui.search.SearchResultDisplayer;
import com.limegroup.gnutella.gui.search.SearchResultMenu;
import com.limegroup.gnutella.gui.search.SearchResultNameHolder;
import com.limegroup.gnutella.gui.search.SearchTableColumns;
import com.limegroup.gnutella.gui.search.SeasonalContentSearchSuggestion;
import com.limegroup.gnutella.gui.search.SourceHolder;
import com.limegroup.gnutella.gui.search.TableRowFilteredModel;
import com.limegroup.gnutella.gui.search.UISearchResult;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.ColumnPreferenceHandler;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.TableSettings;
import com.limegroup.gnutella.gui.util.PopupUtils;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.util.FrostWireUtils;
import com.limegroup.gnutella.util.QueryUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.OverlayLayout;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.limewire.util.OSUtils;

public final class SearchResultMediator
extends AbstractTableMediator<TableRowFilteredModel, SearchResultDataLine, UISearchResult> {
    private static final String SEARCH_TABLE = "SEARCH_TABLE";
    private static final TableSettings SEARCH_SETTINGS = new TableSettings("SEARCH_TABLE");
    private static final String FROSTWIRE_FEATURED_DOWNLOADS_URL = "http://www.frostwire.com/featured-downloads/?from=desktop-" + UrlUtils.encode(OSUtils.getFullOS() + "-" + FrostWireUtils.getFrostWireVersion() + "b" + FrostWireUtils.getBuildNumber());
    private final SearchInformation SEARCH_INFO;
    private long token;
    private final List<String> searchTokens;
    private CompositeFilter FILTER;
    ActionListener DOWNLOAD_LISTENER;
    MouseAdapter TORRENT_DETAILS_LISTENER;
    private ActionListener COPY_MAGNET_ACTION_LISTENER;
    private ActionListener COPY_HASH_ACTION_LISTENER;
    ActionListener CONFIGURE_SHARING_LISTENER;
    ActionListener DOWNLOAD_PARTIAL_FILES_LISTENER;
    ActionListener STOP_SEARCH_LISTENER;
    private Box SOUTH_PANEL;
    private SchemaBox schemaBox;
    private SearchOptionsPanel searchOptionsPanel;
    private JScrollPane scrollPaneSearchOptions;

    SearchResultMediator(JPanel overlay) {
        super(SEARCH_TABLE);
        this.setupFakeTable(overlay);
        this.SEARCH_INFO = SearchInformation.createKeywordSearch("", null, MediaType.getAnyTypeMediaType());
        this.FILTER = null;
        this.token = 0L;
        this.searchTokens = null;
        this.setButtonEnabled(2, false);
        this.TABLE.setDragEnabled(false);
        this.TABLE.setTransferHandler(null);
        this.SOUTH_PANEL.setVisible(false);
    }

    SearchResultMediator(long token, List<String> searchTokens, SearchInformation info) {
        super(SEARCH_TABLE);
        this.SEARCH_INFO = info;
        this.token = token;
        this.searchTokens = searchTokens;
        this.setupRealTable();
        this.resetFilters();
    }

    @Override
    protected void setDefaultRenderers() {
        super.setDefaultRenderers();
        this.TABLE.setDefaultRenderer(SearchResultNameHolder.class, this.getNameHolderRenderer());
        this.TABLE.setDefaultRenderer(SearchResultActionsHolder.class, this.getSearchResultsActionsRenderer());
        this.TABLE.setDefaultRenderer(SourceHolder.class, this.getSourceRenderer());
    }

    @Override
    protected void setDefaultEditors() {
        TableColumnModel model = this.TABLE.getColumnModel();
        TableColumn tc = model.getColumn(0);
        tc.setCellEditor(new GenericCellEditor(this.getSearchResultsActionsRenderer()));
        tc = model.getColumn(5);
        tc.setCellEditor(new GenericCellEditor(this.getSourceRenderer()));
    }

    @Override
    protected void updateSplashScreen() {
    }

    private void setupDataModel() {
        this.DATA_MODEL = new TableRowFilteredModel(this.FILTER);
    }

    @Override
    protected void setupConstants() {
        this.FILTER = new CompositeFilter(4);
        this.MAIN_PANEL = new PaddedPanel(0);
        this.setupDataModel();
        this.TABLE = new LimeJTable(this.DATA_MODEL);
        this.BUTTON_ROW = new SearchButtons(this).getComponent();
    }

    @Override
    protected void setupDragAndDrop() {
        this.TABLE.setDragEnabled(true);
        this.TABLE.setTransferHandler(new MulticastTransferHandler(new ResultPanelTransferHandler(this), DNDUtils.DEFAULT_TRANSFER_HANDLERS));
    }

    @Override
    protected void buildSettings() {
        this.SETTINGS = SEARCH_SETTINGS;
    }

    @Override
    protected ColumnPreferenceHandler createDefaultColumnPreferencesHandler() {
        return new SearchColumnPreferenceHandler(this.TABLE);
    }

    @Override
    protected void buildListeners() {
        super.buildListeners();
        this.DOWNLOAD_LISTENER = e -> {
            if (e != null && e.getSource() instanceof JButton) {
                UXStats.instance().log(1006);
            }
            SearchMediator.doDownload(this);
        };
        this.TORRENT_DETAILS_LISTENER = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SearchResultDataLine[] lines;
                if (e.getButton() == 1 && (lines = SearchResultMediator.this.getAllSelectedLines()).length == 1) {
                    UISearchResult searchResult = lines[0].getSearchResult();
                    searchResult.showSearchResultWebPage(true);
                }
            }
        };
        this.COPY_MAGNET_ACTION_LISTENER = e -> {
            SearchResultDataLine[] lines = this.getAllSelectedLines();
            StringBuilder sb = new StringBuilder();
            for (SearchResultDataLine line : lines) {
                sb.append(TorrentUtil.getMagnet((UISearchResult)line.getInitializeObject()));
                sb.append("\n");
            }
            GUIMediator.setClipboardContent(sb.toString());
        };
        this.COPY_HASH_ACTION_LISTENER = e -> {
            SearchResultDataLine[] lines = this.getAllSelectedLines();
            StringBuilder sb = new StringBuilder();
            for (SearchResultDataLine line : lines) {
                sb.append(((UISearchResult)line.getInitializeObject()).getHash());
                sb.append("\n");
            }
            GUIMediator.setClipboardContent(sb.toString());
        };
        this.CONFIGURE_SHARING_LISTENER = e -> GUIMediator.instance().setOptionsVisible(true, I18n.tr("Options"));
        this.DOWNLOAD_PARTIAL_FILES_LISTENER = e -> {
            SearchResult sr;
            SearchResultDataLine[] lines = this.getAllSelectedLines();
            if (lines.length == 1 && lines[0] != null && (sr = ((UISearchResult)lines[0].getInitializeObject()).getSearchResult()) instanceof TorrentSearchResult) {
                GUIMediator.instance().openTorrentSearchResult((TorrentSearchResult)sr, true);
            }
        };
        this.STOP_SEARCH_LISTENER = e -> {
            SearchMediator.instance().stopSearch(this.token);
            this.updateSearchIcon(false);
            this.setButtonEnabled(3, false);
        };
    }

    @Override
    public JPopupMenu createPopupMenu() {
        return this.createPopupMenu(this.getAllSelectedLines());
    }

    JPopupMenu createPopupMenu(SearchResultDataLine[] lines) {
        if (!this.isKillable()) {
            return null;
        }
        SkinPopupMenu menu = new SkinPopupMenu();
        if (lines.length > 0) {
            boolean allWithHash = true;
            for (SearchResultDataLine line : lines) {
                if (line.getHash() != null) continue;
                allWithHash = false;
                break;
            }
            PopupUtils.addMenuItem(I18n.tr("Copy Magnet"), this.COPY_MAGNET_ACTION_LISTENER, menu, allWithHash);
            PopupUtils.addMenuItem(I18n.tr("Copy Hash"), this.COPY_HASH_ACTION_LISTENER, menu, allWithHash);
            menu.add(this.createSearchAgainMenu(lines[0]));
        } else {
            SeasonalContentSearchSuggestion.attemptToAddSeasonalContentSearchSuggestion(null, menu, this.searchTokens);
            menu.add(new SkinMenuItem(new RepeatSearchAction()));
            menu.add(new JSeparator(0));
            menu.add(new SkinMenuItem(new CloseTabAction()));
            menu.add(new SkinMenuItem(new CloseAllTabsAction()));
            menu.add(new SkinMenuItem(new CloseOtherTabsAction()));
            menu.add(new SkinMenuItem(new CloseTabsToTheRight()));
        }
        return new SearchResultMenu(this).addToMenu(menu, lines);
    }

    private JMenu createSearchAgainMenu(SearchResultDataLine line) {
        SkinMenu menu = new SkinMenu(I18n.tr("Search More"));
        menu.add(new SkinMenuItem(new RepeatSearchAction()));
        if (line == null) {
            menu.setEnabled(this.isRepeatSearchEnabled());
            return menu;
        }
        menu.addSeparator();
        String keywords = QueryUtils.createQueryString(line.getFilename());
        SearchInformation info = SearchInformation.createKeywordSearch(keywords, null, MediaType.getAnyTypeMediaType());
        if (SearchMediator.validateInfo(info) == 0) {
            SeasonalContentSearchSuggestion.attemptToAddSeasonalContentSearchSuggestion(menu, null, this.searchTokens);
            menu.add(new SkinMenuItem(new SearchAction(info, I18n.tr("Search for Keywords: {0}"))));
        }
        return menu;
    }

    @Override
    public void removeSelection() {
    }

    @Override
    public void handleNoSelection() {
        this.setButtonEnabled(1, false);
        this.setButtonEnabled(2, false);
        this.setButtonEnabled(3, !this.isStopped());
    }

    @Override
    public void handleSelection(int i) {
        this.setButtonEnabled(1, true);
        this.setButtonEnabled(3, !this.isStopped());
        SearchResultDataLine[] allSelectedLines = this.getAllSelectedLines();
        this.setButtonEnabled(2, allSelectedLines != null && allSelectedLines.length == 1);
    }

    @Override
    public void handleMouseDoubleClick(MouseEvent e) {
        UXStats.instance().log(1004);
        this.DOWNLOAD_LISTENER.actionPerformed(null);
    }

    @Override
    public void handleActionKey() {
        UXStats.instance().log(1005);
        this.DOWNLOAD_LISTENER.actionPerformed(null);
    }

    void selectSchemaBoxByMediaType(NamedMediaType type) {
        this.schemaBox.selectMediaType(type);
    }

    String getQuery() {
        return this.SEARCH_INFO.getQuery();
    }

    String getTitle() {
        return this.SEARCH_INFO.getTitle();
    }

    boolean isStopped() {
        return this.token == 0L;
    }

    boolean isEmpty() {
        return ((TableRowFilteredModel)this.DATA_MODEL).getRowCount() == 0;
    }

    private boolean isKillable() {
        return this.FILTER != null;
    }

    void filterChanged(TableLineFilter<SearchResultDataLine> filter, int depth) {
        int i;
        this.FILTER.setFilter(depth, filter);
        int[] rows = this.TABLE.getSelectedRows();
        SearchResultDataLine[] lines = new SearchResultDataLine[rows.length];
        LinkedList<SearchResultDataLine> inView = new LinkedList<SearchResultDataLine>();
        for (i = 0; i < rows.length; ++i) {
            SearchResultDataLine line;
            int row = rows[i];
            lines[i] = line = (SearchResultDataLine)((TableRowFilteredModel)this.DATA_MODEL).get(row);
            if (!this.TABLE.isRowVisible(row)) continue;
            inView.add(line);
        }
        ((TableRowFilteredModel)this.DATA_MODEL).filtersChanged();
        for (i = 0; i < rows.length; ++i) {
            SearchResultDataLine line = lines[i];
            int row = ((TableRowFilteredModel)this.DATA_MODEL).getRow(line);
            if (row == -1) continue;
            this.TABLE.addRowSelectionInterval(row, row);
            if (inView == null || !inView.contains(line)) continue;
            this.TABLE.ensureRowVisible(row);
            inView = null;
        }
        SearchMediator.setTabDisplayCount(this);
    }

    int totalResults() {
        return ((TableRowFilteredModel)this.DATA_MODEL).getTotalResults();
    }

    private boolean isRepeatSearchEnabled() {
        return this.FILTER != null;
    }

    private void repeatSearch() {
        this.clearTable();
        this.resetFilters();
        this.schemaBox.resetCounters();
        SearchMediator.setTabDisplayCount(this);
        SearchMediator.instance().repeatSearch(this, this.SEARCH_INFO);
        this.setButtonEnabled(2, false);
        this.setButtonEnabled(3, !this.isStopped());
    }

    private void resetFilters() {
        this.FILTER.reset();
        ((TableRowFilteredModel)this.DATA_MODEL).setJunkFilter(null);
    }

    boolean matches(long token) {
        return this.token == token;
    }

    void setToken(long token) {
        this.token = token;
    }

    long getToken() {
        return this.token;
    }

    SearchResultDataLine[] getAllSelectedLines() {
        int[] rows = this.TABLE.getSelectedRows();
        if (rows == null) {
            return new SearchResultDataLine[0];
        }
        SearchResultDataLine[] lines = new SearchResultDataLine[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            lines[i] = (SearchResultDataLine)((TableRowFilteredModel)this.DATA_MODEL).get(rows[i]);
        }
        return lines;
    }

    private void setupRealTable() {
        SearchTableColumns columns = ((TableRowFilteredModel)this.DATA_MODEL).getColumns();
        LimeTableColumn countColumn = columns.getColumn(1);
        if (countColumn != null && this.SETTINGS.REAL_TIME_SORT.getValue() && this.TABLE.isColumnVisible(countColumn.getId())) {
            ((TableRowFilteredModel)this.DATA_MODEL).sort(1);
            ((TableRowFilteredModel)this.DATA_MODEL).sort(1);
        }
    }

    private void setupMainPanelBase() {
        if (SearchSettings.ENABLE_SPAM_FILTER.getValue() && this.MAIN_PANEL != null) {
            this.MAIN_PANEL.add(this.createSchemaBox());
            this.MAIN_PANEL.add(this.getScrolledTablePane());
            this.addButtonRow();
        } else {
            super.setupMainPanel();
        }
    }

    @Override
    protected JComponent getScrolledTablePane() {
        if (this.TABLE_PANE != null) {
            return this.TABLE_PANE;
        }
        JPanel tablePane = new JPanel();
        tablePane.setLayout(new BoxLayout(tablePane, 2));
        this.SCROLL_PANE = new JScrollPane(this.TABLE);
        this.SCROLL_PANE.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 6, 0, 6), this.SCROLL_PANE.getBorder()));
        tablePane.add(this.SCROLL_PANE);
        this.scrollPaneSearchOptions = this.createSearchOptionsPanel();
        this.scrollPaneSearchOptions.setVisible(false);
        tablePane.add(this.scrollPaneSearchOptions);
        this.TABLE_PANE = tablePane;
        return tablePane;
    }

    private JComponent createSchemaBox() {
        this.schemaBox = new SchemaBox(this);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ThemeMediator.LIGHT_BORDER_COLOR));
        String strShowOpts = I18n.tr("Search tools");
        String strHideOpts = I18n.tr("Search tools");
        JButton buttonOptions = new JButton(strShowOpts);
        buttonOptions.setContentAreaFilled(false);
        buttonOptions.setOpaque(false);
        Dimension dim = new Dimension(140, 30);
        buttonOptions.setMinimumSize(dim);
        buttonOptions.setMaximumSize(dim);
        buttonOptions.setPreferredSize(dim);
        buttonOptions.setSize(dim);
        buttonOptions.setIcon(GUIMediator.getThemeImage("search_tools_left"));
        buttonOptions.setHorizontalTextPosition(4);
        buttonOptions.addActionListener(e -> {
            this.scrollPaneSearchOptions.setVisible(!this.scrollPaneSearchOptions.isVisible());
            buttonOptions.setText(this.scrollPaneSearchOptions.isVisible() ? strHideOpts : strShowOpts);
            buttonOptions.setIcon(!this.scrollPaneSearchOptions.isVisible() ? GUIMediator.getThemeImage("search_tools_left") : GUIMediator.getThemeImage("search_tools_right"));
            buttonOptions.setHorizontalTextPosition(!this.scrollPaneSearchOptions.isVisible() ? 4 : 2);
            if (this.scrollPaneSearchOptions.isVisible()) {
                this.searchOptionsPanel.onOptionsPanelShown();
                UXStats.instance().log(1014);
            }
        });
        JSeparator sep = new JSeparator(1);
        sep.setMaximumSize(new Dimension(2, 100));
        panel.add(this.schemaBox);
        panel.add(Box.createHorizontalGlue());
        panel.add(sep);
        panel.add(buttonOptions);
        return panel;
    }

    private JScrollPane createSearchOptionsPanel() {
        this.searchOptionsPanel = new SearchOptionsPanel(this);
        this.searchOptionsPanel.putClientProperty("skin_property_dark_box_background", Boolean.TRUE);
        JScrollPane sp = new JScrollPane(this.searchOptionsPanel);
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(), BorderFactory.createMatteBorder(0, 1, 1, 0, ThemeMediator.LIGHT_BORDER_COLOR));
        sp.setBorder(border);
        sp.setHorizontalScrollBarPolicy(31);
        Dimension d = new Dimension(250, 70000);
        sp.setPreferredSize(d);
        sp.setMaximumSize(d);
        return sp;
    }

    @Override
    protected void setupMainPanel() {
        this.setupMainPanelBase();
    }

    private void setupFakeTable(JPanel overlay) {
        this.MAIN_PANEL.removeAll();
        JPanel background = new JPanel(){

            @Override
            public boolean isOptimizedDrawingEnabled() {
                return false;
            }
        };
        background.setLayout(new OverlayLayout(background));
        JPanel overlayPanel = new JPanel();
        overlayPanel.setOpaque(false);
        overlayPanel.setLayout(new MigLayout("fill, wrap"));
        overlayPanel.add((Component)overlay, "center");
        overlayPanel.add(this.getBrowseAllFeaturedDownloadsButton(), "center");
        JScrollPane scrollPane = new JScrollPane(overlayPanel);
        scrollPane.setVerticalScrollBarPolicy(21);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.getViewport().setBackground(Color.WHITE);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(28, 10, 4, 10));
        JComponent table = this.getScrolledTablePane();
        table.setOpaque(false);
        background.add(scrollPane);
        background.add(table);
        this.MAIN_PANEL.add(background);
        this.addButtonRow();
    }

    private Component getBrowseAllFeaturedDownloadsButton() {
        Color blue = new Color(70, 179, 232);
        JLabel browseAll = new JLabel(I18n.tr("All Free Downloads"));
        browseAll.setBackground(blue);
        browseAll.setForeground(Color.WHITE);
        browseAll.setOpaque(true);
        browseAll.setFont(new Font("Helvetica", 1, 24));
        browseAll.setBorder(new EmptyBorder(20, 50, 20, 50));
        browseAll.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                GUIMediator.openURL(FROSTWIRE_FEATURED_DOWNLOADS_URL);
            }
        });
        return browseAll;
    }

    private void addButtonRow() {
        if (this.BUTTON_ROW != null) {
            this.SOUTH_PANEL = Box.createVerticalBox();
            this.SOUTH_PANEL.setOpaque(false);
            this.SOUTH_PANEL.add(Box.createVerticalStrut(6));
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.anchor = 10;
            gbc.fill = 0;
            gbc.gridwidth = -1;
            gbc.weightx = 1.0;
            buttonPanel.add((Component)this.BUTTON_ROW, gbc);
            buttonPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 64));
            this.SOUTH_PANEL.add(buttonPanel);
            this.MAIN_PANEL.add(this.SOUTH_PANEL);
        }
    }

    public void cleanup() {
    }

    void updateSearchIcon(boolean active) {
        SearchMediator.getSearchResultDisplayer().updateSearchIcon(this, active);
        this.setButtonEnabled(3, active);
    }

    List<String> getSearchTokens() {
        return this.searchTokens;
    }

    void updateFiltersPanel() {
        this.schemaBox.applyFilters();
        this.searchOptionsPanel.updateFiltersPanel();
    }

    void resetFiltersPanel() {
        this.schemaBox.applyFilters();
        this.searchOptionsPanel.resetFilters();
        this.searchOptionsPanel.updateFiltersPanel();
    }

    @Override
    public void add(UISearchResult o, int index) {
        super.add(o, index);
        this.schemaBox.updateCounters(o);
    }

    private final class CloseTabsToTheRight
    extends AbstractAction {
        CloseTabsToTheRight() {
            this.putValue("Name", SearchMediator.CLOSE_TABS_TO_THE_RIGHT);
            SearchResultDisplayer searchResultDisplayer = SearchMediator.getSearchResultDisplayer();
            this.setEnabled(searchResultDisplayer.currentTabIndex() < searchResultDisplayer.tabCount() - 1);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SearchResultDisplayer searchResultDisplayer = SearchMediator.getSearchResultDisplayer();
            for (int tabsToRemove = searchResultDisplayer.tabCount() - searchResultDisplayer.currentTabIndex() - 1; tabsToRemove > 0; --tabsToRemove) {
                searchResultDisplayer.closeTabAt(searchResultDisplayer.currentTabIndex() + 1);
            }
        }
    }

    private final class CloseOtherTabsAction
    extends AbstractAction {
        CloseOtherTabsAction() {
            this.putValue("Name", SearchMediator.CLOSE_OTHER_TABS_STRING);
            this.setEnabled(SearchMediator.getSearchResultDisplayer().tabCount() > 1);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SearchMediator.getSearchResultDisplayer().closeOtherTabs();
        }
    }

    private final class CloseAllTabsAction
    extends AbstractAction {
        CloseAllTabsAction() {
            this.putValue("Name", SearchMediator.CLOSE_ALL_TABS);
            this.setEnabled(SearchMediator.getSearchResultDisplayer().tabCount() > 0);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SearchMediator.getSearchResultDisplayer().closeAllTabs();
        }
    }

    private final class CloseTabAction
    extends AbstractAction {
        CloseTabAction() {
            this.putValue("Name", SearchMediator.CLOSE_TAB_STRING);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SearchMediator.getSearchResultDisplayer().closeCurrentTab();
        }
    }

    private final class RepeatSearchAction
    extends AbstractAction {
        private static final long serialVersionUID = -209446182720400951L;

        RepeatSearchAction() {
            this.putValue("Name", SearchMediator.REPEAT_SEARCH_STRING);
            this.setEnabled(SearchResultMediator.this.isRepeatSearchEnabled());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SearchResultMediator.this.repeatSearch();
        }
    }
}

