/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.frostwire.search.SearchPerformer;
import com.frostwire.search.archiveorg.ArchiveorgSearchPerformer;
import com.frostwire.search.eztv.EztvSearchPerformer;
import com.frostwire.search.frostclick.FrostClickSearchPerformer;
import com.frostwire.search.frostclick.UserAgent;
import com.frostwire.search.limetorrents.LimeTorrentsSearchPerformer;
import com.frostwire.search.pixabay.PixabaySearchPerformer;
import com.frostwire.search.soundcloud.SoundcloudSearchPerformer;
import com.frostwire.search.torlock.TorLockSearchPerformer;
import com.frostwire.search.torrentdownloads.TorrentDownloadsSearchPerformer;
import com.frostwire.search.tpb.TPBSearchPerformer;
import com.frostwire.search.yify.YifySearchPerformer;
import com.frostwire.search.zooqle.ZooqleSearchPerformer;
import com.limegroup.gnutella.settings.SearchEnginesSettings;
import com.limegroup.gnutella.util.FrostWireUtils;
import java.util.Arrays;
import java.util.List;
import org.limewire.setting.BooleanSetting;
import org.limewire.util.OSUtils;

public abstract class SearchEngine {
    private static final int DEFAULT_TIMEOUT = 5000;
    public String redirectUrl = null;
    private final int _id;
    private final String _name;
    private final String _domainName;
    private final BooleanSetting _setting;
    private static final int TPB_ID = 6;
    private static final int SOUNDCLOUD_ID = 10;
    private static final int ARCHIVEORG_ID = 11;
    private static final int FROSTCLICK_ID = 12;
    private static final int TORLOCK_ID = 14;
    private static final int EZTV_ID = 15;
    private static final int YIFI_ID = 17;
    private static final int TORRENTDOWNLOADS_ID = 19;
    private static final int LIMETORRENTS_ID = 20;
    private static final int ZOOQLE_ID = 21;
    private static final int PIXABAY_ID = 22;
    private static final SearchEngine TPB = new SearchEngine(6, "TPB", SearchEnginesSettings.TPB_SEARCH_ENABLED, "thepiratebay.org"){

        @Override
        public SearchPerformer getPerformer(long token, String keywords) {
            return new TPBSearchPerformer(TPB.getDomainName(), token, keywords, 5000);
        }
    };
    private static final SearchEngine SOUNDCLOUD = new SearchEngine(10, "Soundcloud", SearchEnginesSettings.SOUNDCLOUD_SEARCH_ENABLED, "api.sndcdn.com"){

        @Override
        public SearchPerformer getPerformer(long token, String keywords) {
            return new SoundcloudSearchPerformer(SOUNDCLOUD.getDomainName(), token, keywords, 5000);
        }
    };
    private static final SearchEngine ARCHIVEORG = new SearchEngine(11, "Archive.org", SearchEnginesSettings.ARCHIVEORG_SEARCH_ENABLED, "archive.org"){

        @Override
        public SearchPerformer getPerformer(long token, String keywords) {
            return new ArchiveorgSearchPerformer(ARCHIVEORG.getDomainName(), token, keywords, 5000);
        }
    };
    private static final SearchEngine FROSTCLICK = new SearchEngine(12, "FrostClick", SearchEnginesSettings.FROSTCLICK_SEARCH_ENABLED, "api.frostclick.com"){
        private final UserAgent userAgent = new UserAgent(OSUtils.getFullOS(), FrostWireUtils.getFrostWireVersion(), String.valueOf(FrostWireUtils.getBuildNumber()));

        @Override
        public SearchPerformer getPerformer(long token, String keywords) {
            return new FrostClickSearchPerformer(FROSTCLICK.getDomainName(), token, keywords, 5000, this.userAgent);
        }
    };
    private static final SearchEngine TORLOCK = new SearchEngine(14, "TorLock", SearchEnginesSettings.TORLOCK_SEARCH_ENABLED, "www.torlock.com"){

        @Override
        public SearchPerformer getPerformer(long token, String keywords) {
            return new TorLockSearchPerformer(TORLOCK.getDomainName(), token, keywords, 5000);
        }
    };
    private static final SearchEngine TORRENTDOWNLOADS = new SearchEngine(19, "TorrentDownloads", SearchEnginesSettings.TORRENTDOWNLOADS_SEARCH_ENABLED, "www.torrentdownloads.me"){

        @Override
        public SearchPerformer getPerformer(long token, String keywords) {
            return new TorrentDownloadsSearchPerformer(TORRENTDOWNLOADS.getDomainName(), token, keywords, 5000);
        }
    };
    private static final SearchEngine LIMETORRENTS = new SearchEngine(20, "LimeTorrents", SearchEnginesSettings.LIMETORRENTS_SEARCH_ENABLED, "www.limetorrents.cc"){

        @Override
        public SearchPerformer getPerformer(long token, String keywords) {
            return new LimeTorrentsSearchPerformer(LIMETORRENTS.getDomainName(), token, keywords, 5000);
        }
    };
    private static final SearchEngine EZTV = new SearchEngine(15, "Eztv", SearchEnginesSettings.EZTV_SEARCH_ENABLED, "eztv.ag"){

        @Override
        public SearchPerformer getPerformer(long token, String keywords) {
            return new EztvSearchPerformer(EZTV.getDomainName(), token, keywords, 5000);
        }
    };
    private static final SearchEngine YIFY = new SearchEngine(17, "Yify", SearchEnginesSettings.YIFY_SEARCH_ENABLED, "www.yify-torrent.org"){

        @Override
        public SearchPerformer getPerformer(long token, String keywords) {
            return new YifySearchPerformer(YIFY.getDomainName(), token, keywords, 5000);
        }
    };
    private static final SearchEngine ZOOQLE = new SearchEngine(21, "Zooqle", SearchEnginesSettings.ZOOQLE_SEARCH_ENABLED, "zooqle.com"){

        @Override
        public SearchPerformer getPerformer(long token, String keywords) {
            return new ZooqleSearchPerformer(ZOOQLE.getDomainName(), token, keywords, 5000);
        }
    };
    private static final SearchEngine PIXABAY = new SearchEngine(22, "Pixabay", SearchEnginesSettings.PIXABAY_SEARCH_ENABLED, "pixabay.com"){

        @Override
        public SearchPerformer getPerformer(long token, String keywords) {
            return new PixabaySearchPerformer(token, keywords, 5000);
        }
    };

    public SearchEngine(int id, String name, BooleanSetting setting, String domainName) {
        this._id = id;
        this._name = name;
        this._setting = setting;
        this._domainName = domainName;
    }

    public int getId() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public String getDomainName() {
        return this._domainName;
    }

    public boolean isEnabled() {
        return this._setting.getValue();
    }

    public boolean equals(Object obj) {
        return obj instanceof SearchEngine && this._id == ((SearchEngine)obj)._id;
    }

    public int hashCode() {
        return this._id;
    }

    public static List<SearchEngine> getEngines() {
        List<SearchEngine> list = Arrays.asList(ZOOQLE, TPB, SOUNDCLOUD, PIXABAY, FROSTCLICK, ARCHIVEORG, TORLOCK, YIFY, EZTV, TORRENTDOWNLOADS, LIMETORRENTS);
        boolean oneEnabled = false;
        for (SearchEngine se : list) {
            if (!se.isEnabled()) continue;
            oneEnabled = true;
        }
        if (!oneEnabled) {
            SearchEngine.ARCHIVEORG._setting.setValue(true);
        }
        return list;
    }

    public abstract SearchPerformer getPerformer(long var1, String var3);

    static SearchEngine getSearchEngineByName(String name) {
        List<SearchEngine> searchEngines = SearchEngine.getEngines();
        for (SearchEngine engine : searchEngines) {
            if (!name.startsWith(engine.getName())) continue;
            return engine;
        }
        return null;
    }

    public BooleanSetting getEnabledSetting() {
        return this._setting;
    }
}

