/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.search.SearchResultDataLine;
import com.limegroup.gnutella.gui.search.SearchTableColumns;
import com.limegroup.gnutella.gui.search.UISearchResult;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.BasicDataLineModel;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import java.util.HashMap;
import java.util.Map;

class ResultPanelModel
extends BasicDataLineModel<SearchResultDataLine, UISearchResult> {
    private static final long serialVersionUID = -2382156313320196261L;
    protected final SearchTableColumns COLUMNS = new SearchTableColumns();
    private final Map<String, Integer> _indexes = new HashMap<String, Integer>();
    private int _numResults;

    ResultPanelModel() {
        super(SearchResultDataLine.class);
    }

    SearchTableColumns getColumns() {
        return this.COLUMNS;
    }

    @Override
    public SearchResultDataLine createDataLine() {
        return new SearchResultDataLine(this.COLUMNS);
    }

    @Override
    public LimeTableColumn getTableColumn(int idx) {
        return this.COLUMNS.getColumn(idx);
    }

    @Override
    public int compare(SearchResultDataLine ta, SearchResultDataLine tb) {
        if (this._activeColumn == 2) {
            return AbstractTableMediator.compare(ta.getExtension(), tb.getExtension()) * this._ascending;
        }
        if (!this.isSorted() || this._activeColumn != 1) {
            return super.compare(ta, tb);
        }
        return this.compareCount(ta, tb);
    }

    @Override
    public void remove(int row) {
        String sha1 = this.getHash(row);
        if (sha1 != null) {
            this._indexes.remove(sha1);
        }
        super.remove(row);
        --this._numResults;
        this.remapIndexes(row);
    }

    @Override
    public int add(UISearchResult o) {
        return this.add(o, this.getRowCount());
    }

    @Override
    public int add(SearchResultDataLine dl) {
        return super.add(dl);
    }

    @Override
    public Object refresh() {
        this.fireTableRowsUpdated(0, this.getRowCount());
        return null;
    }

    @Override
    public int add(SearchResultDataLine tl, int row) {
        ++this._numResults;
        String sha1 = tl.getHash();
        if (sha1 != null) {
            this._indexes.put(sha1, row);
        }
        int addedAt = super.add(tl, row);
        this.remapIndexes(addedAt + 1);
        return addedAt;
    }

    @Override
    public int getRow(SearchResultDataLine tl) {
        String sha1 = tl.getHash();
        if (sha1 != null) {
            return this.fastMatch(sha1);
        }
        return super.getRow(tl);
    }

    @Override
    protected void doResort() {
        super.doResort();
        this._indexes.clear();
        this.remapIndexes(0);
    }

    @Override
    protected void cleanup() {
    }

    protected void simpleClear() {
        this._numResults = 0;
        this._indexes.clear();
        super.clear();
    }

    private void remapIndexes(int start) {
        this.remapIndexes(start, this.getRowCount());
    }

    private void remapIndexes(int start, int end) {
        for (int i = start; i < end; ++i) {
            String sha1 = this.getHash(i);
            if (sha1 == null) continue;
            this._indexes.put(sha1, i);
        }
    }

    private String getHash(int idx) {
        if (idx >= this.getRowCount()) {
            return null;
        }
        return ((SearchResultDataLine)this.get(idx)).getHash();
    }

    private int compareCount(SearchResultDataLine a, SearchResultDataLine b) {
        int c1 = a.getSeeds();
        int c2 = b.getSeeds();
        return (c1 - c2) * this._ascending;
    }

    private int fastMatch(String sha1) {
        Integer idx = this._indexes.get(sha1);
        if (idx == null) {
            return -1;
        }
        return idx;
    }

    public int getTotalResults() {
        return this._numResults;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 3 || columnIndex == 5 || columnIndex == 0;
    }
}

