/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.BugSettings;
import javax.swing.JCheckBox;

public final class UXStatsPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Anonymous Usage Statistics");
    public static final String LABEL = I18n.tr("Send anonymous usage statistics so that FrostWire can be improved more effectively. No information regarding content searched, shared or played nor any information that can personally identify you will be stored on disk or sent through the network.");
    public static final String CHECK_BOX_LABEL = I18n.tr("Send anonymous usage statistics");
    private final JCheckBox CHECK_BOX = new JCheckBox();

    public UXStatsPaneItem() {
        super(TITLE, LABEL);
        LabeledComponent comp = new LabeledComponent(CHECK_BOX_LABEL, this.CHECK_BOX, 120, 10);
        this.add(comp.getComponent());
    }

    @Override
    public void initOptions() {
        this.CHECK_BOX.setSelected(ApplicationSettings.UX_STATS_ENABLED.getValue());
    }

    @Override
    public boolean applyOptions() {
        ApplicationSettings.UX_STATS_ENABLED.setValue(this.CHECK_BOX.isSelected());
        if (ApplicationSettings.UX_STATS_ENABLED.getValue()) {
            BugSettings.IGNORE_ALL_BUGS.setValue(false);
            BugSettings.SEND_DEADLOCK_BUGS.setValue(true);
            BugSettings.USE_AUTOMATIC_BUG.setValue(true);
        }
        return true;
    }

    @Override
    public boolean isDirty() {
        return ApplicationSettings.UX_STATS_ENABLED.getValue() != this.CHECK_BOX.isSelected();
    }
}

