/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.SettingsWarningManager;
import com.limegroup.gnutella.gui.options.OptionsPane;
import com.limegroup.gnutella.gui.options.OptionsPaneFactory;
import com.limegroup.gnutella.gui.options.OptionsTreeNode;
import java.awt.CardLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;

public final class OptionsPaneManager {
    private final JPanel MAIN_PANEL = new JPanel();
    private final CardLayout CARD_LAYOUT = new CardLayout();
    private final List<OptionsPane> OPTIONS_PANE_LIST = new ArrayList<OptionsPane>();
    private final Map<String, OptionsPane> panesByKey = new HashMap<String, OptionsPane>();
    private final OptionsPaneFactory FACTORY = new OptionsPaneFactory();

    public OptionsPaneManager() {
        this.MAIN_PANEL.setLayout(this.CARD_LAYOUT);
    }

    public final void show(OptionsTreeNode node) {
        if (!this.panesByKey.containsKey(node.getTitleKey())) {
            OptionsPane pane = this.FACTORY.createOptionsPane(node);
            pane.initOptions();
            this.addPane(pane);
            this.panesByKey.put(node.getTitleKey(), pane);
            if (node.getTitleKey().equals("OPTIONS_SAVE_BASIC_MAIN_TITLE") && !this.panesByKey.containsKey("OPTIONS_SHARED_BASIC_TITLE")) {
                OptionsPane shared = this.FACTORY.createOptionsPane(node);
                shared.initOptions();
                this.addPane(shared);
                this.panesByKey.put(node.getTitleKey(), shared);
            }
        }
        this.CARD_LAYOUT.show(this.MAIN_PANEL, node.getTitleKey());
    }

    public void initOptions() {
        int size = this.OPTIONS_PANE_LIST.size();
        for (int i = 0; i < size; ++i) {
            OptionsPane op = this.OPTIONS_PANE_LIST.get(i);
            op.initOptions();
        }
    }

    public final void applyOptions() throws IOException {
        boolean restartRequired = false;
        int size = this.OPTIONS_PANE_LIST.size();
        for (int i = 0; i < size; ++i) {
            OptionsPane op = this.OPTIONS_PANE_LIST.get(i);
            restartRequired |= op.applyOptions();
        }
        if (restartRequired) {
            GUIMediator.showMessage(I18n.tr("One or more options will take effect the next time FrostWire is restarted."));
        }
        SettingsWarningManager.checkSettingsLoadSaveFailure();
    }

    public final boolean isDirty() {
        int size = this.OPTIONS_PANE_LIST.size();
        for (int i = 0; i < size; ++i) {
            OptionsPane op = this.OPTIONS_PANE_LIST.get(i);
            if (!op.isDirty()) continue;
            return true;
        }
        return false;
    }

    public final Component getComponent() {
        return this.MAIN_PANEL;
    }

    public final void addPane(OptionsPane pane) {
        this.MAIN_PANEL.add((Component)pane.getContainer(), pane.getName());
        this.OPTIONS_PANE_LIST.add(pane);
    }

    public void reinitPane(String paneKey) {
        OptionsPane optionsPane = this.panesByKey.get(paneKey);
        if (optionsPane != null) {
            optionsPane.initOptions();
        }
    }
}

