/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.frostwire.uxstats.UXStats;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.FramedDialog;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.Line;
import com.limegroup.gnutella.gui.SplashWindow;
import com.limegroup.gnutella.gui.init.ApplySettingsException;
import com.limegroup.gnutella.gui.init.AssociationsWindow;
import com.limegroup.gnutella.gui.init.BitTorrentSettingsWindow;
import com.limegroup.gnutella.gui.init.IntentWindow;
import com.limegroup.gnutella.gui.init.LanguagePanel;
import com.limegroup.gnutella.gui.init.MiscWindow;
import com.limegroup.gnutella.gui.init.SetupWindow;
import com.limegroup.gnutella.gui.init.SetupWindowHolder;
import com.limegroup.gnutella.gui.init.SocialRecommendationsWindow;
import com.limegroup.gnutella.gui.init.WelcomeWindow;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.InstallSettings;
import com.limegroup.gnutella.util.FrostWireUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.limewire.setting.SettingsGroupManager;
import org.limewire.util.CommonUtils;
import org.limewire.util.OSUtils;

public final class SetupManager {
    private FramedDialog dialogFrame;
    private SetupWindowHolder _setupWindowHolder;
    private SetupWindow _currentWindow;
    private Dimension holderPreferredSize;
    static final int ACTION_PREVIOUS = 1;
    static final int ACTION_NEXT = 2;
    static final int ACTION_FINISH = 4;
    static final int ACTION_CANCEL = 8;
    private PreviousAction previousAction = new PreviousAction();
    private NextAction nextAction = new NextAction();
    private FinishAction finishAction = new FinishAction();
    private CancelAction cancelAction = new CancelAction();
    private LanguageAwareAction[] actions = new LanguageAwareAction[]{this.previousAction, this.nextAction, this.finishAction, this.cancelAction};

    private boolean shouldShowAssociationsWindow() {
        if (CommonUtils.isPortable() || InstallSettings.ASSOCIATION_OPTION.getValue() == 2) {
            return false;
        }
        return !GUIMediator.getAssociationManager().checkAndGrab(false);
    }

    private SaveStatus shouldShowSaveDirectoryWindow() {
        if (!InstallSettings.SAVE_DIRECTORY.getValue()) {
            return SaveStatus.NEEDS;
        }
        if (!InstallSettings.LAST_FROSTWIRE_VERSION_WIZARD_INVOKED.getValue().equals(String.valueOf(FrostWireUtils.getBuildNumber()))) {
            return SaveStatus.NEEDS;
        }
        return SaveStatus.NO;
    }

    public void createIfNeeded() {
        IntentWindow intentWindow;
        this._setupWindowHolder = new SetupWindowHolder();
        LinkedList<SetupWindow> windows = new LinkedList<SetupWindow>();
        SaveStatus saveDirectoryStatus = this.shouldShowSaveDirectoryWindow();
        if (saveDirectoryStatus != SaveStatus.NO) {
            windows.add(new BitTorrentSettingsWindow(this));
        }
        if (!InstallSettings.SPEED.getValue() || !InstallSettings.START_STARTUP.getValue() && GUIUtils.shouldShowStartOnStartupWindow()) {
            windows.add(new MiscWindow(this));
        }
        if (this.shouldShowAssociationsWindow()) {
            windows.add(new AssociationsWindow(this));
        }
        if (windows.size() > 0) {
            windows.add(new SocialRecommendationsWindow(this));
        }
        if (!(intentWindow = new IntentWindow(this)).isConfirmedWillNot()) {
            windows.add(intentWindow);
        } else {
            UXStats.instance().log(2);
        }
        if (windows.size() == 0) {
            return;
        }
        boolean partial = ApplicationSettings.INSTALLED.getValue();
        windows.add(0, new WelcomeWindow(this, partial));
        this.holderPreferredSize = new Dimension(0, 0);
        SetupWindow prior = null;
        for (SetupWindow current : windows) {
            this._setupWindowHolder.add(current);
            if (prior == null) {
                current.setPrevious(current);
            } else {
                current.setPrevious(prior);
            }
            if (prior != null) {
                prior.setNext(current);
            }
            prior = current;
            Dimension d = current.calculatePreferredSize();
            if (d.width > this.holderPreferredSize.width) {
                this.holderPreferredSize.width = d.width;
            }
            if (d.height <= this.holderPreferredSize.height) continue;
            this.holderPreferredSize.height = d.height;
        }
        this.holderPreferredSize.width += 20;
        this.holderPreferredSize.height += 20;
        if (this.holderPreferredSize.width > 900) {
            this.holderPreferredSize.width = 900;
        }
        if (this.holderPreferredSize.height > 750) {
            this.holderPreferredSize.height = 750;
        }
        assert (prior != null);
        prior.setNext(prior);
        this.createDialog((SetupWindow)windows.get(0));
    }

    private void createDialog(SetupWindow firstWindow) {
        this.dialogFrame = new FramedDialog();
        this.dialogFrame.setTitle("FrostWire Setup");
        WindowAdapter onCloseAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SetupManager.this.cancelSetup();
            }
        };
        this.dialogFrame.addWindowListener(onCloseAdapter);
        JDialog dialog = this.dialogFrame.getDialog();
        dialog.setModal(true);
        dialog.setTitle(I18n.tr("FrostWire Setup Wizard"));
        dialog.addWindowListener(onCloseAdapter);
        Container container = dialog.getContentPane();
        GUIUtils.addHideAction((JComponent)container);
        BoxLayout containerLayout = new BoxLayout(container, 1);
        container.setLayout(containerLayout);
        JPanel setupPanel = new JPanel();
        setupPanel.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
        BoxLayout layout = new BoxLayout(setupPanel, 1);
        setupPanel.setLayout(layout);
        Dimension d = new Dimension(700, 520);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        dialog.setLocation((screenSize.width - d.width) / 2, (screenSize.height - d.height) / 2);
        dialog.setSize((int)d.getWidth(), (int)d.getHeight());
        if (OSUtils.isGoodWindows()) {
            this._setupWindowHolder.setPreferredSize(this.holderPreferredSize);
        }
        setupPanel.add(this._setupWindowHolder);
        setupPanel.add(Box.createVerticalStrut(17));
        JPanel bottomRow = new JPanel();
        bottomRow.setLayout(new BoxLayout(bottomRow, 0));
        ButtonRow buttons = new ButtonRow(this.actions, 0, 12);
        LanguagePanel languagePanel = new LanguagePanel(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SetupManager.this.updateLanguage();
            }
        });
        bottomRow.add(languagePanel);
        bottomRow.add(Box.createHorizontalGlue());
        bottomRow.add(buttons);
        bottomRow.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 10));
        setupPanel.add(new Line());
        setupPanel.add(bottomRow);
        this.show(firstWindow);
        container.add(setupPanel);
        if (!OSUtils.isGoodWindows()) {
            container.setPreferredSize(new Dimension(700, 520));
        }
        dialog.pack();
        SplashWindow.instance().setVisible(false);
        this.dialogFrame.showDialog();
        SplashWindow.instance().setVisible(true);
    }

    void enableActions(int actions) {
        this.previousAction.setEnabled((actions & 1) != 0);
        this.nextAction.setEnabled((actions & 2) != 0);
        this.finishAction.setEnabled((actions & 4) != 0);
        this.cancelAction.setEnabled((actions & 8) != 0);
    }

    public void next() {
        block2: {
            SetupWindow newWindow = this._currentWindow.getNext();
            try {
                this._currentWindow.applySettings(true);
                this.show(newWindow);
            }
            catch (ApplySettingsException ase) {
                if (ase.getMessage() == null || ase.getMessage().length() <= 0) break block2;
                GUIMediator.showError(ase.getMessage());
            }
        }
    }

    public void previous() {
        SetupWindow newWindow = this._currentWindow.getPrevious();
        try {
            this._currentWindow.applySettings(false);
        }
        catch (ApplySettingsException applySettingsException) {
            // empty catch block
        }
        this.show(newWindow);
    }

    private void cancelSetup() {
        this.dialogFrame.getDialog().dispose();
        System.exit(0);
    }

    private void finishSetup() {
        if (this._currentWindow != null) {
            try {
                this._currentWindow.applySettings(true);
            }
            catch (ApplySettingsException e) {
                if (e.getMessage() != null && e.getMessage().length() > 0) {
                    GUIMediator.showError(e.getMessage());
                }
                return;
            }
        }
        this.dialogFrame.getDialog().dispose();
        ApplicationSettings.INSTALLED.setValue(true);
        InstallSettings.SAVE_DIRECTORY.setValue(true);
        InstallSettings.SPEED.setValue(true);
        InstallSettings.SCAN_FILES.setValue(true);
        InstallSettings.LANGUAGE_CHOICE.setValue(true);
        InstallSettings.EXTENSION_OPTION.setValue(true);
        if (GUIUtils.shouldShowStartOnStartupWindow()) {
            InstallSettings.START_STARTUP.setValue(true);
        }
        if (OSUtils.isWindows()) {
            InstallSettings.FIREWALL_WARNING.setValue(true);
        }
        InstallSettings.ASSOCIATION_OPTION.setValue(2);
        InstallSettings.LAST_FROSTWIRE_VERSION_WIZARD_INVOKED.setValue(String.valueOf(FrostWireUtils.getBuildNumber()));
        Future<Void> future = BackgroundExecutorService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                SettingsGroupManager.instance().save();
                return null;
            }
        });
        if (this._currentWindow instanceof IntentWindow) {
            IntentWindow intent = (IntentWindow)this._currentWindow;
            if (!intent.isConfirmedWillNot()) {
                GUIMediator.showWarning("FrostWire is not distributed to people who intend to use it for the purposes of copyright infringement.\n\nThank you for your interest; however, you cannot continue to use FrostWire at this time.");
                try {
                    future.get();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.exit(1);
            }
            intent.applySettings(true);
            UXStats.instance().log(1);
        }
        this.dialogFrame.getDialog().dispose();
    }

    private void updateLanguage() {
        for (LanguageAwareAction action : this.actions) {
            action.updateLanguage();
        }
        try {
            this._currentWindow.applySettings(false);
        }
        catch (ApplySettingsException applySettingsException) {
            // empty catch block
        }
        this._currentWindow.handleWindowOpeningEvent();
    }

    private void show(SetupWindow window) {
        window.handleWindowOpeningEvent();
        this._setupWindowHolder.show(window.getKey());
        this._currentWindow = window;
    }

    void add(SetupWindow window) {
        this._setupWindowHolder.add((Component)window, window.getKey());
    }

    private class FinishAction
    extends LanguageAwareAction {
        FinishAction() {
            super(I18n.tr("Finish"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SetupManager.this.finishSetup();
        }
    }

    private class PreviousAction
    extends LanguageAwareAction {
        PreviousAction() {
            super(I18n.tr("<< Back"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SetupManager.this.previous();
        }
    }

    private class NextAction
    extends LanguageAwareAction {
        NextAction() {
            super(I18n.tr("Next >>"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SetupManager.this.next();
        }
    }

    private class CancelAction
    extends LanguageAwareAction {
        CancelAction() {
            super(I18n.tr("Cancel"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SetupManager.this.cancelSetup();
        }
    }

    private abstract class LanguageAwareAction
    extends AbstractAction {
        private final String nameKey;

        LanguageAwareAction(String nameKey) {
            super(I18n.tr(nameKey));
            this.nameKey = nameKey;
        }

        void updateLanguage() {
            this.putValue("Name", I18n.tr(this.nameKey));
        }
    }

    private static enum SaveStatus {
        NO,
        NEEDS;

    }
}

