/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.actions;

import com.frostwire.gui.bittorrent.CreateTorrentDialog;
import com.frostwire.gui.bittorrent.SendFileProgressDialog;
import com.frostwire.uxstats.UXStats;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.LimeTextField;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.TorrentFileFilter;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import com.limegroup.gnutella.gui.search.MagnetClipboardListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public final class FileMenuActions {
    static final int SPACE = 6;

    public static boolean openMagnetOrTorrent(String userText, ActionInvocationSource invokedFrom) {
        if (userText.startsWith("magnet:?xt=urn:btih")) {
            GUIMediator.instance().openTorrentURI(userText, true);
            UXStats.instance().log(invokedFrom == ActionInvocationSource.FROM_FILE_MENU ? 2008 : 2009);
            return true;
        }
        if (userText.matches(".*soundcloud.com.*")) {
            String soundCloudURL = userText.replace("soundcloud.com/#", "soundcloud.com/");
            GUIMediator.instance().openSoundcloudTrackUrl(soundCloudURL, null);
            UXStats.instance().log(invokedFrom == ActionInvocationSource.FROM_FILE_MENU ? 2004 : 2005);
            return true;
        }
        if (userText.startsWith("http://") || userText.startsWith("https://")) {
            GUIMediator.instance().openTorrentURI(userText, true);
            UXStats.instance().log(invokedFrom == ActionInvocationSource.FROM_FILE_MENU ? 2006 : 2007);
            return true;
        }
        File file = new File(userText);
        if (FileMenuActions.isFileSystemPath(file) && file.exists()) {
            GUIMediator.instance().openTorrentFile(file, true);
            return true;
        }
        return false;
    }

    private static boolean isFileSystemPath(File file) {
        return file.isAbsolute();
    }

    public static enum ActionInvocationSource {
        FROM_FILE_MENU,
        FROM_SEARCH_FIELD;

    }

    public static class SendFileAction
    extends AbstractAction {
        public SendFileAction() {
            super(I18n.tr("Send File or Folder..."));
            this.putValue("LongDescription", I18n.tr("Send a file or a folder to a friend"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SendFileProgressDialog dlg = new SendFileProgressDialog(GUIMediator.getAppFrame());
            dlg.setVisible(true);
            UXStats.instance().log(3003);
        }
    }

    public static class CreateTorrentAction
    extends AbstractAction {
        private static final long serialVersionUID = 1494672346951877693L;

        public CreateTorrentAction() {
            super(I18n.tr("Create New Torrent"));
            this.putValue("LongDescription", I18n.tr("Create a new .torrent file"));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            CreateTorrentDialog dlg = new CreateTorrentDialog(GUIMediator.getAppFrame());
            dlg.setVisible(true);
        }
    }

    public static class ExitAction
    extends AbstractAction {
        public ExitAction() {
            super(I18n.tr("E&xit"));
            this.putValue("LongDescription", I18n.tr("Close and exit the program"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GUIMediator.shutdown();
        }
    }

    public static class CloseAction
    extends AbstractAction {
        private static final long serialVersionUID = -456007457702576349L;

        public CloseAction() {
            super(I18n.tr("&Close"));
            this.putValue("LongDescription", I18n.tr("Close the program's main window"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GUIMediator.close(false);
        }
    }

    public static class OpenMagnetTorrentAction
    extends AbstractAction {
        private JDialog dialog = null;
        private LimeTextField PATH_FIELD = new LimeTextField(34);

        public OpenMagnetTorrentAction() {
            super(I18n.tr("O&pen .Torrent or Magnet"));
            this.putValue("LongDescription", I18n.tr("Opens a magnet link or torrent file"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.dialog == null) {
                this.createDialog();
            }
            this.PATH_FIELD.setText(MagnetClipboardListener.getMagnetOrTorrentURLFromClipboard());
            this.dialog.pack();
            GUIUtils.centerOnScreen(this.dialog);
            this.dialog.setVisible(true);
        }

        private void createDialog() {
            this.dialog = new JDialog(GUIMediator.getAppFrame(), I18n.tr("Download .Torrent or Magnet link"), true);
            this.dialog.addWindowListener(new OpenDialogWindowAdapter());
            JPanel panel = (JPanel)this.dialog.getContentPane();
            GUIUtils.addHideAction(panel);
            panel.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            panel.setBorder(new EmptyBorder(12, 6, 6, 6));
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.anchor = 10;
            constraints.insets = new Insets(0, 0, 12, 0);
            panel.add((Component)new JLabel(IconManager.instance().getIconForButton("SEARCH_DOWNLOAD")), constraints);
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 0;
            constraints.gridwidth = 0;
            constraints.gridheight = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.anchor = 18;
            constraints.fill = 2;
            constraints.insets = new Insets(0, 6, 12, 0);
            panel.add((Component)new MultiLineLabel(I18n.tr("Type a magnet link, the file path or web address of a torrent file and FrostWire will start downloading it for you."), true), constraints);
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 1;
            panel.add((Component)new JLabel(I18n.tr("Open:")), constraints);
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 1;
            constraints.fill = 2;
            constraints.weightx = 1.0;
            constraints.gridwidth = 0;
            constraints.insets = new Insets(0, 6, 0, 0);
            panel.add((Component)this.PATH_FIELD, constraints);
            ButtonRow row = new ButtonRow(new Action[]{new PasteAction(), new BrowseAction()}, 0, 12);
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 2;
            constraints.gridwidth = 0;
            constraints.insets = new Insets(6, 6, 0, 0);
            constraints.anchor = 17;
            panel.add((Component)row, constraints);
            constraints = new GridBagConstraints();
            constraints.fill = 1;
            constraints.gridx = 0;
            constraints.gridy = 3;
            constraints.gridwidth = 0;
            constraints.weighty = 1.0;
            panel.add((Component)new JPanel(), constraints);
            row = new ButtonRow(new Action[]{new OkAction(), new CancelAction()}, 0, 12);
            constraints = new GridBagConstraints();
            constraints.gridx = 4;
            constraints.gridy = 4;
            constraints.insets = new Insets(12, 0, 0, 0);
            constraints.anchor = 13;
            panel.add((Component)row, constraints);
            this.dialog.getRootPane().setDefaultButton(row.getButtonAtIndex(0));
            this.dialog.setMinimumSize(new Dimension(250, 150));
        }

        private void dismissDialog() {
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }

        private class CancelAction
        extends AbstractAction {
            private static final long serialVersionUID = 3350673081539434959L;

            public CancelAction() {
                super(I18n.tr("Cancel"));
            }

            @Override
            public void actionPerformed(ActionEvent a) {
                GUIUtils.getDisposeAction().actionPerformed(a);
            }
        }

        private class OkAction
        extends AbstractAction {
            public OkAction() {
                super(I18n.tr("OK"));
            }

            @Override
            public void actionPerformed(ActionEvent a) {
                String str = OpenMagnetTorrentAction.this.PATH_FIELD.getText();
                if (FileMenuActions.openMagnetOrTorrent(str, ActionInvocationSource.FROM_FILE_MENU)) {
                    OpenMagnetTorrentAction.this.dismissDialog();
                } else {
                    GUIMediator.showError(I18n.tr("FrostWire cannot download this address. Make sure you typed it correctly, and then try again."));
                }
            }
        }

        private class BrowseAction
        extends AbstractAction {
            private static final long serialVersionUID = 3000234847843826596L;

            public BrowseAction() {
                super(I18n.tr("Browse..."));
            }

            @Override
            public void actionPerformed(ActionEvent a) {
                File file = FileChooserHandler.getInputFile(GUIMediator.getAppFrame(), TorrentFileFilter.INSTANCE);
                if (file != null) {
                    OpenMagnetTorrentAction.this.PATH_FIELD.setText(file.getAbsolutePath());
                }
            }
        }

        private class PasteAction
        extends AbstractAction {
            private static final long serialVersionUID = -3351075105994389491L;

            public PasteAction() {
                super(I18n.tr("Paste"));
            }

            @Override
            public void actionPerformed(ActionEvent a) {
                OpenMagnetTorrentAction.this.PATH_FIELD.paste();
            }
        }

        private class OpenDialogWindowAdapter
        extends WindowAdapter {
            private OpenDialogWindowAdapter() {
            }

            @Override
            public void windowOpened(WindowEvent e) {
                OpenMagnetTorrentAction.this.PATH_FIELD.requestFocusInWindow();
            }
        }
    }
}

