/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.bittorrent.BTEngine;
import com.frostwire.jlibtorrent.EnumNet;
import java.util.List;
import org.limewire.util.OSUtils;

public final class VPNs {
    public static boolean isVPNActive() {
        boolean result = false;
        if (BTEngine.getInstance().swig() == null) {
            return false;
        }
        if (OSUtils.isMacOSX() || OSUtils.isLinux()) {
            result = VPNs.isPosixVPNActive();
        } else if (OSUtils.isWindows()) {
            result = VPNs.isWindowsVPNActive();
        }
        return result;
    }

    private static boolean isPosixVPNActive() {
        boolean result = false;
        try {
            List<EnumNet.IpRoute> routes = EnumNet.enumRoutes(BTEngine.getInstance());
            for (EnumNet.IpRoute route : routes) {
                if (!route.destination().toString().equals("0.0.0.0") || !route.name().contains("tun")) continue;
                result = true;
                break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    private static boolean isWindowsVPNActive() {
        try {
            List<EnumNet.IpInterface> interfaces = EnumNet.enumInterfaces(BTEngine.getInstance());
            List<EnumNet.IpRoute> routes = EnumNet.enumRoutes(BTEngine.getInstance());
            return VPNs.isWindowsVPNAdapterActive(interfaces, routes, "TAP-Windows Adapter") || VPNs.isWindowsVPNAdapterActive(interfaces, null, "ExpressVPN Tap Adapter") || VPNs.isWindowsVPNAdapterActive(interfaces, routes, "CactusVPN") || VPNs.isWindowsVPNAdapterActive(interfaces, routes, "TAP-NordVPN") || VPNs.isWindowsVPNAdapterActive(interfaces, routes, "AVG TAP") || VPNs.isWindowsVPNAdapterActive(interfaces, routes, "SecureLine TAP") || VPNs.isWindowsVPNAdapterActive(interfaces, null, "TAP-Windows Adapter V9") || VPNs.isWindowsVPNAdapterActive(interfaces, routes, "CyberGhost") || VPNs.isWindowsVPNAdapterActive(interfaces, routes, "Windscribe VPN") || VPNs.isWindowsVPNAdapterActive(interfaces, routes, "Windscribe IKEv2") || VPNs.isWindowsVPNAdapterActive(interfaces, routes, "PureVPN");
        }
        catch (Throwable t2) {
            t2.printStackTrace();
            return false;
        }
    }

    private static boolean isWindowsVPNAdapterActive(List<EnumNet.IpInterface> interfaces, List<EnumNet.IpRoute> routes, String description) {
        EnumNet.IpInterface adapter = null;
        for (EnumNet.IpInterface iface : interfaces) {
            if (!iface.description().contains(description) || !iface.preferred()) continue;
            adapter = iface;
            break;
        }
        if (adapter == null) {
            return false;
        }
        if (routes == null) {
            return true;
        }
        for (EnumNet.IpRoute route : routes) {
            if (!route.name().contains(adapter.name())) continue;
            return true;
        }
        return false;
    }
}

