/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.gui.mplayer.MPlayerWindow;
import com.frostwire.gui.player.MediaPlayer;
import com.limegroup.gnutella.gui.GUIMediator;

public class MPlayerMediator {
    private static MPlayerMediator instance;
    private final MPlayerWindow mplayerWindow = MPlayerWindow.createMPlayerWindow();

    private MPlayerMediator() {
    }

    public MPlayerWindow getMPlayerWindow() {
        return this.mplayerWindow;
    }

    public MediaPlayer getMediaPlayer() {
        if (this.mplayerWindow == null) {
            return null;
        }
        return this.mplayerWindow.getMediaPlayer();
    }

    public static MPlayerMediator instance() {
        if (instance == null) {
            try {
                GUIMediator.safeInvokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        instance = new MPlayerMediator();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return instance;
    }

    public long getCanvasComponentHwnd() {
        return this.mplayerWindow.getCanvasComponentHwnd();
    }

    public void showPlayerWindow(final boolean visible) {
        try {
            GUIMediator.safeInvokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (MPlayerMediator.this.mplayerWindow != null) {
                        MPlayerMediator.this.mplayerWindow.setVisible(visible);
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void toggleFullScreen() {
        try {
            GUIMediator.safeInvokeAndWait(new Runnable(){

                @Override
                public void run() {
                    MPlayerMediator.this.mplayerWindow.toggleFullScreen();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

