/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.player.MediaPlayerComponent;
import com.frostwire.gui.searchfield.GoogleSearchField;
import com.frostwire.gui.searchfield.SearchField;
import com.frostwire.gui.tabs.LibraryTab;
import com.frostwire.gui.tabs.Tab;
import com.frostwire.gui.theme.SkinApplicationHeaderUI;
import com.frostwire.gui.theme.ThemeMediator;
import com.frostwire.gui.updates.UpdateMediator;
import com.frostwire.uxstats.UXStats;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LogoPanel;
import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.gui.actions.FileMenuActions;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.util.URLDecoder;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.BadLocationException;
import net.miginfocom.swing.MigLayout;

public final class ApplicationHeader
extends JPanel
implements RefreshListener {
    private static final String SELECTED_ICON = "SELECTED_ICON";
    private static final String DESELECTED_ICON = "DESELECTED_ICON";
    private static final String CLOUD_SEARCH_FIELD = "cloud_search_field";
    private static final String LIBRARY_SEARCH_FIELD = "library_search_field";
    private static final String CLOUD_SEARCH_FIELD_HINT_TEXT = I18n.tr("Search or enter a cloud sourced URL");
    private final MouseListener CLICK_FORWARDER = new Clicker();
    private final Image headerButtonBackgroundSelected;
    private final Image headerButtonBackgroundUnselected;
    private LogoPanel logoPanel;
    private JLabel updateButton;
    private ImageIcon updateImageButtonOn;
    private ImageIcon updateImageButtonOff;
    private long updateButtonAnimationStartedTimestamp;
    private final GoogleSearchField cloudSearchField;
    private SearchField librarySearchField;
    private final JPanel searchPanels;

    ApplicationHeader(Map<GUIMediator.Tabs, Tab> tabs) {
        this.setMinimumSize(new Dimension(1000, 54));
        this.setLayout(new MigLayout("ins 0, ay 50%, filly,", "[][][grow][][]"));
        this.headerButtonBackgroundSelected = GUIMediator.getThemeImage("selected_header_button_background").getImage();
        this.headerButtonBackgroundUnselected = GUIMediator.getThemeImage("unselected_header_button_background").getImage();
        this.cloudSearchField = new GoogleSearchField(){
            {
                super.getFindButton().addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        UXStats.instance().log(1002);
                    }
                });
            }

            @Override
            public void processKeyEvent(KeyEvent evt) {
                if (evt.getID() == 401 && evt.getKeyCode() == 10) {
                    UXStats.instance().log(1001);
                }
                super.processKeyEvent(evt);
            }
        };
        this.searchPanels = this.createSearchPanel();
        this.add((Component)this.searchPanels, "wmin 240px, wmax 370px, growprio 50, growx, gapright 10px, gapleft 5px");
        this.addTabButtons(tabs);
        this.createUpdateButton();
        JPanel logoUpdateButtonsPanel = new JPanel();
        this.logoPanel = new LogoPanel();
        logoUpdateButtonsPanel.add(this.logoPanel);
        logoUpdateButtonsPanel.add(this.updateButton);
        this.add((Component)logoUpdateButtonsPanel, "growx, alignx center");
        JPanel player = new MediaPlayerComponent().getMediaPanel();
        this.add((Component)player, "dock east, growy, gapafter 10px!");
        GUIMediator.addRefreshListener(this);
        SchemaListener schemaListener = new SchemaListener();
        schemaListener.actionPerformed(null);
    }

    private JPanel createSearchPanel() {
        JPanel panel = new JPanel(new CardLayout());
        this.initCloudSearchField();
        this.createLibrarySearchField();
        panel.add((Component)this.cloudSearchField, CLOUD_SEARCH_FIELD);
        panel.add((Component)this.librarySearchField, LIBRARY_SEARCH_FIELD);
        return panel;
    }

    private void createLibrarySearchField() {
        this.librarySearchField = LibraryMediator.instance().getLibrarySearch().getSearchField();
    }

    private void initCloudSearchField() {
        this.cloudSearchField.addActionListener(new SearchListener());
        this.cloudSearchField.setPrompt(CLOUD_SEARCH_FIELD_HINT_TEXT);
        this.cloudSearchField.setText(CLOUD_SEARCH_FIELD_HINT_TEXT);
        this.cloudSearchField.selectAll();
        this.cloudSearchField.requestFocus();
        Font origFont = this.cloudSearchField.getFont();
        Font newFont = origFont.deriveFont(origFont.getSize2D() + 2.0f);
        this.cloudSearchField.setFont(newFont);
        this.cloudSearchField.setMargin(new Insets(0, 2, 0, 0));
        this.cloudSearchField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ApplicationHeader.this.cloudSearchField.getText().equals(CLOUD_SEARCH_FIELD_HINT_TEXT)) {
                    ApplicationHeader.this.cloudSearchField.setText("");
                }
            }
        });
    }

    private void createUpdateButton() {
        this.updateImageButtonOn = GUIMediator.getThemeImage("update_button_on");
        this.updateImageButtonOff = GUIMediator.getThemeImage("update_button_off");
        this.updateButton = new JLabel(this.updateImageButtonOn);
        this.updateButton.setToolTipText(I18n.tr("A new update has been downloaded."));
        Dimension d = new Dimension(32, 32);
        this.updateButton.setVisible(false);
        this.updateButton.setSize(d);
        this.updateButton.setPreferredSize(d);
        this.updateButton.setMinimumSize(d);
        this.updateButton.setMaximumSize(d);
        this.updateButton.setBorder(null);
        this.updateButton.setOpaque(false);
        this.updateButtonAnimationStartedTimestamp = -1L;
        this.updateButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                UpdateMediator.instance().showUpdateMessage();
            }
        });
    }

    private void addTabButtons(final Map<GUIMediator.Tabs, Tab> tabs) {
        JPanel buttonContainer = new JPanel(new MigLayout("insets 0, gap 0"));
        ButtonGroup group = new ButtonGroup();
        Font buttonFont = new Font("Helvetica", 1, 10);
        buttonContainer.add((Component)ThemeMediator.createAppHeaderSeparator(), "growy");
        GUIMediator.Tabs[] tabsArray = GUIMediator.Tabs.values();
        int n = tabsArray.length;
        for (int i = 0; i < n; ++i) {
            GUIMediator.Tabs t;
            final GUIMediator.Tabs finalTab = t = tabsArray[i];
            if (tabs.get((Object)t) == null || !t.isEnabled()) continue;
            AbstractButton button = this.createTabButton(tabs.get((Object)t));
            button.setFont(buttonFont);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.onMainApplicationHeaderTabActionPerformed(tabs, finalTab);
                }

                private void onMainApplicationHeaderTabActionPerformed(Map<GUIMediator.Tabs, Tab> tabs2, GUIMediator.Tabs tab) {
                    this.prepareSearchTabAsSearchTrigger(tab);
                    ApplicationHeader.this.showSearchField(tabs2.get((Object)tab));
                    GUIMediator.instance().setWindow(tab);
                }

                void prepareSearchTabAsSearchTrigger(GUIMediator.Tabs tab) {
                    String query = null;
                    if (tab == GUIMediator.Tabs.SEARCH || tab == GUIMediator.Tabs.SEARCH_TRANSFERS) {
                        if (!ApplicationHeader.this.cloudSearchField.getText().isEmpty()) {
                            if (ApplicationHeader.this.cloudSearchField.getText().equals(CLOUD_SEARCH_FIELD_HINT_TEXT)) {
                                ApplicationHeader.this.cloudSearchField.setText("");
                            }
                            query = ApplicationHeader.this.cloudSearchField.getText();
                        } else if (ApplicationHeader.this.cloudSearchField.getText().isEmpty() && !ApplicationHeader.this.librarySearchField.getText().isEmpty()) {
                            query = ApplicationHeader.this.librarySearchField.getText();
                            ApplicationHeader.this.librarySearchField.setText("");
                            ApplicationHeader.this.cloudSearchField.setText(query);
                        }
                        if (query != null) {
                            UXStats.instance().log(1003);
                            ApplicationHeader.this.cloudSearchField.getActionListeners()[0].actionPerformed(null);
                        }
                    }
                }
            });
            group.add(button);
            buttonContainer.add(button);
            buttonContainer.add((Component)ThemeMediator.createAppHeaderSeparator(), "growy, w 0px");
            button.setSelected(t.equals((Object)GUIMediator.Tabs.SEARCH));
        }
        this.add((Component)buttonContainer, "");
    }

    void selectTab(Tab t) {
        Component[] buttons;
        Component[] components = this.getComponents();
        JPanel buttonContainer = (JPanel)components[1];
        for (Component c : buttons = buttonContainer.getComponents()) {
            AbstractButton b;
            if (!(c instanceof AbstractButton) || !(b = (AbstractButton)c).getClientProperty("tab").equals(t)) continue;
            b.setSelected(true);
            return;
        }
    }

    private AbstractButton createTabButton(Tab t) {
        Icon icon = t.getIcon();
        Icon disabledIcon = null;
        Icon rolloverIcon = null;
        JRadioButton button = new JRadioButton(I18n.tr(t.getTitle())){

            @Override
            protected void paintComponent(Graphics g) {
                if (this.isSelected()) {
                    g.drawImage(ApplicationHeader.this.headerButtonBackgroundSelected, 0, 0, null);
                } else {
                    g.drawImage(ApplicationHeader.this.headerButtonBackgroundUnselected, 0, 0, null);
                }
                super.paintComponent(g);
            }
        };
        button.putClientProperty("tab", t);
        button.putClientProperty(SELECTED_ICON, icon);
        if (icon != null) {
            disabledIcon = icon;
            rolloverIcon = icon;
        }
        button.putClientProperty(DESELECTED_ICON, disabledIcon);
        button.setIcon(disabledIcon);
        button.setPressedIcon(rolloverIcon);
        button.setSelectedIcon(disabledIcon);
        button.setRolloverIcon(rolloverIcon);
        button.setRolloverSelectedIcon(rolloverIcon);
        button.setBorderPainted(false);
        button.setFocusPainted(false);
        button.setContentAreaFilled(false);
        button.setOpaque(false);
        button.addMouseListener(this.CLICK_FORWARDER);
        button.setToolTipText(t.getToolTip());
        button.setHorizontalTextPosition(0);
        button.setVerticalTextPosition(3);
        button.setHorizontalAlignment(0);
        button.setForeground(ThemeMediator.TAB_BUTTON_FOREGROUND_COLOR);
        Dimension buttonDim = new Dimension(65, 55);
        button.setPreferredSize(buttonDim);
        button.setMinimumSize(buttonDim);
        button.setMaximumSize(buttonDim);
        button.setSelected(false);
        return button;
    }

    void showSearchField(Tab t) {
        this.cloudSearchField.setText("");
        this.librarySearchField.setText("");
        CardLayout cl = (CardLayout)this.searchPanels.getLayout();
        if (t instanceof LibraryTab) {
            cl.show(this.searchPanels, LIBRARY_SEARCH_FIELD);
        } else {
            cl.show(this.searchPanels, CLOUD_SEARCH_FIELD);
        }
    }

    @Override
    public void refresh() {
        this.showUpdateButton(!UpdateMediator.instance().isUpdated() && UpdateMediator.instance().isUpdateDownloaded());
    }

    private void showUpdateButton(boolean show) {
        if (this.updateButton.isVisible() == show) {
            return;
        }
        this.logoPanel.setVisible(!show);
        this.updateButton.setVisible(show);
        if (show && this.updateButtonAnimationStartedTimestamp == -1L) {
            this.startUpdateButtonIntermittentAnimation();
        }
    }

    private void startUpdateButtonIntermittentAnimation() {
        this.updateButtonAnimationStartedTimestamp = System.currentTimeMillis();
        Thread t = new Thread("update-button-animation"){
            private final long ANIMATION_DURATION = 30000L;
            private final long ANIMATION_INTERVAL = 1000L;
            private long updateButtonAnimationLastChange;
            {
                this.ANIMATION_DURATION = 30000L;
                this.ANIMATION_INTERVAL = 1000L;
            }

            @Override
            public void run() {
                long now;
                this.updateButtonAnimationLastChange = now = System.currentTimeMillis();
                boolean buttonState = true;
                while (now - ApplicationHeader.this.updateButtonAnimationStartedTimestamp < 30000L) {
                    if (now - this.updateButtonAnimationLastChange >= 1000L) {
                        this.switchButtonImage(buttonState);
                        buttonState = !buttonState;
                    }
                    try {
                        6.sleep(1000L);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    now = System.currentTimeMillis();
                }
                this.switchButtonImage(false);
            }

            void switchButtonImage(final boolean state) {
                this.updateButtonAnimationLastChange = System.currentTimeMillis();
                GUIMediator.safeInvokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ApplicationHeader.this.updateButton.setIcon(state ? ApplicationHeader.this.updateImageButtonOn : ApplicationHeader.this.updateImageButtonOff);
                    }
                });
            }
        };
        t.start();
    }

    @Override
    public void updateUI() {
        ComponentUI ui = UIManager.getUI(this);
        if (ui == null) {
            ui = new SkinApplicationHeaderUI();
        }
        this.setUI(ui);
    }

    @Override
    public String getUIClassID() {
        return "ApplicationHeaderUI";
    }

    private void requestSearchFocusImmediately() {
        if (this.cloudSearchField != null) {
            this.cloudSearchField.setPrompt(CLOUD_SEARCH_FIELD_HINT_TEXT);
            this.cloudSearchField.setText(CLOUD_SEARCH_FIELD_HINT_TEXT);
            this.cloudSearchField.selectAll();
            this.cloudSearchField.requestFocus();
        }
    }

    public void requestSearchFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ApplicationHeader.this.requestSearchFocusImmediately();
            }
        });
    }

    void startSearch(String query) {
        this.cloudSearchField.setText(query);
        this.cloudSearchField.getActionListeners()[0].actionPerformed(null);
    }

    private class SchemaListener
    implements ActionListener {
        private SchemaListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            SearchSettings.MAX_QUERY_LENGTH.revertToDefault();
            if (ApplicationHeader.this.cloudSearchField.getText().length() > SearchSettings.MAX_QUERY_LENGTH.getValue()) {
                try {
                    ApplicationHeader.this.cloudSearchField.setText(ApplicationHeader.this.cloudSearchField.getText(0, SearchSettings.MAX_QUERY_LENGTH.getValue()));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            ApplicationHeader.this.requestSearchFocus();
        }
    }

    private class SearchListener
    implements ActionListener {
        private SearchListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String query;
            String queryTitle = query = ApplicationHeader.this.cloudSearchField.getText();
            GUIMediator.instance().setWindow(GUIMediator.Tabs.SEARCH);
            if (FileMenuActions.openMagnetOrTorrent(query, FileMenuActions.ActionInvocationSource.FROM_SEARCH_FIELD)) {
                ApplicationHeader.this.cloudSearchField.setText("");
                ApplicationHeader.this.cloudSearchField.hidePopup();
                return;
            }
            if (query.contains("www.frostclick.com/cloudplayer/?type=yt") || query.contains("frostwire-preview.com/?type=yt")) {
                try {
                    query = query.split("detailsUrl=")[1];
                    query = URLDecoder.decode(query);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            SearchInformation info = SearchInformation.createTitledKeywordSearch(query, null, MediaType.getTorrentMediaType(), queryTitle);
            if (SearchMediator.instance().triggerSearch(info) != 0L && info.isKeywordSearch()) {
                ApplicationHeader.this.cloudSearchField.addToDictionary();
                ApplicationHeader.this.cloudSearchField.setText("");
                ApplicationHeader.this.cloudSearchField.hidePopup();
            }
        }
    }

    private static class Clicker
    extends MouseAdapter {
        private Clicker() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JComponent c = (JComponent)e.getSource();
            if (!(c instanceof AbstractButton)) {
                AbstractButton b = (AbstractButton)c.getComponent(0);
                b.doClick();
            }
        }
    }
}

