/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.uxstats;

import com.frostwire.util.HttpClientFactory;
import com.frostwire.util.JsonUtils;
import com.frostwire.util.Logger;
import com.frostwire.util.http.HttpClient;
import com.frostwire.uxstats.UXAction;
import com.frostwire.uxstats.UXData;
import com.frostwire.uxstats.UXStats3rdPartyAPI;
import com.frostwire.uxstats.UXStatsConf;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;

public final class UXStats {
    private static final boolean IS_TESTING = false;
    private static final Logger LOG = Logger.getLogger(UXStats.class);
    private static final int HTTP_TIMEOUT = 4000;
    private final HttpClient httpClient;
    private final List<UXStats3rdPartyAPI> uxStatsAPIs = new ArrayList<UXStats3rdPartyAPI>();
    private ExecutorService executor = null;
    private UXStatsConf conf = null;
    private UXData data = null;
    private static final UXStats instance = new UXStats();

    public static UXStats instance() {
        return instance;
    }

    private UXStats() {
        this.httpClient = HttpClientFactory.getInstance(HttpClientFactory.HttpContext.MISC);
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public UXStatsConf getContext() {
        return this.conf;
    }

    public void setContext(UXStatsConf conf) {
        this.conf = conf;
        this.data = conf != null ? this.newData() : null;
    }

    public void add3rdPartyAPI(UXStats3rdPartyAPI api) {
        if (api != null) {
            this.uxStatsAPIs.add(api);
        }
    }

    public void log(int action) {
        try {
            if (this.conf != null && this.data != null) {
                if (this.data.actions.size() < this.conf.getMaxEntries()) {
                    this.data.actions.add(new UXAction(action, System.currentTimeMillis()));
                }
                if (this.isReadyToSend()) {
                    this.sendData();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void flush() {
        this.flush(false);
    }

    public void flush(boolean endSession) {
        try {
            if (this.conf != null && this.data != null) {
                this.sendData();
            }
            if (endSession && !this.uxStatsAPIs.isEmpty()) {
                for (UXStats3rdPartyAPI api : this.uxStatsAPIs) {
                    try {
                        api.endSession();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean isReadyToSend() {
        return this.data.actions.size() >= this.conf.getMinEntries() && System.currentTimeMillis() - this.data.time > (long)(this.conf.getPeriod() * 1000);
    }

    private void sendData() {
        SendDataRunnable r = new SendDataRunnable(this.data);
        this.data = this.newData();
        if (this.executor != null) {
            this.executor.execute(r);
        } else {
            new Thread((Runnable)r, "UXStats-sendData").start();
        }
    }

    private UXData newData() {
        return new UXData(this.conf.getGuid(), this.conf.getOS(), this.conf.getFwversion(), this.conf.getFwbuild());
    }

    private final class SendDataRunnable
    implements Runnable {
        private final UXData data;

        public SendDataRunnable(UXData data) {
            this.data = data;
        }

        @Override
        public void run() {
            try {
                String json = JsonUtils.toJson(this.data);
                String postURL = UXStats.this.conf.getUrl();
                UXStats.this.httpClient.post(postURL, 4000, "FrostWire/UXStats", json, true);
            }
            catch (Throwable e) {
                LOG.error("Unable to send ux stats", e);
            }
        }
    }
}

