/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.util.http;

import com.frostwire.util.Logger;
import com.frostwire.util.Ssl;
import com.frostwire.util.http.AbstractHttpClient;
import com.frostwire.util.http.ByteArrayBuffer;
import com.frostwire.util.http.HttpClient;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;

public final class JdkHttpClient
extends AbstractHttpClient {
    private static final Logger LOG = Logger.getLogger(JdkHttpClient.class);

    @Override
    public int head(String url, int connectTimeoutInMillis, Map<String, List<String>> outputHeaders) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setConnectTimeout(connectTimeoutInMillis);
        connection.setReadTimeout(connectTimeoutInMillis);
        connection.setRequestMethod("HEAD");
        JdkHttpClient.copyMultiMap(connection.getHeaderFields(), outputHeaders);
        return connection.getResponseCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(String url, int timeout, String userAgent, String referrer, String cookies) {
        byte[] result = null;
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            this.get(url, baos, timeout, userAgent, referrer, cookies, -1L);
            result = baos.toByteArray();
        }
        catch (Throwable e) {
            LOG.error("Error getting bytes from http body response: " + e.getMessage(), e);
        }
        finally {
            JdkHttpClient.closeQuietly(baos);
        }
        return result;
    }

    @Override
    public String get(String url, int timeout, String userAgent, String referrer, String cookie, Map<String, String> customHeaders) throws IOException {
        String result = null;
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            this.get(url, baos, timeout, userAgent, referrer, cookie, -1L, -1L, customHeaders);
            result = new String(baos.toByteArray(), "UTF-8");
        }
        catch (SocketTimeoutException timeoutException) {
            throw timeoutException;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            JdkHttpClient.closeQuietly(baos);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(String url, File file, boolean resume, int timeout, String userAgent, String referrer) throws IOException {
        FileOutputStream fos = null;
        try {
            long rangeStart;
            if (resume && file.exists()) {
                fos = new FileOutputStream(file, true);
                rangeStart = file.length();
            } else {
                fos = new FileOutputStream(file, false);
                rangeStart = -1L;
            }
            this.get(url, fos, timeout, userAgent, null, referrer, rangeStart);
        }
        catch (Throwable throwable) {
            JdkHttpClient.closeQuietly(fos);
            throw throwable;
        }
        JdkHttpClient.closeQuietly(fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String post(String url, int timeout, String userAgent, Map<String, String> formData) {
        String result = null;
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            this.post(url, baos, timeout, userAgent, formData);
            result = new String(baos.toByteArray(), "UTF-8");
        }
        catch (Throwable e) {
            LOG.error("Error posting data via http: " + e.getMessage(), e);
        }
        finally {
            JdkHttpClient.closeQuietly(baos);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String post(String url, int timeout, String userAgent, String content, String postContentType, boolean gzip) throws IOException {
        String result = null;
        this.canceled = false;
        URL u = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)u.openConnection();
        conn.setDoOutput(true);
        conn.setConnectTimeout(timeout);
        conn.setReadTimeout(timeout);
        conn.setRequestProperty("User-Agent", userAgent);
        conn.setInstanceFollowRedirects(false);
        if (conn instanceof HttpsURLConnection) {
            this.setHostnameVerifier((HttpsURLConnection)conn);
        }
        byte[] data = content.getBytes("UTF-8");
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", postContentType);
        conn.setRequestProperty("charset", "utf-8");
        conn.setUseCaches(false);
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        try {
            int n;
            OutputStream out = gzip ? new GZIPOutputStream(conn.getOutputStream()) : conn.getOutputStream();
            byte[] b = new byte[4096];
            while (!this.canceled && (n = in.read(b, 0, b.length)) != -1) {
                if (this.canceled) continue;
                out.write(b, 0, n);
                out.flush();
                this.onData(b, 0, n);
            }
            JdkHttpClient.closeQuietly(out);
            conn.connect();
            int httpResponseCode = this.getResponseCode(conn);
            if (httpResponseCode != 200 && httpResponseCode != 206) {
                throw new HttpClient.ResponseCodeNotSupportedException(httpResponseCode);
            }
            if (this.canceled) {
                this.onCancel();
            } else {
                int read;
                BufferedInputStream bis = new BufferedInputStream(conn.getInputStream(), 4096);
                ByteArrayBuffer baf = new ByteArrayBuffer(1024);
                byte[] buffer = new byte[64];
                while ((read = bis.read(buffer)) != -1) {
                    baf.append(buffer, 0, read);
                }
                result = new String(baf.toByteArray());
                this.onComplete();
            }
        }
        catch (Exception e) {
            this.onError(e);
        }
        finally {
            JdkHttpClient.closeQuietly(in);
            this.closeQuietly(conn);
        }
        return result;
    }

    private String buildRange(long rangeStart, long rangeLength) {
        String prefix = "bytes=" + rangeStart + "-";
        return prefix + (rangeLength > -1L ? Long.valueOf(rangeStart + rangeLength) : "");
    }

    private void checkRangeSupport(long rangeStart, URLConnection conn) throws HttpClient.HttpRangeOutOfBoundsException, HttpClient.RangeNotSupportedException {
        boolean hasAcceptRanges;
        boolean hasContentRange = conn.getHeaderField("Content-Range") != null;
        boolean bl = hasAcceptRanges = conn.getHeaderField("Accept-Ranges") != null && conn.getHeaderField("Accept-Ranges").equals("bytes");
        if (rangeStart > 0L && !hasContentRange && !hasAcceptRanges) {
            HttpClient.RangeNotSupportedException rangeNotSupportedException = new HttpClient.RangeNotSupportedException("Server does not support bytes range request");
            this.onError(rangeNotSupportedException);
            throw rangeNotSupportedException;
        }
    }

    private void get(String url, OutputStream out, int timeout, String userAgent, String referrer, String cookie, long rangeStart) throws IOException {
        this.get(url, out, timeout, userAgent, referrer, cookie, rangeStart, -1L, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void get(String url, OutputStream out, int timeout, String userAgent, String referrer, String cookie, long rangeStart, long rangeLength, Map<String, String> customHeaders) throws IOException {
        int httpResponseCode;
        this.canceled = false;
        URL u = new URL(url);
        URLConnection conn = u.openConnection();
        conn.setConnectTimeout(timeout);
        conn.setReadTimeout(timeout);
        if (userAgent != null) {
            conn.setRequestProperty("User-Agent", userAgent);
        } else {
            conn.setRequestProperty("User-Agent", DEFAULT_USER_AGENT);
        }
        if (referrer != null) {
            conn.setRequestProperty("Referer", referrer);
        }
        if (cookie != null) {
            conn.setRequestProperty("Cookie", cookie);
        }
        if (conn instanceof HttpURLConnection) {
            ((HttpURLConnection)conn).setInstanceFollowRedirects(true);
        }
        if (conn instanceof HttpsURLConnection) {
            this.setHostnameVerifier((HttpsURLConnection)conn);
        }
        if (rangeStart > 0L) {
            conn.setRequestProperty("Range", this.buildRange(rangeStart, rangeLength));
        }
        if (customHeaders != null && customHeaders.size() > 0) {
            this.setCustomHeaders(conn, customHeaders);
        }
        InputStream in = conn.getInputStream();
        if ("gzip".equals(conn.getContentEncoding())) {
            in = new GZIPInputStream(in);
        }
        if ((httpResponseCode = this.getResponseCode(conn)) != 200 && httpResponseCode != 206 && httpResponseCode != 302 && httpResponseCode != 301) {
            throw new HttpClient.ResponseCodeNotSupportedException(httpResponseCode);
        }
        this.onHeaders(conn.getHeaderFields());
        this.checkRangeSupport(rangeStart, conn);
        try {
            int n;
            byte[] b = new byte[4096];
            while (!this.canceled && (n = in.read(b, 0, b.length)) != -1) {
                if (this.canceled) continue;
                out.write(b, 0, n);
                this.onData(b, 0, n);
            }
            JdkHttpClient.closeQuietly(out);
            if (this.canceled) {
                this.onCancel();
            } else {
                this.onComplete();
            }
        }
        catch (Exception e) {
            this.onError(e);
        }
        finally {
            JdkHttpClient.closeQuietly(in);
            this.closeQuietly(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void post(String url, OutputStream out, int timeout, String userAgent, Map<String, String> formData) throws IOException {
        this.canceled = false;
        URL u = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)u.openConnection();
        conn.setDoOutput(true);
        conn.setConnectTimeout(timeout);
        conn.setReadTimeout(timeout);
        conn.setRequestProperty("User-Agent", userAgent);
        conn.setInstanceFollowRedirects(false);
        if (conn instanceof HttpsURLConnection) {
            this.setHostnameVerifier((HttpsURLConnection)conn);
        }
        byte[] data = this.getFormDataBytes(formData);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.setRequestProperty("charset", "utf-8");
        conn.setUseCaches(false);
        InputStream in = new ByteArrayInputStream(data);
        try {
            int n;
            OutputStream postOut = conn.getOutputStream();
            byte[] b = new byte[4096];
            while (!this.canceled && (n = in.read(b, 0, b.length)) != -1) {
                if (this.canceled) continue;
                postOut.write(b, 0, n);
                postOut.flush();
                this.onData(b, 0, n);
            }
            JdkHttpClient.closeQuietly(postOut);
            JdkHttpClient.closeQuietly(in);
            conn.connect();
            in = conn.getInputStream();
            int httpResponseCode = this.getResponseCode(conn);
            if (httpResponseCode != 200 && httpResponseCode != 206 && httpResponseCode != 302 && httpResponseCode != 301) {
                throw new HttpClient.ResponseCodeNotSupportedException(httpResponseCode);
            }
            b = new byte[4096];
            while (!this.canceled && (n = in.read(b, 0, b.length)) != -1) {
                if (this.canceled) continue;
                out.write(b, 0, n);
                this.onData(b, 0, n);
            }
            JdkHttpClient.closeQuietly(out);
            if (this.canceled) {
                this.onCancel();
            } else {
                this.onComplete();
            }
        }
        catch (Exception e) {
            this.onError(e);
        }
        finally {
            JdkHttpClient.closeQuietly(in);
            this.closeQuietly(conn);
        }
    }

    private void setCustomHeaders(URLConnection conn, Map<String, String> headers) {
        for (Map.Entry<String, String> e : headers.entrySet()) {
            conn.setRequestProperty(e.getKey(), e.getValue());
        }
    }

    private void setHostnameVerifier(HttpsURLConnection conn) {
        conn.setHostnameVerifier(Ssl.nullHostnameVerifier());
        conn.setSSLSocketFactory(Ssl.nullSocketFactory());
    }

    private int getResponseCode(URLConnection conn) {
        try {
            return ((HttpURLConnection)conn).getResponseCode();
        }
        catch (Throwable e) {
            e.printStackTrace();
            LOG.error("can't get response code ", e);
            return -1;
        }
    }

    private void onHeaders(Map<String, List<String>> headerFields) {
        if (this.getListener() != null) {
            try {
                this.getListener().onHeaders(this, headerFields);
            }
            catch (Exception e) {
                LOG.warn(e.getMessage(), e);
            }
        }
    }

    @Override
    public void onCancel() {
        if (this.getListener() != null) {
            try {
                this.getListener().onCancel(this);
            }
            catch (Exception e) {
                LOG.warn(e.getMessage(), e);
            }
        }
    }

    @Override
    public void onData(byte[] b, int i, int n) {
        if (this.getListener() != null) {
            try {
                this.getListener().onData(this, b, 0, n);
            }
            catch (Exception e) {
                LOG.warn(e.getMessage(), e);
            }
        }
    }

    @Override
    public void onError(Exception e) {
        if (this.getListener() != null) {
            try {
                this.getListener().onError(this, e);
            }
            catch (Exception e2) {
                LOG.warn(e2.getMessage());
            }
        } else {
            e.printStackTrace();
        }
    }

    @Override
    public void onComplete() {
        if (this.getListener() != null) {
            try {
                this.getListener().onComplete(this);
            }
            catch (Exception e) {
                LOG.warn(e.getMessage(), e);
            }
        }
    }

    private void closeQuietly(URLConnection conn) {
        if (conn instanceof HttpURLConnection) {
            try {
                ((HttpURLConnection)conn).disconnect();
            }
            catch (Throwable e) {
                LOG.debug("Error closing http connection", e);
            }
        }
    }
}

