/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.util.http;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public interface HttpClient {
    public void setListener(HttpClientListener var1);

    public HttpClientListener getListener();

    public void onCancel();

    public void onData(byte[] var1, int var2, int var3);

    public void onError(Exception var1);

    public void onComplete();

    public int head(String var1, int var2, Map<String, List<String>> var3) throws IOException;

    public String get(String var1) throws IOException;

    public String get(String var1, int var2) throws IOException;

    public String get(String var1, int var2, String var3) throws IOException;

    public String get(String var1, int var2, String var3, String var4, String var5) throws IOException;

    public String get(String var1, int var2, String var3, String var4, String var5, Map<String, String> var6) throws IOException;

    public byte[] getBytes(String var1);

    public byte[] getBytes(String var1, int var2);

    public byte[] getBytes(String var1, int var2, String var3);

    public byte[] getBytes(String var1, int var2, String var3, String var4);

    public byte[] getBytes(String var1, int var2, String var3, String var4, String var5);

    public void save(String var1, File var2) throws IOException;

    public void save(String var1, File var2, boolean var3) throws IOException;

    public void save(String var1, File var2, boolean var3, int var4, String var5) throws IOException;

    public void save(String var1, File var2, boolean var3, int var4, String var5, String var6) throws IOException;

    public String post(String var1, int var2, String var3, Map<String, String> var4) throws IOException;

    public String post(String var1, int var2, String var3, String var4, boolean var5) throws IOException;

    public String post(String var1, int var2, String var3, String var4, String var5, boolean var6) throws IOException;

    public void cancel();

    public boolean isCanceled();

    public static final class ResponseCodeNotSupportedException
    extends IOException {
        private final int responseCode;

        ResponseCodeNotSupportedException(int code) {
            this.responseCode = code;
        }

        int getResponseCode() {
            return this.responseCode;
        }
    }

    public static final class HttpRangeOutOfBoundsException
    extends HttpRangeException {
        private static final long serialVersionUID = -335661829606230147L;

        HttpRangeOutOfBoundsException(int rangeStart, long expectedFileSize) {
            super("HttpRange Out of Bounds error: start=" + rangeStart + " expected file size=" + expectedFileSize);
        }
    }

    public static final class RangeNotSupportedException
    extends HttpRangeException {
        private static final long serialVersionUID = -3356618211960630147L;

        RangeNotSupportedException(String message) {
            super(message);
        }
    }

    public static class HttpRangeException
    extends IOException {
        private static final long serialVersionUID = 1891038288667531894L;

        HttpRangeException(String message) {
            super(message);
        }
    }

    public static abstract class HttpClientListenerAdapter
    implements HttpClientListener {
        @Override
        public void onError(HttpClient client, Throwable e) {
        }

        @Override
        public void onData(HttpClient client, byte[] buffer, int offset, int length) {
        }

        @Override
        public void onComplete(HttpClient client) {
        }

        @Override
        public void onCancel(HttpClient client) {
        }

        @Override
        public void onHeaders(HttpClient httpClient, Map<String, List<String>> headerFields) {
        }
    }

    public static interface HttpClientListener {
        public void onError(HttpClient var1, Throwable var2);

        public void onData(HttpClient var1, byte[] var2, int var3, int var4);

        public void onComplete(HttpClient var1);

        public void onCancel(HttpClient var1);

        public void onHeaders(HttpClient var1, Map<String, List<String>> var2);
    }
}

