/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.util;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

public class StringUtils {
    public static final boolean contains(String input, String pattern) {
        return StringUtils.contains(input, pattern, false);
    }

    public static final boolean contains(String input, String pattern, boolean ignoreCase) {
        int n = pattern.length();
        int last = 0;
        int i = 0;
        while (i < n) {
            int k;
            int j;
            int c = 32;
            for (j = i; j < n; ++j) {
                char c2 = pattern.charAt(j);
                if (c2 != ' ' && c2 != '+' && c2 != '*') continue;
                c = c2;
                break;
            }
            if ((k = StringUtils.subset(pattern, i, j, input, last, ignoreCase)) < 0) {
                return false;
            }
            if (c == 32 || c == 43) {
                last = 0;
            } else if (c == 42) {
                last = k + j - i;
            }
            i = j + 1;
        }
        return true;
    }

    private static final int subset(String little, int littleStart, int littleStop, String big, int bigStart, boolean ignoreCase) {
        if (ignoreCase) {
            int n = big.length() - (littleStop - littleStart) + 1;
            block0: for (int i = bigStart; i < n; ++i) {
                int n2 = littleStop - littleStart;
                for (int j = 0; j < n2; ++j) {
                    char c2;
                    char c1 = big.charAt(i + j);
                    if (c1 != (c2 = little.charAt(littleStart + j)) && c1 != StringUtils.toOtherCase(c2)) continue block0;
                }
                return i;
            }
            return -1;
        }
        int n = big.length() - (littleStop - littleStart) + 1;
        block2: for (int i = bigStart; i < n; ++i) {
            int n2 = littleStop - littleStart;
            for (int j = 0; j < n2; ++j) {
                char c2;
                char c1 = big.charAt(i + j);
                if (c1 != (c2 = little.charAt(littleStart + j))) continue block2;
            }
            return i;
        }
        return -1;
    }

    public static final char toOtherCase(char c) {
        char i = c;
        int A = 65;
        int Z = 90;
        int a = 97;
        int z = 122;
        int SHIFT = 32;
        if (i < 'A') {
            return c;
        }
        if (i <= 'Z') {
            return (char)(i + 32);
        }
        if (i < 'a') {
            return c;
        }
        if (i <= 'z') {
            return (char)(i - 32);
        }
        return c;
    }

    public static String[] split(String s, char delimiter) {
        return StringUtils.split(s, Character.toString(delimiter));
    }

    public static String[] split(String s, String delimiters) {
        StringTokenizer tokenizer = new StringTokenizer(s, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        return tokens.toArray(new String[0]);
    }

    public static String[] splitNoCoalesce(String s, char delimiter) {
        return StringUtils.splitNoCoalesce(s, Character.toString(delimiter));
    }

    public static String[] splitNoCoalesce(String s, String delimiters) {
        StringTokenizer tokenizer = new StringTokenizer(s, delimiters, true);
        ArrayList<String> tokens = new ArrayList<String>();
        boolean gotDelimiter = true;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.length() == 1 && delimiters.contains(token)) {
                if (gotDelimiter) {
                    tokens.add("");
                }
                gotDelimiter = true;
                continue;
            }
            tokens.add(token);
            gotDelimiter = false;
        }
        if (gotDelimiter && !tokens.isEmpty()) {
            tokens.add("");
        }
        return tokens.toArray(new String[0]);
    }

    public static boolean startsWithIgnoreCase(String s, String prefix) {
        int pl = prefix.length();
        if (s.length() < pl) {
            return false;
        }
        for (int i = 0; i < pl; ++i) {
            char pc;
            char sc = s.charAt(i);
            if (sc == (pc = prefix.charAt(i)) || (sc = Character.toUpperCase(sc)) == (pc = Character.toUpperCase(pc)) || (sc = Character.toLowerCase(sc)) == (pc = Character.toLowerCase(pc))) continue;
            return false;
        }
        return true;
    }

    public static String replace(String str, String old_str, String new_str) {
        int o = 0;
        StringBuilder buf = new StringBuilder();
        int i = str.indexOf(old_str);
        while (i > -1) {
            if (i > o) {
                buf.append(str.substring(o, i));
            }
            buf.append(new_str);
            o = i + old_str.length();
            i = str.indexOf(old_str, i + 1);
        }
        buf.append(str.substring(o, str.length()));
        return buf.toString();
    }

    public static String truncate(String string, int maxLen) {
        if (string.length() <= maxLen) {
            return string;
        }
        return string.substring(0, maxLen);
    }

    public static int indexOfIgnoreCase(String str, String substring) {
        return StringUtils.indexOfIgnoreCase(str, substring, Locale.getDefault());
    }

    public static int indexOfIgnoreCase(String str, String substring, Locale locale) {
        return str.toLowerCase(locale).indexOf(substring.toLowerCase(locale));
    }

    public static String getASCIIString(byte[] bytes) {
        return StringUtils.getEncodedString(bytes, "ISO-8859-1");
    }

    public static String getUTF8String(byte[] bytes) {
        return StringUtils.getEncodedString(bytes, "UTF-8");
    }

    private static String getEncodedString(byte[] bytes, String encoding) {
        try {
            return new String(bytes, encoding);
        }
        catch (UnsupportedEncodingException impossible) {
            throw new RuntimeException(impossible);
        }
    }

    public static String explode(String[] array, String delimeter) {
        StringBuilder sb = new StringBuilder();
        if (array.length > 0) {
            sb.append(array[0]);
            for (int i = 1; i < array.length; ++i) {
                sb.append(delimeter);
                sb.append(array[i]);
            }
        }
        return sb.toString();
    }

    public static String explode(Collection<String> collection, String delimiter) {
        StringBuilder sb = new StringBuilder();
        if (!collection.isEmpty()) {
            Iterator<String> i = collection.iterator();
            sb.append(i.next());
            while (i.hasNext()) {
                sb.append(delimiter);
                sb.append(i.next());
            }
        }
        return sb.toString();
    }

    public static boolean isNullOrEmpty(String s, boolean trim) {
        return s == null || (trim ? s.trim().length() == 0 : s.length() == 0);
    }

    public static boolean isNullOrEmpty(String s) {
        return StringUtils.isNullOrEmpty(s, false);
    }

    public static String removeDoubleSpaces(String s) {
        return s != null ? s.replaceAll("\\s+", " ") : null;
    }

    public static String getLocaleString(Map<String, String> strMap, String defaultStr) {
        String str;
        String localeLanguageCode = Locale.getDefault().getLanguage();
        if (StringUtils.isNullOrEmpty(localeLanguageCode, true)) {
            localeLanguageCode = "en";
        }
        if (StringUtils.isNullOrEmpty(str = strMap.get(localeLanguageCode), true)) {
            str = defaultStr;
        }
        return str;
    }
}

