/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.util;

import com.frostwire.util.ThreadPool;
import com.frostwire.util.http.HttpClient;
import com.frostwire.util.http.JdkHttpClient;
import com.frostwire.util.http.OKHTTPClient;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;

public class HttpClientFactory {
    private static Map<HttpContext, ThreadPool> okHttpClientPools = null;

    private HttpClientFactory() {
    }

    public static HttpClient newInstance() {
        return new JdkHttpClient();
    }

    public static HttpClient getInstance(HttpContext context) {
        if (HttpClientFactory.isWindowsXP()) {
            return new JdkHttpClient();
        }
        if (okHttpClientPools == null) {
            okHttpClientPools = HttpClientFactory.buildThreadPools();
        }
        return new OKHTTPClient(okHttpClientPools.get((Object)context));
    }

    private static Map<HttpContext, ThreadPool> buildThreadPools() {
        HashMap<HttpContext, ThreadPool> map = new HashMap<HttpContext, ThreadPool>();
        map.put(HttpContext.SEARCH, new ThreadPool("OkHttpClient-searches", 1, 5, 60L, new LinkedBlockingQueue<Runnable>(), true));
        map.put(HttpContext.DOWNLOAD, new ThreadPool("OkHttpClient-downloads", 1, 10, 5L, new LinkedBlockingQueue<Runnable>(), true));
        map.put(HttpContext.MISC, new ThreadPool("OkHttpClient-misc", 2, 10, 30L, new LinkedBlockingQueue<Runnable>(), true));
        return map;
    }

    private static boolean isWindowsXP() {
        String os = System.getProperty("os.name");
        os = os.toLowerCase(Locale.US);
        return os.contains("windows xp");
    }

    public static enum HttpContext {
        SEARCH,
        DOWNLOAD,
        MISC;

    }
}

