/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.transfers;

final class SpeedStat {
    private static final int INTERVAL_MILLISECONDS = 1000;
    private long totalBytes;
    private long averageSpeed;
    private long speedMarkTimestamp;
    private long lastTotalBytes;

    public long totalBytes() {
        return this.totalBytes;
    }

    public long averageSpeed() {
        return this.averageSpeed;
    }

    public void update(long numBytes) {
        long now = System.currentTimeMillis();
        this.totalBytes += numBytes;
        if (now - this.speedMarkTimestamp > 1000L) {
            this.averageSpeed = (this.totalBytes - this.lastTotalBytes) * 1000L / (now - this.speedMarkTimestamp);
            this.speedMarkTimestamp = now;
            this.lastTotalBytes = this.totalBytes;
        }
    }

    public long eta(long size) {
        return SpeedStat.eta(size, this.totalBytes, this.averageSpeed);
    }

    public int progress(long size) {
        return SpeedStat.progress(size, this.totalBytes);
    }

    static long eta(long size, long total, long speed) {
        long left = size - total;
        long rate = speed;
        if (left <= 0L) {
            return 0L;
        }
        if (rate <= 0L) {
            return -1L;
        }
        return left / rate;
    }

    static int progress(long size, long total) {
        return size > 0L ? (int)(total * 100L / size) : 0;
    }
}

