/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.tests;

import com.frostwire.regex.Matcher;
import com.frostwire.regex.Pattern;
import com.frostwire.search.SearchMatcher;
import com.frostwire.search.yify.YifySearchResult;
import com.frostwire.util.ThreadPool;
import com.frostwire.util.http.OKHTTPClient;
import java.util.concurrent.LinkedBlockingQueue;

public final class YifySearchPerformerTest {
    public static void main(String[] args) throws Throwable {
        String TEST_SEARCH_TERM = "one";
        OKHTTPClient httpClient = new OKHTTPClient(new ThreadPool("testPool", 4, new LinkedBlockingQueue<Runnable>(), false));
        String fileStr = httpClient.get("https://www.yify-torrent.org/search/" + TEST_SEARCH_TERM);
        Pattern searchResultsDetailURLPattern = Pattern.compile("(?is)<figcaption><h3><a class=\"movielink\" href=\"/movie/(?<itemId>[0-9]*)/(?<htmlFileName>.*?)\">");
        Pattern detailPagePattern = Pattern.compile("(?is)<section id=\"movie\".*?<h1 itemprop=\"name\">(?<displayName>.*?)</h1>.*?<img itemprop=\"image\" src=\"(?<cover>.*?)\".*?<dt>Size:</dt> <dd>(?<size>.*?)</dd>.*?<dt>Language:</dt> <dd>(?<language>.*?)</dd>.*?<dt>Add Date:</dt> <dd><span.*?>(?<creationDate>.*?)</span></dd>.*?<dt>Seeds:</dt> <dd>(?<seeds>[0-9]+)</dd>.*?<a href=\"(?<magnet>.*?)\" id=\"dm\" class=\"button button-default\".*?>Download Magnet</a>.*?");
        Matcher searchResultsMatcher = searchResultsDetailURLPattern.matcher(fileStr);
        int found = 0;
        while (searchResultsMatcher.find()) {
            System.out.println("\nfound " + ++found);
            System.out.println("result_url: [" + searchResultsMatcher.group(1) + "]");
            String detailUrl = "https://www.yify-torrent.org/torrent/" + searchResultsMatcher.group("itemId") + "/" + searchResultsMatcher.group("htmlFileName");
            System.out.println("Fetching details from " + detailUrl + " ....");
            long start = System.currentTimeMillis();
            String detailPage = httpClient.get(detailUrl, 5000);
            if (detailPage == null) {
                System.out.println("Error fetching from " + detailUrl);
                continue;
            }
            long downloadTime = System.currentTimeMillis() - start;
            System.out.println("Downloaded " + detailPage.length() + " bytes in " + downloadTime + "ms");
            SearchMatcher sm = new SearchMatcher(detailPagePattern.matcher(detailPage));
            if (sm.find()) {
                System.out.println("displayname: [" + sm.group("displayName") + "]");
                System.out.println("infohash: [" + sm.group("infohash") + "]");
                System.out.println("size: [" + sm.group("size") + "]");
                System.out.println("creationDate: [" + sm.group("creationDate") + "]");
                System.out.println("seeds: [" + sm.group("seeds") + "]");
                System.out.println("magnet: [" + sm.group("magnet") + "]");
                YifySearchResult sr = new YifySearchResult(detailUrl, sm);
                System.out.println(sr);
            } else {
                System.out.println("Detail page search matcher failed, check TORRENT_DETAILS_PAGE_REGEX");
            }
            System.out.println("===");
            System.out.println("Sleeping 5 seconds...");
            Thread.sleep(5000L);
        }
        System.out.println("-done-");
        if (found == 0) {
            System.out.println(fileStr);
        }
    }
}

