/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.tests;

import com.frostwire.regex.Matcher;
import com.frostwire.regex.Pattern;
import com.frostwire.search.SearchMatcher;
import com.frostwire.search.eztv.EztvSearchResult;
import com.frostwire.util.HttpClientFactory;
import com.frostwire.util.http.HttpClient;

public final class EztvSearchPerformerTest {
    public static void main(String[] args) throws Throwable {
        String fileStr;
        String TEST_SEARCH_TERM = "foo";
        HttpClient httpClient = HttpClientFactory.newInstance();
        try {
            fileStr = httpClient.get("https://eztv.ag/search/" + TEST_SEARCH_TERM);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.out.println("Aborting test.");
            return;
        }
        Pattern searchResultsDetailURLPattern = Pattern.compile("(?is)<a href=\"(/ep/.*?)\"");
        Pattern detailPagePattern = Pattern.compile("(?is)<td class=\"section_post_header\" colspan=\"2\"><h1><span style.*?>(?<displaynamefallback>.*?)</span></h1></td>.*?Download Links.*?.*<a href=\"(?<magneturl>magnet:\\?.*?)\" class=\"magnet\".*?.*<a href=\"(?<torrenturl>http(s)?.*?\\.torrent)\" class=\"download_.\".*?Seeds: <span.*?>(?<seeds>.*?)</span><br.*?(Torrent Info.*?title=\"(?<displayname>.*?)\".*?)?(<b>Torrent File:</b>\\s+(?<displayname2>.*?)<br.*?)?(<b>Torrent Hash:</b>\\s+(?<infohash>.*?)<br.*?)?<b>Filesize:</b>\\s+(?<filesize>.*?)<br.*?<b>Released:</b>\\s+(?<creationtime>.*?)<br");
        Matcher searchResultsMatcher = searchResultsDetailURLPattern.matcher(fileStr);
        int found = 0;
        while (searchResultsMatcher.find()) {
            String detailPage;
            System.out.println("\nfound " + ++found);
            System.out.println("result_url: [" + searchResultsMatcher.group(1) + "]");
            String detailUrl = "https://eztv.ag" + searchResultsMatcher.group(1);
            System.out.println("Fetching details from " + detailUrl + " ....");
            long start = System.currentTimeMillis();
            try {
                detailPage = httpClient.get(detailUrl, 5000);
            }
            catch (Throwable t) {
                detailPage = null;
            }
            if (detailPage == null) {
                System.out.println("Error fetching from " + detailUrl);
                continue;
            }
            long downloadTime = System.currentTimeMillis() - start;
            System.out.println("Downloaded " + detailPage.length() + " bytes in " + downloadTime + "ms");
            SearchMatcher sm = new SearchMatcher(detailPagePattern.matcher(detailPage));
            if (sm.find()) {
                System.out.println("magneturl: [" + sm.group("magneturl") + "]");
                System.out.println("torrenturl: [" + sm.group("torrenturl") + "]");
                System.out.println("seeds: [" + sm.group("seeds") + "]");
                System.out.println("displayname: [" + sm.group("displayname") + "]");
                System.out.println("displayname2: [" + sm.group("displayname2") + "]");
                System.out.println("displaynamefallback: [" + sm.group("displaynamefallback") + "]");
                System.out.println("infohash: [" + sm.group("infohash") + "]");
                System.out.println("filesize: [" + sm.group("filesize") + "]");
                System.out.println("creationtime: [" + sm.group("creationtime") + "]");
                EztvSearchResult sr = new EztvSearchResult(detailUrl, sm);
                System.out.println(sr);
            } else {
                System.out.println("Detail page search matcher failed, check TORRENT_DETAILS_PAGE_REGEX");
            }
            System.out.println("===");
            System.out.println("Sleeping 5 seconds...");
            Thread.sleep(5000L);
        }
        System.out.println("-done-");
    }
}

