/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.torrent;

import com.frostwire.search.SearchResult;
import com.frostwire.search.torrent.ComparableTorrentJsonItem;
import com.frostwire.search.torrent.TorrentSearchPerformer;
import com.frostwire.search.torrent.TorrentSearchResult;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public abstract class TorrentJsonSearchPerformer<T extends ComparableTorrentJsonItem, R extends TorrentSearchResult>
extends TorrentSearchPerformer {
    private static final int DEFAULT_NUM_CRAWLS = 10;
    private final Comparator<T> itemComparator = new Comparator<T>(){

        @Override
        public int compare(T a, T b) {
            return b.getSeeds() - a.getSeeds();
        }
    };

    private TorrentJsonSearchPerformer(String domainName, long token, String keywords, int timeout, int pages, int numCrawls) {
        super(domainName, token, keywords, timeout, pages, numCrawls);
    }

    public TorrentJsonSearchPerformer(String domainName, long token, String keywords, int timeout, int pages) {
        this(domainName, token, keywords, timeout, pages, 10);
    }

    @Override
    protected final List<? extends SearchResult> searchPage(String page) {
        LinkedList<R> result = new LinkedList<R>();
        List<T> items = this.parseJson(page);
        if (items != null) {
            Collections.sort(items, this.itemComparator);
            for (ComparableTorrentJsonItem item : items) {
                if (this.isStopped()) continue;
                R sr = this.fromItem(item);
                result.add(sr);
            }
        }
        return result;
    }

    protected abstract List<T> parseJson(String var1);

    protected abstract R fromItem(T var1);
}

