/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.soundcloud;

import com.frostwire.search.AbstractFileSearchResult;
import com.frostwire.search.HttpSearchResult;
import com.frostwire.search.StreamableSearchResult;
import com.frostwire.search.soundcloud.SoundcloudItem;
import java.text.SimpleDateFormat;
import java.util.Locale;

public final class SoundcloudSearchResult
extends AbstractFileSearchResult
implements HttpSearchResult,
StreamableSearchResult {
    private static final String DATE_FORMAT = "yyyy/mm/dd HH:mm:ss Z";
    private final String displayName;
    private final String username;
    private final String trackUrl;
    private final String filename;
    private final String source;
    private final String thumbnailUrl;
    private final long date;
    private final String downloadUrl;
    private final long size;

    SoundcloudSearchResult(SoundcloudItem item, String clientId, String appVersion) {
        this.displayName = item.title;
        this.username = this.buildUsername(item);
        this.trackUrl = item.permalink_url;
        this.filename = item.permalink + "-soundcloud.mp3";
        this.size = this.buildSize(item);
        this.source = this.buildSource(item);
        String userAvatarUrl = null;
        if (item.user != null) {
            userAvatarUrl = item.user.avatar_url;
        }
        this.thumbnailUrl = this.buildThumbnailUrl(item.artwork_url != null ? item.artwork_url : userAvatarUrl);
        this.date = this.buildDate(item.created_at);
        this.downloadUrl = this.buildDownloadUrl(item, clientId, appVersion);
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getCreationTime() {
        return this.date;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public String getDetailsUrl() {
        return this.trackUrl;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getStreamUrl() {
        return this.downloadUrl;
    }

    @Override
    public String getThumbnailUrl() {
        return this.thumbnailUrl;
    }

    public String getUsername() {
        return this.username;
    }

    @Override
    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    private String buildUsername(SoundcloudItem item) {
        if (item.user != null && item.user.username != null) {
            return item.user.username;
        }
        return "";
    }

    private long buildSize(SoundcloudItem item) {
        int x = item.duration;
        int y = 128;
        return x * y / 8;
    }

    private String buildSource(SoundcloudItem item) {
        if (item.user != null && item.user.username != null) {
            return "Soundcloud - " + item.user.username;
        }
        return "Soundcloud";
    }

    private String buildThumbnailUrl(String str) {
        String url = null;
        if (str != null) {
            try {
                url = str.substring(0, str.indexOf("-large.")) + "-t300x300.jpg";
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return url;
    }

    private long buildDate(String str) {
        try {
            return new SimpleDateFormat(DATE_FORMAT, Locale.US).parse(str).getTime();
        }
        catch (Throwable e) {
            return System.currentTimeMillis();
        }
    }

    private String buildDownloadUrl(SoundcloudItem item, String clientId, String appVersion) {
        String downloadUrl;
        String clientAppenderChar = item.download_url != null && item.download_url.contains("?") ? "&" : "?";
        String string = downloadUrl = item.download_url != null ? item.download_url : item.stream_url;
        if (downloadUrl.endsWith("/download")) {
            downloadUrl = downloadUrl.replace("/download", "/stream");
        }
        if (clientId != null && appVersion != null) {
            downloadUrl = downloadUrl + clientAppenderChar + "client_id=" + clientId + "&app_version=" + appVersion;
        }
        return downloadUrl;
    }

    @Override
    public String toString() {
        return "SoundcloudSearchResult.getDisplayName(): " + this.getDisplayName();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof SoundcloudSearchResult)) {
            return false;
        }
        SoundcloudSearchResult other = (SoundcloudSearchResult)o;
        return this.getDetailsUrl().equals(other.getDetailsUrl()) && this.getDisplayName().equals(other.getDisplayName()) && this.getDownloadUrl().equals(other.getDownloadUrl());
    }

    public int hashCode() {
        return this.getDetailsUrl().hashCode() + this.getDisplayName().hashCode() + this.getDownloadUrl().hashCode();
    }
}

