/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.limetorrents;

import com.frostwire.search.CrawlableSearchResult;
import com.frostwire.search.SearchMatcher;
import com.frostwire.search.limetorrents.LimeTorrentsSearchResult;
import com.frostwire.search.limetorrents.LimeTorrentsTempSearchResult;
import com.frostwire.search.torrent.TorrentRegexSearchPerformer;

public class LimeTorrentsSearchPerformer
extends TorrentRegexSearchPerformer<LimeTorrentsSearchResult> {
    private static final int MAX_RESULTS = 20;
    private static final String REGEX = "(?is)<a href=\"http://itorrents.org/torrent/(.*?).torrent?(.*?)\" rel=\"nofollow\" class=\"csprite_dl14\"></a><a href=\"(?<itemid>.*?).html?(.*?)\">.*?</a></div>.*?";
    private static final String HTML_REGEX = "(?is)<title>(?<filename>.*?)</title>.*?<span class=\"greenish\">Seeders : (?<seeds>\\d*?)</span>.*?<tr><td align=\"right\"><b>Hash</b> :</td><td>(?<torrentid>.*?)</td></tr>.*?<tr><td align=\"right\"><b>Added</b> :</td><td>(?<time>.*?) in.*?<tr><td align=\"right\"><b>Size</b> :</td><td>(?<filesize>.*?) (?<unit>[A-Z]+)</td></tr>.*?<a href=\"magnet:(?<magnet_part>.*?)\".*?></a>";

    public LimeTorrentsSearchPerformer(String domainName, long token, String keywords, int timeout) {
        super(domainName, token, keywords, timeout, 1, 40, 20, REGEX, HTML_REGEX);
    }

    @Override
    protected String getUrl(int page, String encodedKeywords) {
        String transformedKeywords = encodedKeywords.replace("0%20", "-");
        return "https://" + this.getDomainName() + "/search/all/" + transformedKeywords + "/seeds/1/";
    }

    @Override
    public CrawlableSearchResult fromMatcher(SearchMatcher matcher) {
        String itemId = matcher.group("itemid");
        String transformedId = itemId.replaceFirst("/", "");
        return new LimeTorrentsTempSearchResult(this.getDomainName(), transformedId);
    }

    @Override
    protected int htmlSuffixOffset(String html) {
        int offset = html.indexOf("<div><h3>Latest Searches</h3>");
        return offset > 0 ? offset : 0;
    }

    @Override
    protected LimeTorrentsSearchResult fromHtmlMatcher(CrawlableSearchResult sr, SearchMatcher matcher) {
        return new LimeTorrentsSearchResult(sr.getDetailsUrl(), matcher);
    }

    @Override
    protected boolean isValidHtml(String html) {
        return html != null && !html.contains("Cloudflare");
    }
}

